/* DUPLICATOR-LITE (PHP BUILD MODE) MYSQL SCRIPT CREATED ON : 2025-07-17 12:50:46 */

/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;

SET FOREIGN_KEY_CHECKS = 0;

CREATE TABLE `wphx_actionscheduler_actions` (
  `action_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `hook` varchar(191) NOT NULL,
  `status` varchar(20) NOT NULL,
  `scheduled_date_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  `scheduled_date_local` datetime DEFAULT '0000-00-00 00:00:00',
  `priority` tinyint(3) unsigned NOT NULL DEFAULT 10,
  `args` varchar(191) DEFAULT NULL,
  `schedule` longtext DEFAULT NULL,
  `group_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `attempts` int(11) NOT NULL DEFAULT 0,
  `last_attempt_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  `last_attempt_local` datetime DEFAULT '0000-00-00 00:00:00',
  `claim_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `extended_args` varchar(8000) DEFAULT NULL,
  PRIMARY KEY (`action_id`),
  KEY `hook_status_scheduled_date_gmt` (`hook`(163),`status`,`scheduled_date_gmt`),
  KEY `status_scheduled_date_gmt` (`status`,`scheduled_date_gmt`),
  KEY `scheduled_date_gmt` (`scheduled_date_gmt`),
  KEY `args` (`args`),
  KEY `group_id` (`group_id`),
  KEY `last_attempt_gmt` (`last_attempt_gmt`),
  KEY `claim_id_status_scheduled_date_gmt` (`claim_id`,`status`,`scheduled_date_gmt`)
) ENGINE=InnoDB AUTO_INCREMENT=12189 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wphx_actionscheduler_claims` (
  `claim_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `date_created_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`claim_id`),
  KEY `date_created_gmt` (`date_created_gmt`)
) ENGINE=InnoDB AUTO_INCREMENT=23706 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wphx_actionscheduler_groups` (
  `group_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `slug` varchar(255) NOT NULL,
  PRIMARY KEY (`group_id`),
  KEY `slug` (`slug`(191))
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wphx_actionscheduler_logs` (
  `log_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `action_id` bigint(20) unsigned NOT NULL,
  `message` text NOT NULL,
  `log_date_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  `log_date_local` datetime DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`log_id`),
  KEY `action_id` (`action_id`),
  KEY `log_date_gmt` (`log_date_gmt`)
) ENGINE=InnoDB AUTO_INCREMENT=36515 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wphx_cartflows_ca_cart_abandonment` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `checkout_id` int(11) NOT NULL,
  `email` varchar(100) DEFAULT NULL,
  `cart_contents` longtext DEFAULT NULL,
  `cart_total` decimal(10,2) DEFAULT NULL,
  `session_id` varchar(60) NOT NULL,
  `other_fields` longtext DEFAULT NULL,
  `order_status` enum('normal','abandoned','completed','lost') NOT NULL DEFAULT 'normal',
  `unsubscribed` tinyint(1) DEFAULT 0,
  `coupon_code` varchar(50) DEFAULT NULL,
  `time` datetime DEFAULT NULL,
  PRIMARY KEY (`id`,`session_id`),
  UNIQUE KEY `session_id_UNIQUE` (`session_id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wphx_cartflows_ca_email_history` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `template_id` bigint(20) NOT NULL,
  `ca_session_id` varchar(60) DEFAULT NULL,
  `coupon_code` varchar(50) DEFAULT NULL,
  `scheduled_time` datetime DEFAULT NULL,
  `email_sent` tinyint(1) DEFAULT 0,
  PRIMARY KEY (`id`),
  KEY `template_id` (`template_id`),
  KEY `ca_session_id` (`ca_session_id`),
  CONSTRAINT `wphx_cartflows_ca_email_history_ibfk_1` FOREIGN KEY (`template_id`) REFERENCES `wphx_cartflows_ca_email_templates` (`id`) ON DELETE CASCADE,
  CONSTRAINT `wphx_cartflows_ca_email_history_ibfk_2` FOREIGN KEY (`ca_session_id`) REFERENCES `wphx_cartflows_ca_cart_abandonment` (`session_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wphx_cartflows_ca_email_templates` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `template_name` text NOT NULL,
  `email_subject` text NOT NULL,
  `email_body` mediumtext NOT NULL,
  `is_activated` tinyint(1) NOT NULL DEFAULT 0,
  `frequency` int(11) NOT NULL,
  `frequency_unit` enum('MINUTE','HOUR','DAY') NOT NULL DEFAULT 'MINUTE',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wphx_cartflows_ca_email_templates_meta` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `email_template_id` bigint(20) NOT NULL,
  `meta_key` varchar(255) NOT NULL,
  `meta_value` longtext NOT NULL,
  PRIMARY KEY (`id`),
  KEY `email_template_id` (`email_template_id`),
  CONSTRAINT `wphx_cartflows_ca_email_templates_meta_ibfk_1` FOREIGN KEY (`email_template_id`) REFERENCES `wphx_cartflows_ca_email_templates` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=19 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wphx_commentmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `comment_id` (`comment_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wphx_comments` (
  `comment_ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_post_ID` bigint(20) unsigned NOT NULL DEFAULT 0,
  `comment_author` tinytext NOT NULL,
  `comment_author_email` varchar(100) NOT NULL DEFAULT '',
  `comment_author_url` varchar(200) NOT NULL DEFAULT '',
  `comment_author_IP` varchar(100) NOT NULL DEFAULT '',
  `comment_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_content` text NOT NULL,
  `comment_karma` int(11) NOT NULL DEFAULT 0,
  `comment_approved` varchar(20) NOT NULL DEFAULT '1',
  `comment_agent` varchar(255) NOT NULL DEFAULT '',
  `comment_type` varchar(20) NOT NULL DEFAULT 'comment',
  `comment_parent` bigint(20) unsigned NOT NULL DEFAULT 0,
  `user_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`comment_ID`),
  KEY `comment_post_ID` (`comment_post_ID`),
  KEY `comment_approved_date_gmt` (`comment_approved`,`comment_date_gmt`),
  KEY `comment_date_gmt` (`comment_date_gmt`),
  KEY `comment_parent` (`comment_parent`),
  KEY `comment_author_email` (`comment_author_email`(10)),
  KEY `woo_idx_comment_type` (`comment_type`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wphx_duplicator_packages` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(250) NOT NULL,
  `hash` varchar(50) NOT NULL,
  `status` int(11) NOT NULL,
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `owner` varchar(60) NOT NULL,
  `package` longtext NOT NULL,
  PRIMARY KEY (`id`),
  KEY `hash` (`hash`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wphx_e_events` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `event_data` text DEFAULT NULL,
  `created_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `created_at_index` (`created_at`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wphx_links` (
  `link_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `link_url` varchar(255) NOT NULL DEFAULT '',
  `link_name` varchar(255) NOT NULL DEFAULT '',
  `link_image` varchar(255) NOT NULL DEFAULT '',
  `link_target` varchar(25) NOT NULL DEFAULT '',
  `link_description` varchar(255) NOT NULL DEFAULT '',
  `link_visible` varchar(20) NOT NULL DEFAULT 'Y',
  `link_owner` bigint(20) unsigned NOT NULL DEFAULT 1,
  `link_rating` int(11) NOT NULL DEFAULT 0,
  `link_updated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `link_rel` varchar(255) NOT NULL DEFAULT '',
  `link_notes` mediumtext NOT NULL,
  `link_rss` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`link_id`),
  KEY `link_visible` (`link_visible`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wphx_options` (
  `option_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `option_name` varchar(191) NOT NULL DEFAULT '',
  `option_value` longtext NOT NULL,
  `autoload` varchar(20) NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`option_id`),
  UNIQUE KEY `option_name` (`option_name`),
  KEY `autoload` (`autoload`)
) ENGINE=InnoDB AUTO_INCREMENT=43435 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wphx_postmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `post_id` (`post_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=2075 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wphx_posts` (
  `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_author` bigint(20) unsigned NOT NULL DEFAULT 0,
  `post_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content` longtext NOT NULL,
  `post_title` text NOT NULL,
  `post_excerpt` text NOT NULL,
  `post_status` varchar(20) NOT NULL DEFAULT 'publish',
  `comment_status` varchar(20) NOT NULL DEFAULT 'open',
  `ping_status` varchar(20) NOT NULL DEFAULT 'open',
  `post_password` varchar(255) NOT NULL DEFAULT '',
  `post_name` varchar(200) NOT NULL DEFAULT '',
  `to_ping` text NOT NULL,
  `pinged` text NOT NULL,
  `post_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_modified_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content_filtered` longtext NOT NULL,
  `post_parent` bigint(20) unsigned NOT NULL DEFAULT 0,
  `guid` varchar(255) NOT NULL DEFAULT '',
  `menu_order` int(11) NOT NULL DEFAULT 0,
  `post_type` varchar(20) NOT NULL DEFAULT 'post',
  `post_mime_type` varchar(100) NOT NULL DEFAULT '',
  `comment_count` bigint(20) NOT NULL DEFAULT 0,
  PRIMARY KEY (`ID`),
  KEY `post_name` (`post_name`(191)),
  KEY `type_status_date` (`post_type`,`post_status`,`post_date`,`ID`),
  KEY `post_parent` (`post_parent`),
  KEY `post_author` (`post_author`)
) ENGINE=InnoDB AUTO_INCREMENT=3291 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wphx_term_relationships` (
  `object_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `term_taxonomy_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `term_order` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`object_id`,`term_taxonomy_id`),
  KEY `term_taxonomy_id` (`term_taxonomy_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wphx_term_taxonomy` (
  `term_taxonomy_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `taxonomy` varchar(32) NOT NULL DEFAULT '',
  `description` longtext NOT NULL,
  `parent` bigint(20) unsigned NOT NULL DEFAULT 0,
  `count` bigint(20) NOT NULL DEFAULT 0,
  PRIMARY KEY (`term_taxonomy_id`),
  UNIQUE KEY `term_id_taxonomy` (`term_id`,`taxonomy`),
  KEY `taxonomy` (`taxonomy`)
) ENGINE=InnoDB AUTO_INCREMENT=94 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wphx_termmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `term_id` (`term_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=239 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wphx_terms` (
  `term_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(200) NOT NULL DEFAULT '',
  `slug` varchar(200) NOT NULL DEFAULT '',
  `term_group` bigint(10) NOT NULL DEFAULT 0,
  PRIMARY KEY (`term_id`),
  KEY `slug` (`slug`(191)),
  KEY `name` (`name`(191))
) ENGINE=InnoDB AUTO_INCREMENT=94 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wphx_usermeta` (
  `umeta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`umeta_id`),
  KEY `user_id` (`user_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=100 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wphx_users` (
  `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_login` varchar(60) NOT NULL DEFAULT '',
  `user_pass` varchar(255) NOT NULL DEFAULT '',
  `user_nicename` varchar(50) NOT NULL DEFAULT '',
  `user_email` varchar(100) NOT NULL DEFAULT '',
  `user_url` varchar(100) NOT NULL DEFAULT '',
  `user_registered` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `user_activation_key` varchar(255) NOT NULL DEFAULT '',
  `user_status` int(11) NOT NULL DEFAULT 0,
  `display_name` varchar(250) NOT NULL DEFAULT '',
  PRIMARY KEY (`ID`),
  KEY `user_login_key` (`user_login`),
  KEY `user_nicename` (`user_nicename`),
  KEY `user_email` (`user_email`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wphx_wc_admin_note_actions` (
  `action_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `note_id` bigint(20) unsigned NOT NULL,
  `name` varchar(255) NOT NULL,
  `label` varchar(255) NOT NULL,
  `query` longtext NOT NULL,
  `status` varchar(255) NOT NULL,
  `actioned_text` varchar(255) NOT NULL,
  `nonce_action` varchar(255) DEFAULT NULL,
  `nonce_name` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`action_id`),
  KEY `note_id` (`note_id`)
) ENGINE=InnoDB AUTO_INCREMENT=9287 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wphx_wc_admin_notes` (
  `note_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `type` varchar(20) NOT NULL,
  `locale` varchar(20) NOT NULL,
  `title` longtext NOT NULL,
  `content` longtext NOT NULL,
  `content_data` longtext DEFAULT NULL,
  `status` varchar(200) NOT NULL,
  `source` varchar(200) NOT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_reminder` datetime DEFAULT NULL,
  `is_snoozable` tinyint(1) NOT NULL DEFAULT 0,
  `layout` varchar(20) NOT NULL DEFAULT '',
  `image` varchar(200) DEFAULT NULL,
  `is_deleted` tinyint(1) NOT NULL DEFAULT 0,
  `is_read` tinyint(1) NOT NULL DEFAULT 0,
  `icon` varchar(200) NOT NULL DEFAULT 'info',
  PRIMARY KEY (`note_id`)
) ENGINE=InnoDB AUTO_INCREMENT=78 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wphx_wc_category_lookup` (
  `category_tree_id` bigint(20) unsigned NOT NULL,
  `category_id` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`category_tree_id`,`category_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wphx_wc_customer_lookup` (
  `customer_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned DEFAULT NULL,
  `username` varchar(60) NOT NULL DEFAULT '',
  `first_name` varchar(255) NOT NULL,
  `last_name` varchar(255) NOT NULL,
  `email` varchar(100) DEFAULT NULL,
  `date_last_active` timestamp NULL DEFAULT NULL,
  `date_registered` timestamp NULL DEFAULT NULL,
  `country` char(2) NOT NULL DEFAULT '',
  `postcode` varchar(20) NOT NULL DEFAULT '',
  `city` varchar(100) NOT NULL DEFAULT '',
  `state` varchar(100) NOT NULL DEFAULT '',
  PRIMARY KEY (`customer_id`),
  UNIQUE KEY `user_id` (`user_id`),
  KEY `email` (`email`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wphx_wc_download_log` (
  `download_log_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `timestamp` datetime NOT NULL,
  `permission_id` bigint(20) unsigned NOT NULL,
  `user_id` bigint(20) unsigned DEFAULT NULL,
  `user_ip_address` varchar(100) DEFAULT '',
  PRIMARY KEY (`download_log_id`),
  KEY `permission_id` (`permission_id`),
  KEY `timestamp` (`timestamp`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wphx_wc_order_addresses` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `order_id` bigint(20) unsigned NOT NULL,
  `address_type` varchar(20) DEFAULT NULL,
  `first_name` text DEFAULT NULL,
  `last_name` text DEFAULT NULL,
  `company` text DEFAULT NULL,
  `address_1` text DEFAULT NULL,
  `address_2` text DEFAULT NULL,
  `city` text DEFAULT NULL,
  `state` text DEFAULT NULL,
  `postcode` text DEFAULT NULL,
  `country` text DEFAULT NULL,
  `email` varchar(320) DEFAULT NULL,
  `phone` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `address_type_order_id` (`address_type`,`order_id`),
  KEY `order_id` (`order_id`),
  KEY `email` (`email`(191)),
  KEY `phone` (`phone`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wphx_wc_order_coupon_lookup` (
  `order_id` bigint(20) unsigned NOT NULL,
  `coupon_id` bigint(20) NOT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `discount_amount` double NOT NULL DEFAULT 0,
  PRIMARY KEY (`order_id`,`coupon_id`),
  KEY `coupon_id` (`coupon_id`),
  KEY `date_created` (`date_created`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wphx_wc_order_operational_data` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `order_id` bigint(20) unsigned DEFAULT NULL,
  `created_via` varchar(100) DEFAULT NULL,
  `woocommerce_version` varchar(20) DEFAULT NULL,
  `prices_include_tax` tinyint(1) DEFAULT NULL,
  `coupon_usages_are_counted` tinyint(1) DEFAULT NULL,
  `download_permission_granted` tinyint(1) DEFAULT NULL,
  `cart_hash` varchar(100) DEFAULT NULL,
  `new_order_email_sent` tinyint(1) DEFAULT NULL,
  `order_key` varchar(100) DEFAULT NULL,
  `order_stock_reduced` tinyint(1) DEFAULT NULL,
  `date_paid_gmt` datetime DEFAULT NULL,
  `date_completed_gmt` datetime DEFAULT NULL,
  `shipping_tax_amount` decimal(26,8) DEFAULT NULL,
  `shipping_total_amount` decimal(26,8) DEFAULT NULL,
  `discount_tax_amount` decimal(26,8) DEFAULT NULL,
  `discount_total_amount` decimal(26,8) DEFAULT NULL,
  `recorded_sales` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `order_id` (`order_id`),
  KEY `order_key` (`order_key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wphx_wc_order_product_lookup` (
  `order_item_id` bigint(20) unsigned NOT NULL,
  `order_id` bigint(20) unsigned NOT NULL,
  `product_id` bigint(20) unsigned NOT NULL,
  `variation_id` bigint(20) unsigned NOT NULL,
  `customer_id` bigint(20) unsigned DEFAULT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `product_qty` int(11) NOT NULL,
  `product_net_revenue` double NOT NULL DEFAULT 0,
  `product_gross_revenue` double NOT NULL DEFAULT 0,
  `coupon_amount` double NOT NULL DEFAULT 0,
  `tax_amount` double NOT NULL DEFAULT 0,
  `shipping_amount` double NOT NULL DEFAULT 0,
  `shipping_tax_amount` double NOT NULL DEFAULT 0,
  PRIMARY KEY (`order_item_id`),
  KEY `order_id` (`order_id`),
  KEY `product_id` (`product_id`),
  KEY `customer_id` (`customer_id`),
  KEY `date_created` (`date_created`),
  KEY `customer_product_date` (`customer_id`,`product_id`,`date_created`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wphx_wc_order_stats` (
  `order_id` bigint(20) unsigned NOT NULL,
  `parent_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_created_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_paid` datetime DEFAULT '0000-00-00 00:00:00',
  `date_completed` datetime DEFAULT '0000-00-00 00:00:00',
  `num_items_sold` int(11) NOT NULL DEFAULT 0,
  `total_sales` double NOT NULL DEFAULT 0,
  `tax_total` double NOT NULL DEFAULT 0,
  `shipping_total` double NOT NULL DEFAULT 0,
  `net_total` double NOT NULL DEFAULT 0,
  `returning_customer` tinyint(1) DEFAULT NULL,
  `status` varchar(200) NOT NULL,
  `customer_id` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`order_id`),
  KEY `date_created` (`date_created`),
  KEY `customer_id` (`customer_id`),
  KEY `status` (`status`(191))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wphx_wc_order_tax_lookup` (
  `order_id` bigint(20) unsigned NOT NULL,
  `tax_rate_id` bigint(20) unsigned NOT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `shipping_tax` double NOT NULL DEFAULT 0,
  `order_tax` double NOT NULL DEFAULT 0,
  `total_tax` double NOT NULL DEFAULT 0,
  PRIMARY KEY (`order_id`,`tax_rate_id`),
  KEY `tax_rate_id` (`tax_rate_id`),
  KEY `date_created` (`date_created`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wphx_wc_orders` (
  `id` bigint(20) unsigned NOT NULL,
  `status` varchar(20) DEFAULT NULL,
  `currency` varchar(10) DEFAULT NULL,
  `type` varchar(20) DEFAULT NULL,
  `tax_amount` decimal(26,8) DEFAULT NULL,
  `total_amount` decimal(26,8) DEFAULT NULL,
  `customer_id` bigint(20) unsigned DEFAULT NULL,
  `billing_email` varchar(320) DEFAULT NULL,
  `date_created_gmt` datetime DEFAULT NULL,
  `date_updated_gmt` datetime DEFAULT NULL,
  `parent_order_id` bigint(20) unsigned DEFAULT NULL,
  `payment_method` varchar(100) DEFAULT NULL,
  `payment_method_title` text DEFAULT NULL,
  `transaction_id` varchar(100) DEFAULT NULL,
  `ip_address` varchar(100) DEFAULT NULL,
  `user_agent` text DEFAULT NULL,
  `customer_note` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `status` (`status`),
  KEY `date_created` (`date_created_gmt`),
  KEY `customer_id_billing_email` (`customer_id`,`billing_email`(171)),
  KEY `billing_email` (`billing_email`(191)),
  KEY `type_status_date` (`type`,`status`,`date_created_gmt`),
  KEY `parent_order_id` (`parent_order_id`),
  KEY `date_updated` (`date_updated_gmt`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wphx_wc_orders_meta` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `order_id` bigint(20) unsigned DEFAULT NULL,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `meta_key_value` (`meta_key`(100),`meta_value`(82)),
  KEY `order_id_meta_key_meta_value` (`order_id`,`meta_key`(100),`meta_value`(82))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wphx_wc_product_attributes_lookup` (
  `product_id` bigint(20) NOT NULL,
  `product_or_parent_id` bigint(20) NOT NULL,
  `taxonomy` varchar(32) NOT NULL,
  `term_id` bigint(20) NOT NULL,
  `is_variation_attribute` tinyint(1) NOT NULL,
  `in_stock` tinyint(1) NOT NULL,
  PRIMARY KEY (`product_or_parent_id`,`term_id`,`product_id`,`taxonomy`),
  KEY `is_variation_attribute_term_id` (`is_variation_attribute`,`term_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wphx_wc_product_download_directories` (
  `url_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `url` varchar(256) NOT NULL,
  `enabled` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`url_id`),
  KEY `url` (`url`(191))
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wphx_wc_product_meta_lookup` (
  `product_id` bigint(20) NOT NULL,
  `sku` varchar(100) DEFAULT '',
  `global_unique_id` varchar(100) DEFAULT '',
  `virtual` tinyint(1) DEFAULT 0,
  `downloadable` tinyint(1) DEFAULT 0,
  `min_price` decimal(19,4) DEFAULT NULL,
  `max_price` decimal(19,4) DEFAULT NULL,
  `onsale` tinyint(1) DEFAULT 0,
  `stock_quantity` double DEFAULT NULL,
  `stock_status` varchar(100) DEFAULT 'instock',
  `rating_count` bigint(20) DEFAULT 0,
  `average_rating` decimal(3,2) DEFAULT 0.00,
  `total_sales` bigint(20) DEFAULT 0,
  `tax_status` varchar(100) DEFAULT 'taxable',
  `tax_class` varchar(100) DEFAULT '',
  PRIMARY KEY (`product_id`),
  KEY `virtual` (`virtual`),
  KEY `downloadable` (`downloadable`),
  KEY `stock_status` (`stock_status`),
  KEY `stock_quantity` (`stock_quantity`),
  KEY `onsale` (`onsale`),
  KEY `min_max_price` (`min_price`,`max_price`),
  KEY `sku` (`sku`(50))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wphx_wc_rate_limits` (
  `rate_limit_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `rate_limit_key` varchar(200) NOT NULL,
  `rate_limit_expiry` bigint(20) unsigned NOT NULL,
  `rate_limit_remaining` smallint(10) NOT NULL DEFAULT 0,
  PRIMARY KEY (`rate_limit_id`),
  UNIQUE KEY `rate_limit_key` (`rate_limit_key`(191))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wphx_wc_reserved_stock` (
  `order_id` bigint(20) NOT NULL,
  `product_id` bigint(20) NOT NULL,
  `stock_quantity` double NOT NULL DEFAULT 0,
  `timestamp` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `expires` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`order_id`,`product_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wphx_wc_tax_rate_classes` (
  `tax_rate_class_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(200) NOT NULL DEFAULT '',
  `slug` varchar(200) NOT NULL DEFAULT '',
  PRIMARY KEY (`tax_rate_class_id`),
  UNIQUE KEY `slug` (`slug`(191))
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wphx_wc_webhooks` (
  `webhook_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `status` varchar(200) NOT NULL,
  `name` text NOT NULL,
  `user_id` bigint(20) unsigned NOT NULL,
  `delivery_url` text NOT NULL,
  `secret` text NOT NULL,
  `topic` varchar(200) NOT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_created_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_modified_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `api_version` smallint(4) NOT NULL,
  `failure_count` smallint(10) NOT NULL DEFAULT 0,
  `pending_delivery` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`webhook_id`),
  KEY `user_id` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wphx_woocommerce_api_keys` (
  `key_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned NOT NULL,
  `description` varchar(200) DEFAULT NULL,
  `permissions` varchar(10) NOT NULL,
  `consumer_key` char(64) NOT NULL,
  `consumer_secret` char(43) NOT NULL,
  `nonces` longtext DEFAULT NULL,
  `truncated_key` char(7) NOT NULL,
  `last_access` datetime DEFAULT NULL,
  PRIMARY KEY (`key_id`),
  KEY `consumer_key` (`consumer_key`),
  KEY `consumer_secret` (`consumer_secret`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wphx_woocommerce_attribute_taxonomies` (
  `attribute_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `attribute_name` varchar(200) NOT NULL,
  `attribute_label` varchar(200) DEFAULT NULL,
  `attribute_type` varchar(20) NOT NULL,
  `attribute_orderby` varchar(20) NOT NULL,
  `attribute_public` int(1) NOT NULL DEFAULT 1,
  PRIMARY KEY (`attribute_id`),
  KEY `attribute_name` (`attribute_name`(20))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wphx_woocommerce_downloadable_product_permissions` (
  `permission_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `download_id` varchar(36) NOT NULL,
  `product_id` bigint(20) unsigned NOT NULL,
  `order_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `order_key` varchar(200) NOT NULL,
  `user_email` varchar(200) NOT NULL,
  `user_id` bigint(20) unsigned DEFAULT NULL,
  `downloads_remaining` varchar(9) DEFAULT NULL,
  `access_granted` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `access_expires` datetime DEFAULT NULL,
  `download_count` bigint(20) unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`permission_id`),
  KEY `download_order_key_product` (`product_id`,`order_id`,`order_key`(16),`download_id`),
  KEY `download_order_product` (`download_id`,`order_id`,`product_id`),
  KEY `order_id` (`order_id`),
  KEY `user_order_remaining_expires` (`user_id`,`order_id`,`downloads_remaining`,`access_expires`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wphx_woocommerce_log` (
  `log_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `timestamp` datetime NOT NULL,
  `level` smallint(4) NOT NULL,
  `source` varchar(200) NOT NULL,
  `message` longtext NOT NULL,
  `context` longtext DEFAULT NULL,
  PRIMARY KEY (`log_id`),
  KEY `level` (`level`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wphx_woocommerce_order_itemmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `order_item_id` bigint(20) unsigned NOT NULL,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `order_item_id` (`order_item_id`),
  KEY `meta_key` (`meta_key`(32))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wphx_woocommerce_order_items` (
  `order_item_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `order_item_name` text NOT NULL,
  `order_item_type` varchar(200) NOT NULL DEFAULT '',
  `order_id` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`order_item_id`),
  KEY `order_id` (`order_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wphx_woocommerce_payment_tokenmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `payment_token_id` bigint(20) unsigned NOT NULL,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `payment_token_id` (`payment_token_id`),
  KEY `meta_key` (`meta_key`(32))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wphx_woocommerce_payment_tokens` (
  `token_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `gateway_id` varchar(200) NOT NULL,
  `token` text NOT NULL,
  `user_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `type` varchar(200) NOT NULL,
  `is_default` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`token_id`),
  KEY `user_id` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wphx_woocommerce_sessions` (
  `session_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `session_key` char(32) NOT NULL,
  `session_value` longtext NOT NULL,
  `session_expiry` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`session_id`),
  UNIQUE KEY `session_key` (`session_key`)
) ENGINE=InnoDB AUTO_INCREMENT=93 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wphx_woocommerce_shipping_zone_locations` (
  `location_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `zone_id` bigint(20) unsigned NOT NULL,
  `location_code` varchar(200) NOT NULL,
  `location_type` varchar(40) NOT NULL,
  PRIMARY KEY (`location_id`),
  KEY `zone_id` (`zone_id`),
  KEY `location_type_code` (`location_type`(10),`location_code`(20))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wphx_woocommerce_shipping_zone_methods` (
  `zone_id` bigint(20) unsigned NOT NULL,
  `instance_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `method_id` varchar(200) NOT NULL,
  `method_order` bigint(20) unsigned NOT NULL,
  `is_enabled` tinyint(1) NOT NULL DEFAULT 1,
  PRIMARY KEY (`instance_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wphx_woocommerce_shipping_zones` (
  `zone_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `zone_name` varchar(200) NOT NULL,
  `zone_order` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`zone_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wphx_woocommerce_tax_rate_locations` (
  `location_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `location_code` varchar(200) NOT NULL,
  `tax_rate_id` bigint(20) unsigned NOT NULL,
  `location_type` varchar(40) NOT NULL,
  PRIMARY KEY (`location_id`),
  KEY `tax_rate_id` (`tax_rate_id`),
  KEY `location_type_code` (`location_type`(10),`location_code`(20))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wphx_woocommerce_tax_rates` (
  `tax_rate_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `tax_rate_country` varchar(2) NOT NULL DEFAULT '',
  `tax_rate_state` varchar(200) NOT NULL DEFAULT '',
  `tax_rate` varchar(8) NOT NULL DEFAULT '',
  `tax_rate_name` varchar(200) NOT NULL DEFAULT '',
  `tax_rate_priority` bigint(20) unsigned NOT NULL,
  `tax_rate_compound` int(1) NOT NULL DEFAULT 0,
  `tax_rate_shipping` int(1) NOT NULL DEFAULT 1,
  `tax_rate_order` bigint(20) unsigned NOT NULL,
  `tax_rate_class` varchar(200) NOT NULL DEFAULT '',
  PRIMARY KEY (`tax_rate_id`),
  KEY `tax_rate_country` (`tax_rate_country`),
  KEY `tax_rate_state` (`tax_rate_state`(2)),
  KEY `tax_rate_class` (`tax_rate_class`(10)),
  KEY `tax_rate_priority` (`tax_rate_priority`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wphx_wpfm_backup` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `backup_name` text DEFAULT NULL,
  `backup_date` text DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wphx_wpforms_logs` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `title` varchar(255) NOT NULL,
  `message` longtext NOT NULL,
  `types` varchar(255) NOT NULL,
  `create_at` datetime NOT NULL,
  `form_id` bigint(20) DEFAULT NULL,
  `entry_id` bigint(20) DEFAULT NULL,
  `user_id` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wphx_wpforms_payment_meta` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `payment_id` bigint(20) NOT NULL,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `payment_id` (`payment_id`),
  KEY `meta_key` (`meta_key`(191)),
  KEY `meta_value` (`meta_value`(191))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wphx_wpforms_payments` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `form_id` bigint(20) NOT NULL,
  `status` varchar(10) NOT NULL DEFAULT '',
  `subtotal_amount` decimal(26,8) NOT NULL DEFAULT 0.00000000,
  `discount_amount` decimal(26,8) NOT NULL DEFAULT 0.00000000,
  `total_amount` decimal(26,8) NOT NULL DEFAULT 0.00000000,
  `currency` varchar(3) NOT NULL DEFAULT '',
  `entry_id` bigint(20) NOT NULL DEFAULT 0,
  `gateway` varchar(20) NOT NULL DEFAULT '',
  `type` varchar(12) NOT NULL DEFAULT '',
  `mode` varchar(4) NOT NULL DEFAULT '',
  `transaction_id` varchar(40) NOT NULL DEFAULT '',
  `customer_id` varchar(40) NOT NULL DEFAULT '',
  `subscription_id` varchar(40) NOT NULL DEFAULT '',
  `subscription_status` varchar(10) NOT NULL DEFAULT '',
  `title` varchar(255) NOT NULL DEFAULT '',
  `date_created_gmt` datetime NOT NULL,
  `date_updated_gmt` datetime NOT NULL,
  `is_published` tinyint(1) NOT NULL DEFAULT 1,
  PRIMARY KEY (`id`),
  KEY `form_id` (`form_id`),
  KEY `status` (`status`(8)),
  KEY `total_amount` (`total_amount`),
  KEY `type` (`type`(8)),
  KEY `transaction_id` (`transaction_id`(32)),
  KEY `customer_id` (`customer_id`(32)),
  KEY `subscription_id` (`subscription_id`(32)),
  KEY `subscription_status` (`subscription_status`(8)),
  KEY `title` (`title`(64))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wphx_wpforms_tasks_meta` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `action` varchar(255) NOT NULL,
  `data` longtext NOT NULL,
  `date` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=16 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

/***** TABLE CREATION END *****/


/* INSERT TABLE DATA: wphx_actionscheduler_actions */
INSERT INTO `wphx_actionscheduler_actions` VALUES("15", "woocommerce_admin/stored_state_setup_for_products/async/run_remote_notifications", "failed", "2025-04-13 09:32:32", "2025-04-13 09:32:32", "10", "[]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2025-04-13 09:32:34", "2025-04-13 09:32:34", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("6391", "cartflows_ca_send_report_summary_email", "complete", "2025-06-16 15:12:16", "2025-06-16 15:12:16", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750086736;s:18:\"\0*\0first_timestamp\";i:1744639200;s:13:\"\0*\0recurrence\";i:604800;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750086736;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:604800;}", "2", "1", "2025-06-16 15:14:31", "2025-06-16 15:14:31", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7261", "wpforms_email_summaries_fetch_info_blocks", "complete", "2025-06-22 10:55:33", "2025-06-22 10:55:33", "10", "{\"tasks_meta_id\":null}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750589733;s:18:\"\0*\0first_timestamp\";i:1744412523;s:13:\"\0*\0recurrence\";i:604800;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750589733;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:604800;}", "3", "1", "2025-06-22 11:19:07", "2025-06-22 11:19:07", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7306", "woocommerce_cleanup_draft_orders", "complete", "2025-06-16 20:49:40", "2025-06-16 20:49:40", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750106980;s:18:\"\0*\0first_timestamp\";i:1744536626;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750106980;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-06-16 20:55:10", "2025-06-16 20:55:10", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7307", "wpforms_process_forms_locator_scan", "complete", "2025-06-16 20:49:40", "2025-06-16 20:49:40", "10", "{\"tasks_meta_id\":1}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750106980;s:18:\"\0*\0first_timestamp\";i:1744536754;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750106980;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2025-06-16 20:55:10", "2025-06-16 20:55:10", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7308", "wpforms_process_purge_spam", "complete", "2025-06-16 20:49:40", "2025-06-16 20:49:40", "10", "{\"tasks_meta_id\":2}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750106980;s:18:\"\0*\0first_timestamp\";i:1744536754;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750106980;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2025-06-16 20:55:10", "2025-06-16 20:55:10", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7452", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-16 12:51:27", "2025-06-16 12:51:27", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750078287;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750078287;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-16 13:05:53", "2025-06-16 13:05:53", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7453", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-16 12:51:33", "2025-06-16 12:51:33", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750078293;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750078293;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-16 13:05:58", "2025-06-16 13:05:58", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7454", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-16 13:10:53", "2025-06-16 13:10:53", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750079453;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750079453;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-16 13:15:47", "2025-06-16 13:15:47", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7455", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-16 13:10:58", "2025-06-16 13:10:58", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750079458;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750079458;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-16 13:15:52", "2025-06-16 13:15:52", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7456", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-16 13:20:47", "2025-06-16 13:20:47", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750080047;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750080047;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-16 13:34:12", "2025-06-16 13:34:12", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7457", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-16 13:20:52", "2025-06-16 13:20:52", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750080052;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750080052;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-16 13:34:18", "2025-06-16 13:34:18", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7458", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-16 13:39:12", "2025-06-16 13:39:12", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750081152;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750081152;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-16 13:49:15", "2025-06-16 13:49:15", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7459", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-16 13:39:18", "2025-06-16 13:39:18", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750081158;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750081158;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-16 13:49:20", "2025-06-16 13:49:20", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7460", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-16 13:54:15", "2025-06-16 13:54:15", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750082055;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750082055;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-16 14:02:09", "2025-06-16 14:02:09", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7461", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-16 13:54:20", "2025-06-16 13:54:20", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750082060;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750082060;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-16 14:02:14", "2025-06-16 14:02:14", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7462", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-16 14:07:09", "2025-06-16 14:07:09", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750082829;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750082829;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-16 14:12:41", "2025-06-16 14:12:41", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7463", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-16 14:07:14", "2025-06-16 14:07:14", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750082834;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750082834;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-16 14:12:46", "2025-06-16 14:12:46", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7464", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-16 14:17:41", "2025-06-16 14:17:41", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750083461;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750083461;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-16 14:25:28", "2025-06-16 14:25:28", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7465", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-16 14:17:46", "2025-06-16 14:17:46", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750083466;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750083466;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-16 14:25:33", "2025-06-16 14:25:33", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7466", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-16 14:30:28", "2025-06-16 14:30:28", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750084228;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750084228;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-16 14:31:07", "2025-06-16 14:31:07", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7467", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-16 14:30:33", "2025-06-16 14:30:33", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750084233;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750084233;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-16 14:31:13", "2025-06-16 14:31:13", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7468", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-16 14:36:07", "2025-06-16 14:36:07", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750084567;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750084567;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-16 14:39:21", "2025-06-16 14:39:21", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7469", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-16 14:36:13", "2025-06-16 14:36:13", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750084573;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750084573;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-16 14:39:26", "2025-06-16 14:39:26", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7470", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-16 14:44:21", "2025-06-16 14:44:21", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750085061;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750085061;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-16 14:47:32", "2025-06-16 14:47:32", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7471", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-16 14:44:26", "2025-06-16 14:44:26", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750085066;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750085066;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-16 14:47:37", "2025-06-16 14:47:37", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7472", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-16 14:52:32", "2025-06-16 14:52:32", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750085552;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750085552;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-16 14:55:26", "2025-06-16 14:55:26", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7473", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-16 14:52:37", "2025-06-16 14:52:37", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750085557;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750085557;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-16 14:55:31", "2025-06-16 14:55:31", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7474", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-16 15:00:26", "2025-06-16 15:00:26", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750086026;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750086026;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-16 15:14:26", "2025-06-16 15:14:26", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7475", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-16 15:00:31", "2025-06-16 15:00:31", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750086031;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750086031;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-16 15:14:31", "2025-06-16 15:14:31", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7476", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-16 15:19:26", "2025-06-16 15:19:26", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750087166;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750087166;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-16 15:27:17", "2025-06-16 15:27:17", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7477", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-16 15:19:31", "2025-06-16 15:19:31", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750087171;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750087171;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-16 15:27:22", "2025-06-16 15:27:22", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7478", "cartflows_ca_send_report_summary_email", "complete", "2025-06-23 15:14:31", "2025-06-23 15:14:31", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750691671;s:18:\"\0*\0first_timestamp\";i:1744639200;s:13:\"\0*\0recurrence\";i:604800;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750691671;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:604800;}", "2", "1", "2025-06-23 15:54:52", "2025-06-23 15:54:52", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7479", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-16 15:32:17", "2025-06-16 15:32:17", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750087937;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750087937;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-16 15:34:56", "2025-06-16 15:34:56", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7480", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-16 15:32:22", "2025-06-16 15:32:22", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750087942;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750087942;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-16 15:35:01", "2025-06-16 15:35:01", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7481", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-16 15:39:56", "2025-06-16 15:39:56", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750088396;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750088396;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-16 15:42:35", "2025-06-16 15:42:35", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7482", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-16 15:40:01", "2025-06-16 15:40:01", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750088401;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750088401;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-16 15:42:40", "2025-06-16 15:42:40", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7483", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-16 15:47:35", "2025-06-16 15:47:35", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750088855;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750088855;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-16 15:50:16", "2025-06-16 15:50:16", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7484", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-16 15:47:40", "2025-06-16 15:47:40", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750088860;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750088860;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-16 15:50:21", "2025-06-16 15:50:21", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7485", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-16 15:55:16", "2025-06-16 15:55:16", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750089316;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750089316;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-16 16:22:58", "2025-06-16 16:22:58", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7486", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-16 15:55:21", "2025-06-16 15:55:21", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750089321;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750089321;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-16 16:23:04", "2025-06-16 16:23:04", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7487", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-16 16:27:58", "2025-06-16 16:27:58", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750091278;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750091278;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-16 16:29:21", "2025-06-16 16:29:21", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7488", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-16 16:28:04", "2025-06-16 16:28:04", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750091284;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750091284;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-16 16:29:26", "2025-06-16 16:29:26", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7489", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-16 16:34:21", "2025-06-16 16:34:21", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750091661;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750091661;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-16 16:37:00", "2025-06-16 16:37:00", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7490", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-16 16:34:26", "2025-06-16 16:34:26", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750091666;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750091666;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-16 16:37:06", "2025-06-16 16:37:06", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7491", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-16 16:42:00", "2025-06-16 16:42:00", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750092120;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750092120;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-16 16:44:30", "2025-06-16 16:44:30", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7492", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-16 16:42:06", "2025-06-16 16:42:06", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750092126;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750092126;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-16 16:44:35", "2025-06-16 16:44:35", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7493", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-16 16:49:30", "2025-06-16 16:49:30", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750092570;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750092570;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-16 16:51:52", "2025-06-16 16:51:52", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7494", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-16 16:49:35", "2025-06-16 16:49:35", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750092575;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750092575;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-16 16:51:58", "2025-06-16 16:51:58", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7495", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-16 16:56:52", "2025-06-16 16:56:52", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750093012;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750093012;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-16 16:58:12", "2025-06-16 16:58:12", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7496", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-16 16:56:58", "2025-06-16 16:56:58", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750093018;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750093018;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-16 16:58:17", "2025-06-16 16:58:17", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7497", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-16 17:03:12", "2025-06-16 17:03:12", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750093392;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750093392;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-16 17:09:41", "2025-06-16 17:09:41", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7498", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-16 17:03:17", "2025-06-16 17:03:17", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750093397;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750093397;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-16 17:09:46", "2025-06-16 17:09:46", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7499", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-16 17:14:41", "2025-06-16 17:14:41", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750094081;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750094081;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-16 17:22:25", "2025-06-16 17:22:25", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7500", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-16 17:14:46", "2025-06-16 17:14:46", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750094086;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750094086;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-16 17:22:30", "2025-06-16 17:22:30", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7501", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-16 17:27:25", "2025-06-16 17:27:25", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750094845;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750094845;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-16 17:35:00", "2025-06-16 17:35:00", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7502", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-16 17:27:30", "2025-06-16 17:27:30", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750094850;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750094850;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-16 17:35:06", "2025-06-16 17:35:06", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7503", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-16 17:40:00", "2025-06-16 17:40:00", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750095600;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750095600;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-16 17:45:08", "2025-06-16 17:45:08", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7504", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-16 17:40:06", "2025-06-16 17:40:06", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750095606;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750095606;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-16 17:45:13", "2025-06-16 17:45:13", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7505", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-16 17:50:08", "2025-06-16 17:50:08", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750096208;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750096208;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-16 17:52:43", "2025-06-16 17:52:43", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7506", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-16 17:50:13", "2025-06-16 17:50:13", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750096213;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750096213;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-16 17:52:48", "2025-06-16 17:52:48", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7507", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-16 17:57:43", "2025-06-16 17:57:43", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750096663;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750096663;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-16 18:00:06", "2025-06-16 18:00:06", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7508", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-16 17:57:48", "2025-06-16 17:57:48", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750096668;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750096668;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-16 18:09:18", "2025-06-16 18:09:18", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7509", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-16 18:05:06", "2025-06-16 18:05:06", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750097106;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750097106;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-16 18:09:24", "2025-06-16 18:09:24", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7510", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-16 18:14:18", "2025-06-16 18:14:18", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750097658;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750097658;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-16 18:15:45", "2025-06-16 18:15:45", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7511", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-16 18:14:24", "2025-06-16 18:14:24", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750097664;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750097664;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-16 18:15:50", "2025-06-16 18:15:50", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7512", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-16 18:20:45", "2025-06-16 18:20:45", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750098045;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750098045;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-16 18:23:23", "2025-06-16 18:23:23", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7513", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-16 18:20:50", "2025-06-16 18:20:50", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750098050;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750098050;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-16 18:23:28", "2025-06-16 18:23:28", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7514", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-16 18:28:23", "2025-06-16 18:28:23", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750098503;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750098503;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-16 18:28:35", "2025-06-16 18:28:35", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7515", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-16 18:28:28", "2025-06-16 18:28:28", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750098508;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750098508;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-16 18:28:40", "2025-06-16 18:28:40", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7516", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-16 18:33:35", "2025-06-16 18:33:35", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750098815;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750098815;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-16 18:38:24", "2025-06-16 18:38:24", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7517", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-16 18:33:40", "2025-06-16 18:33:40", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750098820;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750098820;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-16 18:38:28", "2025-06-16 18:38:28", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7518", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-16 18:43:24", "2025-06-16 18:43:24", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750099404;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750099404;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-16 18:46:37", "2025-06-16 18:46:37", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7519", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-16 18:43:28", "2025-06-16 18:43:28", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750099408;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750099408;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-16 18:46:43", "2025-06-16 18:46:43", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7520", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-16 18:51:37", "2025-06-16 18:51:37", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750099897;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750099897;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-16 18:52:28", "2025-06-16 18:52:28", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7521", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-16 18:51:43", "2025-06-16 18:51:43", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750099903;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750099903;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-16 18:52:33", "2025-06-16 18:52:33", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7522", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-16 18:57:28", "2025-06-16 18:57:28", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750100248;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750100248;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-16 19:18:19", "2025-06-16 19:18:19", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7523", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-16 18:57:33", "2025-06-16 18:57:33", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750100253;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750100253;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-16 19:18:24", "2025-06-16 19:18:24", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7524", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-16 19:23:19", "2025-06-16 19:23:19", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750101799;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750101799;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-16 19:25:18", "2025-06-16 19:25:18", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7525", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-16 19:23:24", "2025-06-16 19:23:24", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750101804;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750101804;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-16 19:25:24", "2025-06-16 19:25:24", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7526", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-16 19:30:18", "2025-06-16 19:30:18", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750102218;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750102218;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-16 19:31:55", "2025-06-16 19:31:55", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7527", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-16 19:30:24", "2025-06-16 19:30:24", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750102224;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750102224;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-16 19:32:00", "2025-06-16 19:32:00", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7528", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-16 19:36:55", "2025-06-16 19:36:55", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750102615;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750102615;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-16 19:40:37", "2025-06-16 19:40:37", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7529", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-16 19:37:00", "2025-06-16 19:37:00", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750102620;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750102620;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-16 19:40:42", "2025-06-16 19:40:42", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7530", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-16 19:45:37", "2025-06-16 19:45:37", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750103137;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750103137;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-16 19:45:43", "2025-06-16 19:45:43", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7531", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-16 19:45:42", "2025-06-16 19:45:42", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750103142;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750103142;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-16 19:45:48", "2025-06-16 19:45:48", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7532", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-16 19:50:43", "2025-06-16 19:50:43", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750103443;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750103443;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-16 19:55:27", "2025-06-16 19:55:27", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7533", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-16 19:50:48", "2025-06-16 19:50:48", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750103448;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750103448;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-16 19:55:32", "2025-06-16 19:55:32", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7534", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-16 20:00:27", "2025-06-16 20:00:27", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750104027;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750104027;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-16 20:03:17", "2025-06-16 20:03:17", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7535", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-16 20:00:32", "2025-06-16 20:00:32", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750104032;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750104032;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-16 20:03:21", "2025-06-16 20:03:21", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7536", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-16 20:08:17", "2025-06-16 20:08:17", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750104497;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750104497;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-16 20:08:44", "2025-06-16 20:08:44", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7537", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-16 20:08:21", "2025-06-16 20:08:21", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750104501;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750104501;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-16 20:08:49", "2025-06-16 20:08:49", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7538", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-16 20:13:44", "2025-06-16 20:13:44", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750104824;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750104824;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-16 20:17:38", "2025-06-16 20:17:38", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7539", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-16 20:13:49", "2025-06-16 20:13:49", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750104829;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750104829;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-16 20:17:43", "2025-06-16 20:17:43", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7540", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-16 20:22:38", "2025-06-16 20:22:38", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750105358;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750105358;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-16 20:32:37", "2025-06-16 20:32:37", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7541", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-16 20:22:43", "2025-06-16 20:22:43", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750105363;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750105363;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-16 20:32:42", "2025-06-16 20:32:42", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7542", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-16 20:37:37", "2025-06-16 20:37:37", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750106257;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750106257;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-16 20:40:11", "2025-06-16 20:40:11", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7543", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-16 20:37:42", "2025-06-16 20:37:42", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750106262;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750106262;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-16 20:40:16", "2025-06-16 20:40:16", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7544", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-16 20:45:11", "2025-06-16 20:45:11", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750106711;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750106711;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-16 20:47:44", "2025-06-16 20:47:44", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7545", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-16 20:45:16", "2025-06-16 20:45:16", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750106716;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750106716;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-16 20:47:49", "2025-06-16 20:47:49", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7546", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-16 20:52:44", "2025-06-16 20:52:44", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750107164;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750107164;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-16 20:55:16", "2025-06-16 20:55:16", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7547", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-16 20:52:49", "2025-06-16 20:52:49", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750107169;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750107169;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-16 20:55:21", "2025-06-16 20:55:21", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7548", "woocommerce_cleanup_draft_orders", "complete", "2025-06-17 20:55:10", "2025-06-17 20:55:10", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750193710;s:18:\"\0*\0first_timestamp\";i:1744536626;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750193710;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-06-17 20:55:35", "2025-06-17 20:55:35", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7549", "wpforms_process_forms_locator_scan", "complete", "2025-06-17 20:55:10", "2025-06-17 20:55:10", "10", "{\"tasks_meta_id\":1}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750193710;s:18:\"\0*\0first_timestamp\";i:1744536754;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750193710;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2025-06-17 20:55:35", "2025-06-17 20:55:35", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7550", "wpforms_process_purge_spam", "complete", "2025-06-17 20:55:10", "2025-06-17 20:55:10", "10", "{\"tasks_meta_id\":2}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750193710;s:18:\"\0*\0first_timestamp\";i:1744536754;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750193710;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2025-06-17 20:55:35", "2025-06-17 20:55:35", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7551", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-16 21:00:16", "2025-06-16 21:00:16", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750107616;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750107616;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-16 21:26:25", "2025-06-16 21:26:25", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7552", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-16 21:00:21", "2025-06-16 21:00:21", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750107621;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750107621;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-16 21:26:30", "2025-06-16 21:26:30", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7553", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-16 21:31:25", "2025-06-16 21:31:25", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750109485;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750109485;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-16 21:34:02", "2025-06-16 21:34:02", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7554", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-16 21:31:30", "2025-06-16 21:31:30", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750109490;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750109490;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-16 21:34:07", "2025-06-16 21:34:07", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7555", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-16 21:39:02", "2025-06-16 21:39:02", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750109942;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750109942;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-16 21:41:40", "2025-06-16 21:41:40", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7556", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-16 21:39:07", "2025-06-16 21:39:07", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750109947;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750109947;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-16 21:41:45", "2025-06-16 21:41:45", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7557", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-16 21:46:40", "2025-06-16 21:46:40", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750110400;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750110400;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-16 21:49:23", "2025-06-16 21:49:23", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7558", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-16 21:46:45", "2025-06-16 21:46:45", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750110405;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750110405;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-16 21:49:28", "2025-06-16 21:49:28", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7559", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-16 21:54:23", "2025-06-16 21:54:23", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750110863;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750110863;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-16 21:56:57", "2025-06-16 21:56:57", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7560", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-16 21:54:28", "2025-06-16 21:54:28", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750110868;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750110868;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-16 21:57:02", "2025-06-16 21:57:02", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7561", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-16 22:01:57", "2025-06-16 22:01:57", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750111317;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750111317;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-16 22:15:01", "2025-06-16 22:15:01", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7562", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-16 22:02:02", "2025-06-16 22:02:02", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750111322;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750111322;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-16 22:15:07", "2025-06-16 22:15:07", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7563", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-16 22:20:01", "2025-06-16 22:20:01", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750112401;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750112401;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-16 22:20:25", "2025-06-16 22:20:25", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7564", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-16 22:20:07", "2025-06-16 22:20:07", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750112407;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750112407;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-16 22:20:31", "2025-06-16 22:20:31", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7565", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-16 22:25:25", "2025-06-16 22:25:25", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750112725;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750112725;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-16 22:28:37", "2025-06-16 22:28:37", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7566", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-16 22:25:31", "2025-06-16 22:25:31", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750112731;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750112731;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-16 22:28:42", "2025-06-16 22:28:42", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7567", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-16 22:33:37", "2025-06-16 22:33:37", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750113217;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750113217;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-16 22:36:31", "2025-06-16 22:36:31", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7568", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-16 22:33:42", "2025-06-16 22:33:42", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750113222;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750113222;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-16 22:36:36", "2025-06-16 22:36:36", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7569", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-16 22:41:31", "2025-06-16 22:41:31", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750113691;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750113691;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-16 22:43:51", "2025-06-16 22:43:51", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7570", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-16 22:41:36", "2025-06-16 22:41:36", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750113696;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750113696;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-16 22:43:56", "2025-06-16 22:43:56", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7571", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-16 22:48:51", "2025-06-16 22:48:51", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750114131;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750114131;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-16 22:52:11", "2025-06-16 22:52:11", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7572", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-16 22:48:56", "2025-06-16 22:48:56", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750114136;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750114136;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-16 22:52:16", "2025-06-16 22:52:16", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7573", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-16 22:57:11", "2025-06-16 22:57:11", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750114631;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750114631;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-16 22:59:57", "2025-06-16 22:59:57", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7574", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-16 22:57:16", "2025-06-16 22:57:16", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750114636;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750114636;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-16 23:00:02", "2025-06-16 23:00:02", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7575", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-16 23:04:57", "2025-06-16 23:04:57", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750115097;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750115097;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-16 23:31:11", "2025-06-16 23:31:11", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7576", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-16 23:05:02", "2025-06-16 23:05:02", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750115102;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750115102;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-16 23:31:15", "2025-06-16 23:31:15", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7577", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-16 23:36:11", "2025-06-16 23:36:11", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750116971;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750116971;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-16 23:38:58", "2025-06-16 23:38:58", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7578", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-16 23:36:15", "2025-06-16 23:36:15", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750116975;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750116975;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-16 23:39:03", "2025-06-16 23:39:03", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7579", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-16 23:43:58", "2025-06-16 23:43:58", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750117438;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750117438;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-16 23:46:46", "2025-06-16 23:46:46", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7580", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-16 23:44:03", "2025-06-16 23:44:03", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750117443;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750117443;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-16 23:46:52", "2025-06-16 23:46:52", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7581", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-16 23:51:46", "2025-06-16 23:51:46", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750117906;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750117906;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-16 23:54:33", "2025-06-16 23:54:33", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7582", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-16 23:51:52", "2025-06-16 23:51:52", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750117912;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750117912;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-16 23:54:38", "2025-06-16 23:54:38", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7583", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-16 23:59:33", "2025-06-16 23:59:33", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750118373;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750118373;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-17 00:26:27", "2025-06-17 00:26:27", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7584", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-16 23:59:38", "2025-06-16 23:59:38", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750118378;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750118378;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-17 00:26:32", "2025-06-17 00:26:32", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7585", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-17 00:31:27", "2025-06-17 00:31:27", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750120287;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750120287;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-17 00:34:22", "2025-06-17 00:34:22", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7586", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-17 00:31:32", "2025-06-17 00:31:32", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750120292;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750120292;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-17 00:34:28", "2025-06-17 00:34:28", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7587", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-17 00:39:22", "2025-06-17 00:39:22", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750120762;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750120762;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-17 00:42:17", "2025-06-17 00:42:17", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7588", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-17 00:39:28", "2025-06-17 00:39:28", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750120768;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750120768;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-17 00:42:21", "2025-06-17 00:42:21", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7589", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-17 00:47:17", "2025-06-17 00:47:17", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750121237;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750121237;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-17 00:50:13", "2025-06-17 00:50:13", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7590", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-17 00:47:21", "2025-06-17 00:47:21", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750121241;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750121241;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-17 00:50:18", "2025-06-17 00:50:18", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7591", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-17 00:55:13", "2025-06-17 00:55:13", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750121713;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750121713;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-17 00:57:59", "2025-06-17 00:57:59", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7592", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-17 00:55:18", "2025-06-17 00:55:18", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750121718;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750121718;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-17 00:58:05", "2025-06-17 00:58:05", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7593", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-17 01:02:59", "2025-06-17 01:02:59", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750122179;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750122179;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-17 01:13:56", "2025-06-17 01:13:56", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7594", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-17 01:03:05", "2025-06-17 01:03:05", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750122185;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750122185;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-17 01:14:02", "2025-06-17 01:14:02", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7595", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-17 01:18:56", "2025-06-17 01:18:56", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750123136;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750123136;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-17 01:21:55", "2025-06-17 01:21:55", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7596", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-17 01:19:02", "2025-06-17 01:19:02", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750123142;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750123142;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-17 01:22:00", "2025-06-17 01:22:00", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7597", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-17 01:26:55", "2025-06-17 01:26:55", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750123615;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750123615;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-17 01:29:54", "2025-06-17 01:29:54", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7598", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-17 01:27:00", "2025-06-17 01:27:00", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750123620;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750123620;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-17 01:29:59", "2025-06-17 01:29:59", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7599", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-17 01:34:54", "2025-06-17 01:34:54", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750124094;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750124094;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-17 01:37:58", "2025-06-17 01:37:58", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7600", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-17 01:34:59", "2025-06-17 01:34:59", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750124099;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750124099;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-17 01:38:03", "2025-06-17 01:38:03", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7601", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-17 01:42:58", "2025-06-17 01:42:58", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750124578;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750124578;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-17 01:46:03", "2025-06-17 01:46:03", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7602", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-17 01:43:03", "2025-06-17 01:43:03", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750124583;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750124583;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-17 01:46:08", "2025-06-17 01:46:08", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7603", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-17 01:51:03", "2025-06-17 01:51:03", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750125063;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750125063;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-17 01:54:00", "2025-06-17 01:54:00", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7604", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-17 01:51:08", "2025-06-17 01:51:08", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750125068;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750125068;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-17 01:54:05", "2025-06-17 01:54:05", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7605", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-17 01:59:00", "2025-06-17 01:59:00", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750125540;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750125540;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-17 02:10:29", "2025-06-17 02:10:29", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7606", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-17 01:59:05", "2025-06-17 01:59:05", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750125545;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750125545;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-17 02:11:09", "2025-06-17 02:11:09", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7607", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-17 02:15:29", "2025-06-17 02:15:29", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750126529;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750126529;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-17 02:19:10", "2025-06-17 02:19:10", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7608", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-17 02:16:09", "2025-06-17 02:16:09", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750126569;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750126569;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-17 02:19:15", "2025-06-17 02:19:15", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7609", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-17 02:24:10", "2025-06-17 02:24:10", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750127050;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750127050;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-17 02:27:46", "2025-06-17 02:27:46", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7610", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-17 02:24:15", "2025-06-17 02:24:15", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750127055;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750127055;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-17 02:27:52", "2025-06-17 02:27:52", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7611", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-17 02:32:46", "2025-06-17 02:32:46", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750127566;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750127566;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-17 02:34:06", "2025-06-17 02:34:06", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7612", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-17 02:32:52", "2025-06-17 02:32:52", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750127572;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750127572;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-17 02:34:11", "2025-06-17 02:34:11", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7613", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-17 02:39:06", "2025-06-17 02:39:06", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750127946;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750127946;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-17 02:44:50", "2025-06-17 02:44:50", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7614", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-17 02:39:11", "2025-06-17 02:39:11", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750127951;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750127951;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-17 02:44:54", "2025-06-17 02:44:54", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7615", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-17 02:49:50", "2025-06-17 02:49:50", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750128590;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750128590;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-17 02:53:21", "2025-06-17 02:53:21", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7616", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-17 02:49:54", "2025-06-17 02:49:54", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750128594;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750128594;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-17 02:53:26", "2025-06-17 02:53:26", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7617", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-17 02:58:21", "2025-06-17 02:58:21", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750129101;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750129101;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-17 03:00:23", "2025-06-17 03:00:23", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7618", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-17 02:58:26", "2025-06-17 02:58:26", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750129106;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750129106;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-17 03:00:27", "2025-06-17 03:00:27", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7619", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-17 03:05:23", "2025-06-17 03:05:23", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750129523;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750129523;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-17 03:27:45", "2025-06-17 03:27:45", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7620", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-17 03:05:27", "2025-06-17 03:05:27", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750129527;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750129527;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-17 03:27:50", "2025-06-17 03:27:50", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7621", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-17 03:32:45", "2025-06-17 03:32:45", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750131165;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750131165;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-17 03:36:21", "2025-06-17 03:36:21", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7622", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-17 03:32:50", "2025-06-17 03:32:50", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750131170;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750131170;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-17 03:36:26", "2025-06-17 03:36:26", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7623", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-17 03:41:21", "2025-06-17 03:41:21", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750131681;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750131681;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-17 03:44:52", "2025-06-17 03:44:52", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7624", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-17 03:41:26", "2025-06-17 03:41:26", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750131686;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750131686;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-17 03:44:57", "2025-06-17 03:44:57", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7625", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-17 03:49:52", "2025-06-17 03:49:52", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750132192;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750132192;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-17 03:51:22", "2025-06-17 03:51:22", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7626", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-17 03:49:57", "2025-06-17 03:49:57", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750132197;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750132197;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-17 03:51:27", "2025-06-17 03:51:27", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7627", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-17 03:56:22", "2025-06-17 03:56:22", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750132582;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750132582;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-17 03:57:32", "2025-06-17 03:57:32", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7628", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-17 03:56:27", "2025-06-17 03:56:27", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750132587;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750132587;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-17 03:57:37", "2025-06-17 03:57:37", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7629", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-17 04:02:32", "2025-06-17 04:02:32", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750132952;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750132952;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-17 04:07:38", "2025-06-17 04:07:38", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7630", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-17 04:02:37", "2025-06-17 04:02:37", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750132957;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750132957;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-17 04:07:43", "2025-06-17 04:07:43", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7631", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-17 04:12:38", "2025-06-17 04:12:38", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750133558;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750133558;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-17 04:12:54", "2025-06-17 04:12:54", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7632", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-17 04:12:43", "2025-06-17 04:12:43", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750133563;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750133563;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-17 04:13:00", "2025-06-17 04:13:00", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7633", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-17 04:17:54", "2025-06-17 04:17:54", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750133874;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750133874;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-17 04:18:18", "2025-06-17 04:18:18", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7634", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-17 04:18:00", "2025-06-17 04:18:00", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750133880;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750133880;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-17 04:18:23", "2025-06-17 04:18:23", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7635", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-17 04:23:18", "2025-06-17 04:23:18", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750134198;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750134198;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-17 04:23:26", "2025-06-17 04:23:26", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7636", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-17 04:23:23", "2025-06-17 04:23:23", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750134203;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750134203;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-17 04:23:31", "2025-06-17 04:23:31", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7637", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-17 04:28:26", "2025-06-17 04:28:26", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750134506;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750134506;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-17 04:28:43", "2025-06-17 04:28:43", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7638", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-17 04:28:31", "2025-06-17 04:28:31", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750134511;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750134511;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-17 04:28:48", "2025-06-17 04:28:48", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7639", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-17 04:33:43", "2025-06-17 04:33:43", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750134823;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750134823;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-17 04:37:35", "2025-06-17 04:37:35", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7640", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-17 04:33:48", "2025-06-17 04:33:48", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750134828;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750134828;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-17 04:37:40", "2025-06-17 04:37:40", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7641", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-17 04:42:35", "2025-06-17 04:42:35", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750135355;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750135355;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-17 04:44:41", "2025-06-17 04:44:41", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7642", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-17 04:42:40", "2025-06-17 04:42:40", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750135360;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750135360;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-17 04:44:47", "2025-06-17 04:44:47", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7643", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-17 04:49:41", "2025-06-17 04:49:41", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750135781;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750135781;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-17 04:55:18", "2025-06-17 04:55:18", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7644", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-17 04:49:47", "2025-06-17 04:49:47", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750135787;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750135787;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-17 04:55:23", "2025-06-17 04:55:23", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7645", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-17 05:00:18", "2025-06-17 05:00:18", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750136418;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750136418;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-17 05:29:46", "2025-06-17 05:29:46", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7646", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-17 05:00:23", "2025-06-17 05:00:23", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750136423;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750136423;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-17 05:29:51", "2025-06-17 05:29:51", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7647", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-17 05:34:46", "2025-06-17 05:34:46", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750138486;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750138486;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-17 05:38:16", "2025-06-17 05:38:16", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7648", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-17 05:34:51", "2025-06-17 05:34:51", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750138491;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750138491;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-17 05:38:21", "2025-06-17 05:38:21", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7649", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-17 05:43:16", "2025-06-17 05:43:16", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750138996;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750138996;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-17 05:46:39", "2025-06-17 05:46:39", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7650", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-17 05:43:21", "2025-06-17 05:43:21", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750139001;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750139001;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-17 05:46:44", "2025-06-17 05:46:44", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7651", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-17 05:51:39", "2025-06-17 05:51:39", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750139499;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750139499;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-17 05:55:02", "2025-06-17 05:55:02", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7652", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-17 05:51:44", "2025-06-17 05:51:44", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750139504;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750139504;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-17 05:55:07", "2025-06-17 05:55:07", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7653", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-17 06:00:02", "2025-06-17 06:00:02", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750140002;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750140002;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-17 06:15:48", "2025-06-17 06:15:48", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7654", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-17 06:00:07", "2025-06-17 06:00:07", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750140007;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750140007;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-17 06:15:53", "2025-06-17 06:15:53", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7655", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-17 06:20:48", "2025-06-17 06:20:48", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750141248;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750141248;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-17 06:28:58", "2025-06-17 06:28:58", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7656", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-17 06:20:53", "2025-06-17 06:20:53", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750141253;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750141253;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-17 06:29:04", "2025-06-17 06:29:04", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7657", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-17 06:33:58", "2025-06-17 06:33:58", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750142038;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750142038;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-17 06:37:39", "2025-06-17 06:37:39", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7658", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-17 06:34:04", "2025-06-17 06:34:04", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750142044;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750142044;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-17 06:37:44", "2025-06-17 06:37:44", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7659", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-17 06:42:39", "2025-06-17 06:42:39", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750142559;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750142559;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-17 06:45:53", "2025-06-17 06:45:53", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7660", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-17 06:42:44", "2025-06-17 06:42:44", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750142564;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750142564;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-17 06:45:58", "2025-06-17 06:45:58", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7661", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-17 06:50:53", "2025-06-17 06:50:53", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750143053;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750143053;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-17 06:54:44", "2025-06-17 06:54:44", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7662", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-17 06:50:58", "2025-06-17 06:50:58", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750143058;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750143058;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-17 06:54:49", "2025-06-17 06:54:49", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7663", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-17 06:59:44", "2025-06-17 06:59:44", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750143584;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750143584;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-17 07:11:38", "2025-06-17 07:11:38", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7664", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-17 06:59:49", "2025-06-17 06:59:49", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750143589;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750143589;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-17 07:11:43", "2025-06-17 07:11:43", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7665", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-17 07:16:38", "2025-06-17 07:16:38", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750144598;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750144598;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-17 07:20:38", "2025-06-17 07:20:38", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7666", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-17 07:16:43", "2025-06-17 07:16:43", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750144603;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750144603;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-17 07:20:44", "2025-06-17 07:20:44", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7667", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-17 07:25:38", "2025-06-17 07:25:38", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750145138;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750145138;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-17 07:28:27", "2025-06-17 07:28:27", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7668", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-17 07:25:44", "2025-06-17 07:25:44", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750145144;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750145144;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-17 07:28:33", "2025-06-17 07:28:33", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7669", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-17 07:33:27", "2025-06-17 07:33:27", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750145607;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750145607;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-17 07:36:50", "2025-06-17 07:36:50", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7670", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-17 07:33:33", "2025-06-17 07:33:33", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750145613;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750145613;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-17 07:36:56", "2025-06-17 07:36:56", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7671", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-17 07:41:50", "2025-06-17 07:41:50", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750146110;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750146110;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-17 07:45:08", "2025-06-17 07:45:08", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7672", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-17 07:41:56", "2025-06-17 07:41:56", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750146116;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750146116;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-17 07:45:13", "2025-06-17 07:45:13", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7673", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-17 07:50:08", "2025-06-17 07:50:08", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750146608;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750146608;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-17 07:50:25", "2025-06-17 07:50:25", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7674", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-17 07:50:13", "2025-06-17 07:50:13", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750146613;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750146613;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-17 07:50:30", "2025-06-17 07:50:30", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7675", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-17 07:55:25", "2025-06-17 07:55:25", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750146925;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750146925;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-17 08:13:27", "2025-06-17 08:13:27", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7676", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-17 07:55:30", "2025-06-17 07:55:30", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750146930;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750146930;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-17 08:13:32", "2025-06-17 08:13:32", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7677", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-17 08:18:27", "2025-06-17 08:18:27", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750148307;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750148307;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-17 08:26:28", "2025-06-17 08:26:28", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7678", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-17 08:18:32", "2025-06-17 08:18:32", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750148312;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750148312;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-17 08:26:34", "2025-06-17 08:26:34", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7679", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-17 08:31:28", "2025-06-17 08:31:28", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750149088;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750149088;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-17 08:32:39", "2025-06-17 08:32:39", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7680", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-17 08:31:34", "2025-06-17 08:31:34", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750149094;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750149094;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-17 08:32:44", "2025-06-17 08:32:44", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7681", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-17 08:37:39", "2025-06-17 08:37:39", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750149459;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750149459;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-17 08:42:58", "2025-06-17 08:42:58", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7682", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-17 08:37:44", "2025-06-17 08:37:44", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750149464;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750149464;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-17 08:43:04", "2025-06-17 08:43:04", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7683", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-17 08:47:58", "2025-06-17 08:47:58", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750150078;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750150078;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-17 08:50:24", "2025-06-17 08:50:24", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7684", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-17 08:48:04", "2025-06-17 08:48:04", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750150084;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750150084;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-17 08:50:30", "2025-06-17 08:50:30", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7685", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-17 08:55:24", "2025-06-17 08:55:24", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750150524;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750150524;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-17 08:59:07", "2025-06-17 08:59:07", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7686", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-17 08:55:30", "2025-06-17 08:55:30", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750150530;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750150530;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-17 08:59:12", "2025-06-17 08:59:12", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7687", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-17 09:04:07", "2025-06-17 09:04:07", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750151047;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750151047;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-17 09:10:21", "2025-06-17 09:10:21", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7688", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-17 09:04:12", "2025-06-17 09:04:12", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750151052;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750151052;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-17 09:10:27", "2025-06-17 09:10:27", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7689", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-17 09:15:21", "2025-06-17 09:15:21", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750151721;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750151721;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-17 09:20:52", "2025-06-17 09:20:52", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7690", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-17 09:15:27", "2025-06-17 09:15:27", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750151727;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750151727;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-17 09:20:57", "2025-06-17 09:20:57", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7691", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-17 09:25:52", "2025-06-17 09:25:52", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750152352;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750152352;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-17 09:31:01", "2025-06-17 09:31:01", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7692", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-17 09:25:57", "2025-06-17 09:25:57", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750152357;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750152357;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-17 09:31:07", "2025-06-17 09:31:07", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7693", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-17 09:36:01", "2025-06-17 09:36:01", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750152961;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750152961;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-17 09:38:51", "2025-06-17 09:38:51", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7694", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-17 09:36:07", "2025-06-17 09:36:07", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750152967;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750152967;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-17 09:38:56", "2025-06-17 09:38:56", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7695", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-17 09:43:51", "2025-06-17 09:43:51", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750153431;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750153431;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-17 09:46:33", "2025-06-17 09:46:33", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7696", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-17 09:43:56", "2025-06-17 09:43:56", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750153436;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750153436;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-17 09:46:38", "2025-06-17 09:46:38", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7697", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-17 09:51:33", "2025-06-17 09:51:33", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750153893;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750153893;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-17 09:54:17", "2025-06-17 09:54:17", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7698", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-17 09:51:38", "2025-06-17 09:51:38", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750153898;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750153898;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-17 09:54:22", "2025-06-17 09:54:22", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7699", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-17 09:59:17", "2025-06-17 09:59:17", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750154357;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750154357;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-17 09:59:56", "2025-06-17 09:59:56", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7700", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-17 09:59:22", "2025-06-17 09:59:22", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750154362;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750154362;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-17 10:00:02", "2025-06-17 10:00:02", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7701", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-17 10:04:56", "2025-06-17 10:04:56", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750154696;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750154696;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-17 10:09:37", "2025-06-17 10:09:37", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7702", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-17 10:05:02", "2025-06-17 10:05:02", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750154702;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750154702;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-17 10:09:43", "2025-06-17 10:09:43", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7703", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-17 10:14:37", "2025-06-17 10:14:37", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750155277;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750155277;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-17 10:15:16", "2025-06-17 10:15:16", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7704", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-17 10:14:43", "2025-06-17 10:14:43", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750155283;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750155283;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-17 10:15:21", "2025-06-17 10:15:21", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7705", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-17 10:20:16", "2025-06-17 10:20:16", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750155616;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750155616;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-17 10:20:50", "2025-06-17 10:20:50", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7706", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-17 10:20:21", "2025-06-17 10:20:21", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750155621;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750155621;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-17 10:20:55", "2025-06-17 10:20:55", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7707", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-17 10:25:50", "2025-06-17 10:25:50", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750155950;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750155950;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-17 10:26:36", "2025-06-17 10:26:36", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7708", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-17 10:25:55", "2025-06-17 10:25:55", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750155955;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750155955;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-17 10:26:41", "2025-06-17 10:26:41", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7709", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-17 10:31:36", "2025-06-17 10:31:36", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750156296;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750156296;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-17 10:31:47", "2025-06-17 10:31:47", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7710", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-17 10:31:41", "2025-06-17 10:31:41", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750156301;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750156301;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-17 10:31:52", "2025-06-17 10:31:52", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7711", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-17 10:36:47", "2025-06-17 10:36:47", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750156607;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750156607;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-17 10:37:12", "2025-06-17 10:37:12", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7712", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-17 10:36:52", "2025-06-17 10:36:52", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750156612;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750156612;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-17 10:37:18", "2025-06-17 10:37:18", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7713", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-17 10:42:12", "2025-06-17 10:42:12", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750156932;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750156932;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-17 10:42:21", "2025-06-17 10:42:21", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7714", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-17 10:42:18", "2025-06-17 10:42:18", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750156938;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750156938;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-17 10:42:27", "2025-06-17 10:42:27", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7715", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-17 10:47:21", "2025-06-17 10:47:21", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750157241;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750157241;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-17 10:47:56", "2025-06-17 10:47:56", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7716", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-17 10:47:27", "2025-06-17 10:47:27", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750157247;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750157247;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-17 10:48:01", "2025-06-17 10:48:01", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7717", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-17 10:52:56", "2025-06-17 10:52:56", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750157576;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750157576;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-17 10:53:16", "2025-06-17 10:53:16", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7718", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-17 10:53:01", "2025-06-17 10:53:01", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750157581;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750157581;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-17 10:53:21", "2025-06-17 10:53:21", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7719", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-17 10:58:16", "2025-06-17 10:58:16", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750157896;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750157896;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-17 11:11:36", "2025-06-17 11:11:36", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7720", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-17 10:58:21", "2025-06-17 10:58:21", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750157901;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750157901;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-17 11:11:41", "2025-06-17 11:11:41", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7721", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-17 11:16:36", "2025-06-17 11:16:36", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750158996;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750158996;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-17 11:20:14", "2025-06-17 11:20:14", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7722", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-17 11:16:41", "2025-06-17 11:16:41", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750159001;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750159001;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-17 11:20:19", "2025-06-17 11:20:19", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7723", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-17 11:25:14", "2025-06-17 11:25:14", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750159514;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750159514;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-17 11:28:14", "2025-06-17 11:28:14", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7724", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-17 11:25:19", "2025-06-17 11:25:19", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750159519;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750159519;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-17 11:28:19", "2025-06-17 11:28:19", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7725", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-17 11:33:14", "2025-06-17 11:33:14", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750159994;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750159994;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-17 11:36:24", "2025-06-17 11:36:24", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7726", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-17 11:33:19", "2025-06-17 11:33:19", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750159999;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750159999;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-17 11:36:30", "2025-06-17 11:36:30", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7727", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-17 11:41:24", "2025-06-17 11:41:24", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750160484;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750160484;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-17 11:41:33", "2025-06-17 11:41:33", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7728", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-17 11:41:30", "2025-06-17 11:41:30", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750160490;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750160490;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-17 11:41:38", "2025-06-17 11:41:38", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7729", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-17 11:46:33", "2025-06-17 11:46:33", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750160793;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750160793;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-17 11:52:18", "2025-06-17 11:52:18", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7730", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-17 11:46:38", "2025-06-17 11:46:38", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750160798;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750160798;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-17 11:52:23", "2025-06-17 11:52:23", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7731", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-17 11:57:18", "2025-06-17 11:57:18", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750161438;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750161438;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-17 12:00:29", "2025-06-17 12:00:29", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7732", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-17 11:57:23", "2025-06-17 11:57:23", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750161443;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750161443;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-17 12:00:35", "2025-06-17 12:00:35", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7733", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-17 12:05:29", "2025-06-17 12:05:29", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750161929;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750161929;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-17 12:12:32", "2025-06-17 12:12:32", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7734", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-17 12:05:35", "2025-06-17 12:05:35", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750161935;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750161935;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-17 12:12:38", "2025-06-17 12:12:38", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7735", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-17 12:17:32", "2025-06-17 12:17:32", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750162652;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750162652;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-17 12:25:12", "2025-06-17 12:25:12", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7736", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-17 12:17:38", "2025-06-17 12:17:38", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750162658;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750162658;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-17 12:25:18", "2025-06-17 12:25:18", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7737", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-17 12:30:12", "2025-06-17 12:30:12", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750163412;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750163412;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-17 12:38:17", "2025-06-17 12:38:17", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7738", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-17 12:30:18", "2025-06-17 12:30:18", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750163418;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750163418;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-17 12:38:22", "2025-06-17 12:38:22", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7739", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-17 12:43:17", "2025-06-17 12:43:17", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750164197;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750164197;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-17 12:45:11", "2025-06-17 12:45:11", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7740", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-17 12:43:22", "2025-06-17 12:43:22", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750164202;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750164202;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-17 12:45:17", "2025-06-17 12:45:17", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7741", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-17 12:50:11", "2025-06-17 12:50:11", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750164611;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750164611;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-17 12:51:04", "2025-06-17 12:51:04", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7742", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-17 12:50:17", "2025-06-17 12:50:17", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750164617;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750164617;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-17 12:51:09", "2025-06-17 12:51:09", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7743", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-17 12:56:04", "2025-06-17 12:56:04", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750164964;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750164964;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-17 13:08:56", "2025-06-17 13:08:56", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7744", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-17 12:56:09", "2025-06-17 12:56:09", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750164969;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750164969;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-17 13:09:01", "2025-06-17 13:09:01", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7745", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-17 13:13:56", "2025-06-17 13:13:56", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750166036;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750166036;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-17 13:17:23", "2025-06-17 13:17:23", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7746", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-17 13:14:01", "2025-06-17 13:14:01", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750166041;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750166041;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-17 13:17:28", "2025-06-17 13:17:28", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7747", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-17 13:22:23", "2025-06-17 13:22:23", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750166543;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750166543;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-17 13:28:30", "2025-06-17 13:28:30", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7748", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-17 13:22:28", "2025-06-17 13:22:28", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750166548;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750166548;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-17 13:28:35", "2025-06-17 13:28:35", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7749", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-17 13:33:30", "2025-06-17 13:33:30", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750167210;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750167210;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-17 13:35:22", "2025-06-17 13:35:22", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7750", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-17 13:33:35", "2025-06-17 13:33:35", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750167215;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750167215;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-17 13:35:27", "2025-06-17 13:35:27", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7751", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-17 13:40:22", "2025-06-17 13:40:22", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750167622;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750167622;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-17 13:48:01", "2025-06-17 13:48:01", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7752", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-17 13:40:27", "2025-06-17 13:40:27", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750167627;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750167627;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-17 13:48:06", "2025-06-17 13:48:06", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7753", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-17 13:53:01", "2025-06-17 13:53:01", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750168381;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750168381;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-17 13:56:17", "2025-06-17 13:56:17", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7754", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-17 13:53:06", "2025-06-17 13:53:06", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750168386;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750168386;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-17 13:56:22", "2025-06-17 13:56:22", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7755", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-17 14:01:17", "2025-06-17 14:01:17", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750168877;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750168877;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-17 14:03:46", "2025-06-17 14:03:46", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7756", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-17 14:01:22", "2025-06-17 14:01:22", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750168882;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750168882;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-17 14:03:51", "2025-06-17 14:03:51", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7757", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-17 14:08:46", "2025-06-17 14:08:46", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750169326;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750169326;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-17 14:12:57", "2025-06-17 14:12:57", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7758", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-17 14:08:51", "2025-06-17 14:08:51", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750169331;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750169331;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-17 14:13:02", "2025-06-17 14:13:02", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7759", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-17 14:17:57", "2025-06-17 14:17:57", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750169877;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750169877;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-17 14:21:04", "2025-06-17 14:21:04", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7760", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-17 14:18:02", "2025-06-17 14:18:02", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750169882;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750169882;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-17 14:21:10", "2025-06-17 14:21:10", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7761", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-17 14:26:04", "2025-06-17 14:26:04", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750170364;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750170364;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-17 14:29:46", "2025-06-17 14:29:46", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7762", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-17 14:26:10", "2025-06-17 14:26:10", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750170370;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750170370;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-17 14:29:52", "2025-06-17 14:29:52", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7763", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-17 14:34:46", "2025-06-17 14:34:46", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750170886;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750170886;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-17 14:38:14", "2025-06-17 14:38:14", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7764", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-17 14:34:52", "2025-06-17 14:34:52", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750170892;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750170892;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-17 14:38:19", "2025-06-17 14:38:19", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7765", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-17 14:43:14", "2025-06-17 14:43:14", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750171394;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750171394;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-17 14:46:58", "2025-06-17 14:46:58", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7766", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-17 14:43:19", "2025-06-17 14:43:19", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750171399;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750171399;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-17 14:47:04", "2025-06-17 14:47:04", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7767", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-17 14:51:58", "2025-06-17 14:51:58", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750171918;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750171918;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-17 14:55:55", "2025-06-17 14:55:55", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7768", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-17 14:52:04", "2025-06-17 14:52:04", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750171924;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750171924;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-17 14:56:01", "2025-06-17 14:56:01", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7769", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-17 15:00:55", "2025-06-17 15:00:55", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750172455;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750172455;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-17 15:49:42", "2025-06-17 15:49:42", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7770", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-17 15:01:01", "2025-06-17 15:01:01", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750172461;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750172461;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-17 15:49:47", "2025-06-17 15:49:47", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7771", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-17 15:54:42", "2025-06-17 15:54:42", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750175682;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750175682;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-17 15:56:21", "2025-06-17 15:56:21", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7772", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-17 15:54:47", "2025-06-17 15:54:47", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750175687;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750175687;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-17 15:56:26", "2025-06-17 15:56:26", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7773", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-17 16:01:21", "2025-06-17 16:01:21", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750176081;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750176081;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-17 16:12:40", "2025-06-17 16:12:40", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7774", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-17 16:01:26", "2025-06-17 16:01:26", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750176086;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750176086;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-17 16:12:45", "2025-06-17 16:12:45", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7775", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-17 16:17:40", "2025-06-17 16:17:40", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750177060;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750177060;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-17 16:20:58", "2025-06-17 16:20:58", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7776", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-17 16:17:45", "2025-06-17 16:17:45", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750177065;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750177065;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-17 16:21:03", "2025-06-17 16:21:03", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7777", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-17 16:25:58", "2025-06-17 16:25:58", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750177558;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750177558;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-17 16:29:39", "2025-06-17 16:29:39", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7778", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-17 16:26:03", "2025-06-17 16:26:03", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750177563;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750177563;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-17 16:29:44", "2025-06-17 16:29:44", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7779", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-17 16:34:39", "2025-06-17 16:34:39", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750178079;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750178079;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-17 16:37:58", "2025-06-17 16:37:58", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7780", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-17 16:34:44", "2025-06-17 16:34:44", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750178084;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750178084;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-17 16:38:04", "2025-06-17 16:38:04", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7781", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-17 16:42:58", "2025-06-17 16:42:58", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750178578;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750178578;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-17 16:43:05", "2025-06-17 16:43:05", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7782", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-17 16:43:04", "2025-06-17 16:43:04", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750178584;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750178584;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-17 16:43:10", "2025-06-17 16:43:10", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7783", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-17 16:48:05", "2025-06-17 16:48:05", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750178885;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750178885;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-17 16:48:39", "2025-06-17 16:48:39", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7784", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-17 16:48:10", "2025-06-17 16:48:10", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750178890;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750178890;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-17 16:48:44", "2025-06-17 16:48:44", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7785", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-17 16:53:39", "2025-06-17 16:53:39", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750179219;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750179219;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-17 16:53:48", "2025-06-17 16:53:48", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7786", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-17 16:53:44", "2025-06-17 16:53:44", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750179224;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750179224;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-17 16:53:53", "2025-06-17 16:53:53", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7787", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-17 16:58:48", "2025-06-17 16:58:48", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750179528;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750179528;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-17 17:09:16", "2025-06-17 17:09:16", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7788", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-17 16:58:53", "2025-06-17 16:58:53", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750179533;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750179533;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-17 17:09:21", "2025-06-17 17:09:21", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7789", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-17 17:14:16", "2025-06-17 17:14:16", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750180456;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750180456;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-17 17:15:08", "2025-06-17 17:15:08", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7790", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-17 17:14:21", "2025-06-17 17:14:21", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750180461;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750180461;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-17 17:15:13", "2025-06-17 17:15:13", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7791", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-17 17:20:08", "2025-06-17 17:20:08", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750180808;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750180808;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-17 17:21:36", "2025-06-17 17:21:36", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7792", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-17 17:20:13", "2025-06-17 17:20:13", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750180813;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750180813;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-17 17:21:42", "2025-06-17 17:21:42", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7793", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-17 17:26:36", "2025-06-17 17:26:36", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750181196;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750181196;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-17 17:28:03", "2025-06-17 17:28:03", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7794", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-17 17:26:42", "2025-06-17 17:26:42", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750181202;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750181202;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-17 17:28:08", "2025-06-17 17:28:08", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7795", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-17 17:33:03", "2025-06-17 17:33:03", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750181583;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750181583;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-17 18:30:34", "2025-06-17 18:30:34", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7796", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-17 17:33:08", "2025-06-17 17:33:08", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750181588;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750181588;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-17 18:31:13", "2025-06-17 18:31:13", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7797", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-17 18:35:34", "2025-06-17 18:35:34", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750185334;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750185334;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-17 18:36:13", "2025-06-17 18:36:13", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7798", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-17 18:36:13", "2025-06-17 18:36:13", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750185373;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750185373;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-17 18:36:18", "2025-06-17 18:36:18", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7799", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-17 18:41:13", "2025-06-17 18:41:13", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750185673;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750185673;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-17 18:49:55", "2025-06-17 18:49:55", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7800", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-17 18:41:18", "2025-06-17 18:41:18", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750185678;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750185678;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-17 18:50:00", "2025-06-17 18:50:00", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7801", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-17 18:54:55", "2025-06-17 18:54:55", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750186495;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750186495;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-17 20:13:05", "2025-06-17 20:13:05", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7802", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-17 18:55:00", "2025-06-17 18:55:00", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750186500;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750186500;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-17 20:14:10", "2025-06-17 20:14:10", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7803", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-17 20:18:05", "2025-06-17 20:18:05", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750191485;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750191485;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-17 20:27:27", "2025-06-17 20:27:27", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7804", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-17 20:19:10", "2025-06-17 20:19:10", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750191550;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750191550;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-17 20:27:32", "2025-06-17 20:27:32", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7805", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-17 20:32:27", "2025-06-17 20:32:27", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750192347;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750192347;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-17 20:42:19", "2025-06-17 20:42:19", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7806", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-17 20:32:32", "2025-06-17 20:32:32", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750192352;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750192352;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-17 20:42:24", "2025-06-17 20:42:24", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7807", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-17 20:47:19", "2025-06-17 20:47:19", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750193239;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750193239;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-17 20:55:29", "2025-06-17 20:55:29", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7808", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-17 20:47:24", "2025-06-17 20:47:24", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750193244;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750193244;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-17 20:55:35", "2025-06-17 20:55:35", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7809", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-17 21:00:29", "2025-06-17 21:00:29", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750194029;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750194029;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-17 21:18:42", "2025-06-17 21:18:42", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7810", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-17 21:00:35", "2025-06-17 21:00:35", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750194035;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750194035;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-17 21:18:47", "2025-06-17 21:18:47", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7811", "woocommerce_cleanup_draft_orders", "complete", "2025-06-18 20:55:35", "2025-06-18 20:55:35", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750280135;s:18:\"\0*\0first_timestamp\";i:1744536626;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750280135;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-06-18 21:00:40", "2025-06-18 21:00:40", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7812", "wpforms_process_forms_locator_scan", "complete", "2025-06-18 20:55:35", "2025-06-18 20:55:35", "10", "{\"tasks_meta_id\":1}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750280135;s:18:\"\0*\0first_timestamp\";i:1744536754;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750280135;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2025-06-18 21:00:40", "2025-06-18 21:00:40", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7813", "wpforms_process_purge_spam", "complete", "2025-06-18 20:55:35", "2025-06-18 20:55:35", "10", "{\"tasks_meta_id\":2}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750280135;s:18:\"\0*\0first_timestamp\";i:1744536754;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750280135;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2025-06-18 21:00:40", "2025-06-18 21:00:40", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7814", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-17 21:23:42", "2025-06-17 21:23:42", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750195422;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750195422;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-17 21:35:22", "2025-06-17 21:35:22", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7815", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-17 21:23:47", "2025-06-17 21:23:47", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750195427;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750195427;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-17 21:35:27", "2025-06-17 21:35:27", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7816", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-17 21:40:22", "2025-06-17 21:40:22", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750196422;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750196422;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-17 21:48:44", "2025-06-17 21:48:44", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7817", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-17 21:40:27", "2025-06-17 21:40:27", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750196427;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750196427;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-17 21:48:49", "2025-06-17 21:48:49", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7818", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-17 21:53:44", "2025-06-17 21:53:44", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750197224;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750197224;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-17 22:15:13", "2025-06-17 22:15:13", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7819", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-17 21:53:49", "2025-06-17 21:53:49", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750197229;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750197229;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-17 22:15:18", "2025-06-17 22:15:18", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7820", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-17 22:20:13", "2025-06-17 22:20:13", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750198813;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750198813;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-17 22:29:45", "2025-06-17 22:29:45", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7821", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-17 22:20:18", "2025-06-17 22:20:18", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750198818;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750198818;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-17 22:29:50", "2025-06-17 22:29:50", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7822", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-17 22:34:45", "2025-06-17 22:34:45", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750199685;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750199685;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-17 22:57:38", "2025-06-17 22:57:38", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7823", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-17 22:34:50", "2025-06-17 22:34:50", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750199690;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750199690;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-17 22:57:43", "2025-06-17 22:57:43", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7824", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-17 23:02:38", "2025-06-17 23:02:38", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750201358;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750201358;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-17 23:09:09", "2025-06-17 23:09:09", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7825", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-17 23:02:43", "2025-06-17 23:02:43", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750201363;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750201363;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-17 23:09:14", "2025-06-17 23:09:14", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7826", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-17 23:14:09", "2025-06-17 23:14:09", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750202049;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750202049;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-17 23:25:34", "2025-06-17 23:25:34", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7827", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-17 23:14:14", "2025-06-17 23:14:14", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750202054;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750202054;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-17 23:25:39", "2025-06-17 23:25:39", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7828", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-17 23:30:34", "2025-06-17 23:30:34", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750203034;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750203034;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-17 23:39:53", "2025-06-17 23:39:53", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7829", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-17 23:30:39", "2025-06-17 23:30:39", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750203039;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750203039;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-17 23:39:59", "2025-06-17 23:39:59", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7830", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-17 23:44:53", "2025-06-17 23:44:53", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750203893;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750203893;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-17 23:54:13", "2025-06-17 23:54:13", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7831", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-17 23:44:59", "2025-06-17 23:44:59", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750203899;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750203899;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-17 23:54:18", "2025-06-17 23:54:18", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7832", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-17 23:59:13", "2025-06-17 23:59:13", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750204753;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750204753;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-18 00:05:09", "2025-06-18 00:05:09", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7833", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-17 23:59:18", "2025-06-17 23:59:18", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750204758;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750204758;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-18 00:05:14", "2025-06-18 00:05:14", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7834", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-18 00:10:09", "2025-06-18 00:10:09", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750205409;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750205409;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-18 00:17:59", "2025-06-18 00:17:59", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7835", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-18 00:10:14", "2025-06-18 00:10:14", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750205414;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750205414;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-18 00:18:05", "2025-06-18 00:18:05", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7836", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-18 00:22:59", "2025-06-18 00:22:59", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750206179;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750206179;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-18 00:34:53", "2025-06-18 00:34:53", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7837", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-18 00:23:05", "2025-06-18 00:23:05", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750206185;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750206185;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-18 00:34:58", "2025-06-18 00:34:58", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7838", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-18 00:39:53", "2025-06-18 00:39:53", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750207193;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750207193;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-18 00:53:51", "2025-06-18 00:53:51", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7839", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-18 00:39:58", "2025-06-18 00:39:58", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750207198;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750207198;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-18 00:53:57", "2025-06-18 00:53:57", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7840", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-18 00:58:51", "2025-06-18 00:58:51", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750208331;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750208331;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-18 01:06:42", "2025-06-18 01:06:42", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7841", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-18 00:58:57", "2025-06-18 00:58:57", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750208337;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750208337;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-18 01:06:48", "2025-06-18 01:06:48", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7842", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-18 01:11:42", "2025-06-18 01:11:42", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750209102;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750209102;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-18 01:20:22", "2025-06-18 01:20:22", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7843", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-18 01:11:48", "2025-06-18 01:11:48", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750209108;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750209108;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-18 01:20:27", "2025-06-18 01:20:27", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7844", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-18 01:25:22", "2025-06-18 01:25:22", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750209922;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750209922;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-18 01:32:13", "2025-06-18 01:32:13", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7845", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-18 01:25:27", "2025-06-18 01:25:27", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750209927;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750209927;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-18 01:32:19", "2025-06-18 01:32:19", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7846", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-18 01:37:13", "2025-06-18 01:37:13", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750210633;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750210633;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-18 01:49:24", "2025-06-18 01:49:24", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7847", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-18 01:37:19", "2025-06-18 01:37:19", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750210639;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750210639;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-18 01:49:29", "2025-06-18 01:49:29", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7848", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-18 01:54:24", "2025-06-18 01:54:24", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750211664;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750211664;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-18 01:56:47", "2025-06-18 01:56:47", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7849", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-18 01:54:29", "2025-06-18 01:54:29", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750211669;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750211669;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-18 01:56:52", "2025-06-18 01:56:52", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7850", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-18 02:01:47", "2025-06-18 02:01:47", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750212107;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750212107;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-18 02:04:34", "2025-06-18 02:04:34", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7851", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-18 02:01:52", "2025-06-18 02:01:52", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750212112;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750212112;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-18 02:04:39", "2025-06-18 02:04:39", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7852", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-18 02:09:34", "2025-06-18 02:09:34", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750212574;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750212574;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-18 02:09:39", "2025-06-18 02:09:39", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7853", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-18 02:09:39", "2025-06-18 02:09:39", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750212579;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750212579;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-18 02:09:44", "2025-06-18 02:09:44", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7854", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-18 02:14:39", "2025-06-18 02:14:39", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750212879;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750212879;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-18 02:15:32", "2025-06-18 02:15:32", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7855", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-18 02:14:44", "2025-06-18 02:14:44", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750212884;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750212884;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-18 02:15:37", "2025-06-18 02:15:37", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7856", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-18 02:20:32", "2025-06-18 02:20:32", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750213232;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750213232;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-18 02:20:37", "2025-06-18 02:20:37", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7857", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-18 02:20:37", "2025-06-18 02:20:37", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750213237;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750213237;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-18 02:20:42", "2025-06-18 02:20:42", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7858", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-18 02:25:37", "2025-06-18 02:25:37", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750213537;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750213537;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-18 02:26:34", "2025-06-18 02:26:34", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7859", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-18 02:25:42", "2025-06-18 02:25:42", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750213542;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750213542;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-18 02:26:39", "2025-06-18 02:26:39", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7860", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-18 02:31:34", "2025-06-18 02:31:34", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750213894;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750213894;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-18 02:31:40", "2025-06-18 02:31:40", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7861", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-18 02:31:39", "2025-06-18 02:31:39", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750213899;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750213899;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-18 02:31:45", "2025-06-18 02:31:45", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7862", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-18 02:36:40", "2025-06-18 02:36:40", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750214200;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750214200;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-18 02:48:46", "2025-06-18 02:48:46", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7863", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-18 02:36:45", "2025-06-18 02:36:45", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750214205;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750214205;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-18 02:48:51", "2025-06-18 02:48:51", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7864", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-18 02:53:46", "2025-06-18 02:53:46", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750215226;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750215226;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-18 03:02:56", "2025-06-18 03:02:56", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7865", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-18 02:53:51", "2025-06-18 02:53:51", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750215231;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750215231;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-18 03:03:08", "2025-06-18 03:03:08", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7866", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-18 03:07:56", "2025-06-18 03:07:56", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750216076;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750216076;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-18 03:11:21", "2025-06-18 03:11:21", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7867", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-18 03:08:08", "2025-06-18 03:08:08", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750216088;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750216088;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-18 03:11:33", "2025-06-18 03:11:33", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7868", "wpforms_admin_notifications_update", "complete", "2025-06-18 03:05:46", "2025-06-18 03:05:46", "10", "{\"tasks_meta_id\":12}", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "3", "1", "2025-06-18 03:06:10", "2025-06-18 03:06:10", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7869", "fetch_patterns", "complete", "2025-06-18 03:11:10", "2025-06-18 03:11:10", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1750216270;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1750216270;}", "2", "1", "2025-06-18 03:11:34", "2025-06-18 03:11:34", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7870", "woocommerce_run_update_callback", "complete", "2025-06-18 03:11:14", "2025-06-18 03:11:14", "10", "{\"update_callback\":\"wc_update_985_enable_new_payments_settings_page_feature\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1750216274;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1750216274;}", "6", "1", "2025-06-18 03:11:34", "2025-06-18 03:11:34", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7871", "woocommerce_run_update_callback", "complete", "2025-06-18 03:11:15", "2025-06-18 03:11:15", "10", "{\"update_callback\":\"wc_update_990_remove_wc_count_comments_transient\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1750216275;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1750216275;}", "6", "1", "2025-06-18 03:11:34", "2025-06-18 03:11:34", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7872", "woocommerce_run_update_callback", "complete", "2025-06-18 03:11:16", "2025-06-18 03:11:16", "10", "{\"update_callback\":\"wc_update_990_remove_email_notes\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1750216276;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1750216276;}", "6", "1", "2025-06-18 03:11:34", "2025-06-18 03:11:34", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7873", "woocommerce_update_db_to_current_version", "complete", "2025-06-18 03:11:17", "2025-06-18 03:11:17", "10", "{\"version\":\"9.9.4\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1750216277;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1750216277;}", "6", "1", "2025-06-18 03:11:34", "2025-06-18 03:11:34", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7874", "woocommerce_run_product_attribute_lookup_regeneration_callback", "complete", "2025-06-18 03:11:15", "2025-06-18 03:11:15", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1750216275;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1750216275;}", "6", "1", "2025-06-18 03:11:34", "2025-06-18 03:11:34", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7875", "woocommerce_run_on_woocommerce_admin_updated", "complete", "2025-06-18 03:11:14", "2025-06-18 03:11:14", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1750216274;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1750216274;}", "9", "1", "2025-06-18 03:11:34", "2025-06-18 03:11:34", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7876", "woocommerce_refresh_order_count_cache", "complete", "2025-06-18 15:11:15", "2025-06-18 15:11:15", "10", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750259475;s:18:\"\0*\0first_timestamp\";i:1750259475;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750259475;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "10", "1", "2025-06-18 15:11:30", "2025-06-18 15:11:30", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7877", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-18 03:16:21", "2025-06-18 03:16:21", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750216581;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750216581;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-18 03:17:22", "2025-06-18 03:17:22", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7878", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-18 03:16:33", "2025-06-18 03:16:33", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750216593;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750216593;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-18 03:17:27", "2025-06-18 03:17:27", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7879", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-18 03:22:22", "2025-06-18 03:22:22", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750216942;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750216942;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-18 03:32:28", "2025-06-18 03:32:28", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7880", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-18 03:22:27", "2025-06-18 03:22:27", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750216947;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750216947;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-18 03:32:33", "2025-06-18 03:32:33", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7881", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-18 03:37:28", "2025-06-18 03:37:28", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750217848;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750217848;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-18 03:47:40", "2025-06-18 03:47:40", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7882", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-18 03:37:33", "2025-06-18 03:37:33", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750217853;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750217853;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-18 03:47:45", "2025-06-18 03:47:45", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7883", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-18 03:52:40", "2025-06-18 03:52:40", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750218760;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750218760;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-18 04:34:37", "2025-06-18 04:34:37", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7884", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-18 03:52:45", "2025-06-18 03:52:45", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750218765;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750218765;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-18 04:34:43", "2025-06-18 04:34:43", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7885", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-18 04:39:37", "2025-06-18 04:39:37", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750221577;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750221577;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-18 04:44:44", "2025-06-18 04:44:44", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7886", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-18 04:39:43", "2025-06-18 04:39:43", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750221583;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750221583;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-18 04:44:49", "2025-06-18 04:44:49", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7887", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-18 04:49:44", "2025-06-18 04:49:44", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750222184;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750222184;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-18 04:55:19", "2025-06-18 04:55:19", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7888", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-18 04:49:49", "2025-06-18 04:49:49", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750222189;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750222189;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-18 04:55:25", "2025-06-18 04:55:25", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7889", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-18 05:00:19", "2025-06-18 05:00:19", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750222819;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750222819;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-18 05:08:19", "2025-06-18 05:08:19", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7890", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-18 05:00:25", "2025-06-18 05:00:25", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750222825;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750222825;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-18 05:08:25", "2025-06-18 05:08:25", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7891", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-18 05:13:19", "2025-06-18 05:13:19", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750223599;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750223599;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-18 05:14:08", "2025-06-18 05:14:08", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7892", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-18 05:13:25", "2025-06-18 05:13:25", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750223605;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750223605;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-18 05:14:13", "2025-06-18 05:14:13", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7893", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-18 05:19:08", "2025-06-18 05:19:08", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750223948;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750223948;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-18 05:38:30", "2025-06-18 05:38:30", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7894", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-18 05:19:13", "2025-06-18 05:19:13", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750223953;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750223953;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-18 05:38:35", "2025-06-18 05:38:35", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7895", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-18 05:43:30", "2025-06-18 05:43:30", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750225410;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750225410;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-18 05:51:43", "2025-06-18 05:51:43", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7896", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-18 05:43:35", "2025-06-18 05:43:35", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750225415;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750225415;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-18 05:51:48", "2025-06-18 05:51:48", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7897", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-18 05:56:43", "2025-06-18 05:56:43", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750226203;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750226203;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-18 06:32:22", "2025-06-18 06:32:22", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7898", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-18 05:56:48", "2025-06-18 05:56:48", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750226208;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750226208;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-18 06:32:28", "2025-06-18 06:32:28", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7899", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-18 06:37:22", "2025-06-18 06:37:22", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750228642;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750228642;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-18 06:40:56", "2025-06-18 06:40:56", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7900", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-18 06:37:28", "2025-06-18 06:37:28", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750228648;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750228648;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-18 06:41:01", "2025-06-18 06:41:01", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7901", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-18 06:45:56", "2025-06-18 06:45:56", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750229156;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750229156;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-18 06:59:19", "2025-06-18 06:59:19", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7902", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-18 06:46:01", "2025-06-18 06:46:01", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750229161;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750229161;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-18 06:59:25", "2025-06-18 06:59:25", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7903", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-18 07:04:19", "2025-06-18 07:04:19", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750230259;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750230259;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-18 08:13:17", "2025-06-18 08:13:17", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7904", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-18 07:04:25", "2025-06-18 07:04:25", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750230265;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750230265;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-18 08:13:23", "2025-06-18 08:13:23", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7905", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-18 08:18:17", "2025-06-18 08:18:17", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750234697;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750234697;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-18 08:30:38", "2025-06-18 08:30:38", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7906", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-18 08:18:23", "2025-06-18 08:18:23", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750234703;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750234703;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-18 08:30:43", "2025-06-18 08:30:43", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7907", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-18 08:35:38", "2025-06-18 08:35:38", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750235738;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750235738;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-18 08:47:48", "2025-06-18 08:47:48", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7908", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-18 08:35:43", "2025-06-18 08:35:43", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750235743;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750235743;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-18 08:47:53", "2025-06-18 08:47:53", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7909", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-18 08:52:48", "2025-06-18 08:52:48", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750236768;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750236768;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-18 08:53:18", "2025-06-18 08:53:18", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7910", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-18 08:52:53", "2025-06-18 08:52:53", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750236773;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750236773;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-18 08:53:23", "2025-06-18 08:53:23", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7911", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-18 08:58:18", "2025-06-18 08:58:18", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750237098;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750237098;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-18 09:23:25", "2025-06-18 09:23:25", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7912", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-18 08:58:23", "2025-06-18 08:58:23", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750237103;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750237103;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-18 09:23:30", "2025-06-18 09:23:30", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7913", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-18 09:28:25", "2025-06-18 09:28:25", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750238905;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750238905;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-18 09:38:29", "2025-06-18 09:38:29", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7914", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-18 09:28:30", "2025-06-18 09:28:30", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750238910;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750238910;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-18 09:38:34", "2025-06-18 09:38:34", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7915", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-18 09:43:29", "2025-06-18 09:43:29", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750239809;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750239809;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-18 11:17:28", "2025-06-18 11:17:28", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7916", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-18 09:43:34", "2025-06-18 09:43:34", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750239814;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750239814;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-18 11:17:34", "2025-06-18 11:17:34", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7917", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-18 11:22:28", "2025-06-18 11:22:28", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750245748;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750245748;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-18 11:24:25", "2025-06-18 11:24:25", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7918", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-18 11:22:34", "2025-06-18 11:22:34", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750245754;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750245754;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-18 11:24:30", "2025-06-18 11:24:30", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7919", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-18 11:29:25", "2025-06-18 11:29:25", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750246165;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750246165;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-18 12:06:06", "2025-06-18 12:06:06", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7920", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-18 11:29:30", "2025-06-18 11:29:30", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750246170;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750246170;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-18 12:17:08", "2025-06-18 12:17:08", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7921", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-18 12:11:06", "2025-06-18 12:11:06", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750248666;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750248666;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-18 12:17:14", "2025-06-18 12:17:14", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7922", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-18 12:22:08", "2025-06-18 12:22:08", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750249328;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750249328;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-18 12:31:06", "2025-06-18 12:31:06", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7923", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-18 12:22:14", "2025-06-18 12:22:14", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750249334;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750249334;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-18 13:08:11", "2025-06-18 13:08:11", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7924", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-18 12:36:06", "2025-06-18 12:36:06", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750250166;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750250166;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-18 13:08:16", "2025-06-18 13:08:16", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7925", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-18 13:13:11", "2025-06-18 13:13:11", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750252391;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750252391;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-18 13:15:26", "2025-06-18 13:15:26", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7926", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-18 13:13:16", "2025-06-18 13:13:16", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750252396;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750252396;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-18 13:15:31", "2025-06-18 13:15:31", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7927", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-18 13:20:26", "2025-06-18 13:20:26", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750252826;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750252826;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-18 13:38:35", "2025-06-18 13:38:35", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7928", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-18 13:20:31", "2025-06-18 13:20:31", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750252831;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750252831;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-18 13:38:41", "2025-06-18 13:38:41", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7929", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-18 13:43:35", "2025-06-18 13:43:35", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750254215;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750254215;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-18 14:17:59", "2025-06-18 14:17:59", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7930", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-18 13:43:41", "2025-06-18 13:43:41", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750254221;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750254221;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-18 14:18:05", "2025-06-18 14:18:05", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7931", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-18 14:22:59", "2025-06-18 14:22:59", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750256579;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750256579;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-18 14:30:05", "2025-06-18 14:30:05", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7932", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-18 14:23:05", "2025-06-18 14:23:05", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750256585;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750256585;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-18 14:30:11", "2025-06-18 14:30:11", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7933", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-18 14:35:05", "2025-06-18 14:35:05", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750257305;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750257305;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-18 14:39:12", "2025-06-18 14:39:12", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7934", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-18 14:35:11", "2025-06-18 14:35:11", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750257311;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750257311;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-18 14:39:17", "2025-06-18 14:39:17", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7935", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-18 14:44:12", "2025-06-18 14:44:12", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750257852;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750257852;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-18 14:47:14", "2025-06-18 14:47:14", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7936", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-18 14:44:17", "2025-06-18 14:44:17", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750257857;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750257857;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-18 14:47:19", "2025-06-18 14:47:19", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7937", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-18 14:52:14", "2025-06-18 14:52:14", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750258334;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750258334;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-18 14:55:18", "2025-06-18 14:55:18", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7938", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-18 14:52:19", "2025-06-18 14:52:19", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750258339;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750258339;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-18 14:55:24", "2025-06-18 14:55:24", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7939", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-18 15:00:18", "2025-06-18 15:00:18", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750258818;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750258818;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-18 15:11:25", "2025-06-18 15:11:25", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7940", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-18 15:00:24", "2025-06-18 15:00:24", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750258824;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750258824;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-18 15:11:30", "2025-06-18 15:11:30", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7941", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-18 15:16:25", "2025-06-18 15:16:25", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750259785;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750259785;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-18 15:16:56", "2025-06-18 15:16:56", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7942", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-18 15:16:30", "2025-06-18 15:16:30", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750259790;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750259790;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-18 15:17:02", "2025-06-18 15:17:02", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7943", "woocommerce_refresh_order_count_cache", "complete", "2025-06-19 03:11:30", "2025-06-19 03:11:30", "10", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750302690;s:18:\"\0*\0first_timestamp\";i:1750259475;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750302690;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "10", "1", "2025-06-19 03:26:39", "2025-06-19 03:26:39", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7944", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-18 15:21:56", "2025-06-18 15:21:56", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750260116;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750260116;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-18 15:22:14", "2025-06-18 15:22:14", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7945", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-18 15:22:02", "2025-06-18 15:22:02", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750260122;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750260122;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-18 15:22:19", "2025-06-18 15:22:19", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7946", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-18 15:27:14", "2025-06-18 15:27:14", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750260434;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750260434;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-18 15:28:15", "2025-06-18 15:28:15", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7947", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-18 15:27:19", "2025-06-18 15:27:19", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750260439;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750260439;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-18 15:28:21", "2025-06-18 15:28:21", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7948", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-18 15:33:15", "2025-06-18 15:33:15", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750260795;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750260795;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-18 15:34:15", "2025-06-18 15:34:15", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7949", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-18 15:33:21", "2025-06-18 15:33:21", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750260801;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750260801;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-18 15:34:21", "2025-06-18 15:34:21", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7950", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-18 15:39:15", "2025-06-18 15:39:15", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750261155;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750261155;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-18 15:40:16", "2025-06-18 15:40:16", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7951", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-18 15:39:21", "2025-06-18 15:39:21", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750261161;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750261161;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-18 15:40:21", "2025-06-18 15:40:21", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7952", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-18 15:45:16", "2025-06-18 15:45:16", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750261516;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750261516;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-18 15:46:16", "2025-06-18 15:46:16", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7953", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-18 15:45:21", "2025-06-18 15:45:21", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750261521;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750261521;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-18 15:46:21", "2025-06-18 15:46:21", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7954", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-18 15:51:16", "2025-06-18 15:51:16", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750261876;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750261876;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-18 15:52:15", "2025-06-18 15:52:15", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7955", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-18 15:51:21", "2025-06-18 15:51:21", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750261881;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750261881;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-18 15:52:20", "2025-06-18 15:52:20", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7956", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-18 15:57:15", "2025-06-18 15:57:15", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750262235;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750262235;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-18 15:59:33", "2025-06-18 15:59:33", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7957", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-18 15:57:20", "2025-06-18 15:57:20", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750262240;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750262240;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-18 15:59:38", "2025-06-18 15:59:38", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7958", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-18 16:04:33", "2025-06-18 16:04:33", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750262673;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750262673;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-18 16:15:41", "2025-06-18 16:15:41", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7959", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-18 16:04:38", "2025-06-18 16:04:38", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750262678;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750262678;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-18 16:15:46", "2025-06-18 16:15:46", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7960", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-18 16:20:41", "2025-06-18 16:20:41", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750263641;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750263641;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-18 16:23:51", "2025-06-18 16:23:51", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7961", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-18 16:20:46", "2025-06-18 16:20:46", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750263646;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750263646;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-18 16:23:56", "2025-06-18 16:23:56", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7962", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-18 16:28:51", "2025-06-18 16:28:51", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750264131;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750264131;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-18 16:32:04", "2025-06-18 16:32:04", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7963", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-18 16:28:56", "2025-06-18 16:28:56", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750264136;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750264136;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-18 16:32:10", "2025-06-18 16:32:10", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7964", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-18 16:37:04", "2025-06-18 16:37:04", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750264624;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750264624;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-18 16:39:56", "2025-06-18 16:39:56", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7965", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-18 16:37:10", "2025-06-18 16:37:10", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750264630;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750264630;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-18 16:40:04", "2025-06-18 16:40:04", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7966", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-18 16:44:56", "2025-06-18 16:44:56", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750265096;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750265096;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-18 16:51:24", "2025-06-18 16:51:24", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7967", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-18 16:45:04", "2025-06-18 16:45:04", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750265104;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750265104;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-18 16:51:29", "2025-06-18 16:51:29", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7968", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-18 16:56:24", "2025-06-18 16:56:24", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750265784;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750265784;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-18 16:59:03", "2025-06-18 16:59:03", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7969", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-18 16:56:29", "2025-06-18 16:56:29", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750265789;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750265789;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-18 16:59:09", "2025-06-18 16:59:09", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7970", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-18 17:04:03", "2025-06-18 17:04:03", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750266243;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750266243;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-18 17:05:47", "2025-06-18 17:05:47", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7971", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-18 17:04:09", "2025-06-18 17:04:09", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750266249;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750266249;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-18 17:05:53", "2025-06-18 17:05:53", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7972", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-18 17:10:47", "2025-06-18 17:10:47", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750266647;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750266647;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-18 17:11:28", "2025-06-18 17:11:28", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7973", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-18 17:10:53", "2025-06-18 17:10:53", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750266653;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750266653;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-18 17:11:33", "2025-06-18 17:11:33", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7974", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-18 17:16:28", "2025-06-18 17:16:28", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750266988;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750266988;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-18 17:18:16", "2025-06-18 17:18:16", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7975", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-18 17:16:33", "2025-06-18 17:16:33", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750266993;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750266993;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-18 17:18:22", "2025-06-18 17:18:22", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7976", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-18 17:23:16", "2025-06-18 17:23:16", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750267396;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750267396;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-18 17:25:53", "2025-06-18 17:25:53", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7977", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-18 17:23:22", "2025-06-18 17:23:22", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750267402;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750267402;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-18 17:25:58", "2025-06-18 17:25:58", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7978", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-18 17:30:53", "2025-06-18 17:30:53", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750267853;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750267853;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-18 17:33:26", "2025-06-18 17:33:26", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7979", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-18 17:30:58", "2025-06-18 17:30:58", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750267858;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750267858;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-18 17:33:32", "2025-06-18 17:33:32", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7980", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-18 17:38:26", "2025-06-18 17:38:26", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750268306;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750268306;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-18 17:41:01", "2025-06-18 17:41:01", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7981", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-18 17:38:32", "2025-06-18 17:38:32", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750268312;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750268312;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-18 17:41:06", "2025-06-18 17:41:06", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7982", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-18 17:46:01", "2025-06-18 17:46:01", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750268761;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750268761;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-18 17:48:33", "2025-06-18 17:48:33", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7983", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-18 17:46:06", "2025-06-18 17:46:06", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750268766;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750268766;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-18 17:48:38", "2025-06-18 17:48:38", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7984", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-18 17:53:33", "2025-06-18 17:53:33", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750269213;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750269213;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-18 17:56:08", "2025-06-18 17:56:08", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7985", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-18 17:53:38", "2025-06-18 17:53:38", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750269218;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750269218;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-18 17:56:13", "2025-06-18 17:56:13", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7986", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-18 18:01:08", "2025-06-18 18:01:08", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750269668;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750269668;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-18 18:16:41", "2025-06-18 18:16:41", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7987", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-18 18:01:13", "2025-06-18 18:01:13", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750269673;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750269673;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-18 18:16:46", "2025-06-18 18:16:46", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7988", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-18 18:21:41", "2025-06-18 18:21:41", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750270901;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750270901;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-18 18:35:46", "2025-06-18 18:35:46", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7989", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-18 18:21:46", "2025-06-18 18:21:46", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750270906;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750270906;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-18 18:35:51", "2025-06-18 18:35:51", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7990", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-18 18:40:46", "2025-06-18 18:40:46", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750272046;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750272046;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-18 19:18:02", "2025-06-18 19:18:02", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7991", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-18 18:40:51", "2025-06-18 18:40:51", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750272051;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750272051;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-18 19:18:08", "2025-06-18 19:18:08", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7992", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-18 19:23:02", "2025-06-18 19:23:02", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750274582;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750274582;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-18 19:45:13", "2025-06-18 19:45:13", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7993", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-18 19:23:08", "2025-06-18 19:23:08", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750274588;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750274588;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-18 19:45:18", "2025-06-18 19:45:18", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7994", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-18 19:50:13", "2025-06-18 19:50:13", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750276213;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750276213;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-18 19:59:41", "2025-06-18 19:59:41", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7995", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-18 19:50:18", "2025-06-18 19:50:18", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750276218;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750276218;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-18 19:59:46", "2025-06-18 19:59:46", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7996", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-18 20:04:41", "2025-06-18 20:04:41", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750277081;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750277081;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-18 20:07:25", "2025-06-18 20:07:25", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7997", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-18 20:04:46", "2025-06-18 20:04:46", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750277086;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750277086;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-18 20:07:31", "2025-06-18 20:07:31", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7998", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-18 20:12:25", "2025-06-18 20:12:25", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750277545;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750277545;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-18 20:14:52", "2025-06-18 20:14:52", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("7999", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-18 20:12:31", "2025-06-18 20:12:31", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750277551;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750277551;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-18 20:14:57", "2025-06-18 20:14:57", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8000", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-18 20:19:52", "2025-06-18 20:19:52", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750277992;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750277992;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-18 20:24:41", "2025-06-18 20:24:41", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8001", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-18 20:19:57", "2025-06-18 20:19:57", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750277997;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750277997;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-18 20:24:46", "2025-06-18 20:24:46", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8002", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-18 20:29:41", "2025-06-18 20:29:41", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750278581;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750278581;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-18 20:41:27", "2025-06-18 20:41:27", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8003", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-18 20:29:46", "2025-06-18 20:29:46", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750278586;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750278586;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-18 20:41:32", "2025-06-18 20:41:32", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8004", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-18 20:46:27", "2025-06-18 20:46:27", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750279587;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750279587;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-18 20:57:06", "2025-06-18 20:57:06", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8005", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-18 20:46:32", "2025-06-18 20:46:32", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750279592;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750279592;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-18 20:57:12", "2025-06-18 20:57:12", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8006", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-18 21:02:06", "2025-06-18 21:02:06", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750280526;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750280526;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-18 21:26:51", "2025-06-18 21:26:51", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8007", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-18 21:02:12", "2025-06-18 21:02:12", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750280532;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750280532;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-18 21:26:56", "2025-06-18 21:26:56", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8008", "woocommerce_cleanup_draft_orders", "complete", "2025-06-19 21:00:40", "2025-06-19 21:00:40", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750366840;s:18:\"\0*\0first_timestamp\";i:1744536626;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750366840;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-06-19 21:29:03", "2025-06-19 21:29:03", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8009", "wpforms_process_forms_locator_scan", "complete", "2025-06-19 21:00:40", "2025-06-19 21:00:40", "10", "{\"tasks_meta_id\":1}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750366840;s:18:\"\0*\0first_timestamp\";i:1744536754;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750366840;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2025-06-19 21:29:03", "2025-06-19 21:29:03", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8010", "wpforms_process_purge_spam", "complete", "2025-06-19 21:00:40", "2025-06-19 21:00:40", "10", "{\"tasks_meta_id\":2}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750366840;s:18:\"\0*\0first_timestamp\";i:1744536754;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750366840;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2025-06-19 21:29:03", "2025-06-19 21:29:03", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8011", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-18 21:31:51", "2025-06-18 21:31:51", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750282311;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750282311;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-18 21:59:25", "2025-06-18 21:59:25", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8012", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-18 21:31:56", "2025-06-18 21:31:56", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750282316;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750282316;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-18 21:59:30", "2025-06-18 21:59:30", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8013", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-18 22:04:25", "2025-06-18 22:04:25", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750284265;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750284265;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-18 22:58:46", "2025-06-18 22:58:46", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8014", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-18 22:04:30", "2025-06-18 22:04:30", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750284270;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750284270;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-18 22:58:52", "2025-06-18 22:58:52", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8015", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-18 23:03:46", "2025-06-18 23:03:46", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750287826;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750287826;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-18 23:39:57", "2025-06-18 23:39:57", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8016", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-18 23:03:52", "2025-06-18 23:03:52", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750287832;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750287832;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-18 23:40:02", "2025-06-18 23:40:02", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8017", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-18 23:44:57", "2025-06-18 23:44:57", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750290297;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750290297;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-19 00:08:06", "2025-06-19 00:08:06", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8018", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-18 23:45:02", "2025-06-18 23:45:02", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750290302;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750290302;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-19 00:08:11", "2025-06-19 00:08:11", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8019", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-19 00:13:06", "2025-06-19 00:13:06", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750291986;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750291986;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-19 00:16:09", "2025-06-19 00:16:09", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8020", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-19 00:13:11", "2025-06-19 00:13:11", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750291991;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750291991;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-19 00:16:15", "2025-06-19 00:16:15", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8021", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-19 00:21:09", "2025-06-19 00:21:09", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750292469;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750292469;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-19 00:50:45", "2025-06-19 00:50:45", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8022", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-19 00:21:15", "2025-06-19 00:21:15", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750292475;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750292475;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-19 00:50:50", "2025-06-19 00:50:50", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8023", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-19 00:55:45", "2025-06-19 00:55:45", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750294545;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750294545;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-19 01:42:38", "2025-06-19 01:42:38", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8024", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-19 00:55:50", "2025-06-19 00:55:50", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750294550;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750294550;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-19 01:42:43", "2025-06-19 01:42:43", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8025", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-19 01:47:38", "2025-06-19 01:47:38", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750297658;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750297658;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-19 01:48:10", "2025-06-19 01:48:10", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8026", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-19 01:47:43", "2025-06-19 01:47:43", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750297663;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750297663;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-19 01:48:15", "2025-06-19 01:48:15", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8027", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-19 01:53:10", "2025-06-19 01:53:10", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750297990;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750297990;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-19 01:54:19", "2025-06-19 01:54:19", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8028", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-19 01:53:15", "2025-06-19 01:53:15", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750297995;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750297995;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-19 01:54:24", "2025-06-19 01:54:24", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8029", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-19 01:59:19", "2025-06-19 01:59:19", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750298359;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750298359;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-19 02:20:20", "2025-06-19 02:20:20", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8030", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-19 01:59:24", "2025-06-19 01:59:24", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750298364;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750298364;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-19 02:20:25", "2025-06-19 02:20:25", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8031", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-19 02:25:20", "2025-06-19 02:25:20", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750299920;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750299920;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-19 02:34:23", "2025-06-19 02:34:23", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8032", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-19 02:25:25", "2025-06-19 02:25:25", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750299925;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750299925;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-19 02:34:28", "2025-06-19 02:34:28", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8033", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-19 02:39:23", "2025-06-19 02:39:23", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750300763;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750300763;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-19 02:40:46", "2025-06-19 02:40:46", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8034", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-19 02:39:28", "2025-06-19 02:39:28", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750300768;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750300768;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-19 02:40:52", "2025-06-19 02:40:52", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8035", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-19 02:45:46", "2025-06-19 02:45:46", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750301146;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750301146;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-19 03:26:34", "2025-06-19 03:26:34", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8036", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-19 02:45:52", "2025-06-19 02:45:52", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750301152;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750301152;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-19 03:26:39", "2025-06-19 03:26:39", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8037", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-19 03:31:34", "2025-06-19 03:31:34", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750303894;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750303894;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-19 04:58:53", "2025-06-19 04:58:53", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8038", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-19 03:31:39", "2025-06-19 03:31:39", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750303899;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750303899;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-19 04:58:59", "2025-06-19 04:58:59", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8039", "woocommerce_refresh_order_count_cache", "complete", "2025-06-19 15:26:39", "2025-06-19 15:26:39", "10", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750346799;s:18:\"\0*\0first_timestamp\";i:1750259475;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750346799;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "10", "1", "2025-06-19 15:31:16", "2025-06-19 15:31:16", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8040", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-19 05:03:53", "2025-06-19 05:03:53", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750309433;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750309433;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-19 05:54:07", "2025-06-19 05:54:07", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8041", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-19 05:03:59", "2025-06-19 05:03:59", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750309439;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750309439;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-19 05:54:13", "2025-06-19 05:54:13", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8042", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-19 05:59:07", "2025-06-19 05:59:07", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750312747;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750312747;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-19 06:09:24", "2025-06-19 06:09:24", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8043", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-19 05:59:13", "2025-06-19 05:59:13", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750312753;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750312753;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-19 06:09:29", "2025-06-19 06:09:29", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8044", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-19 06:14:24", "2025-06-19 06:14:24", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750313664;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750313664;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-19 06:19:53", "2025-06-19 06:19:53", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8045", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-19 06:14:29", "2025-06-19 06:14:29", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750313669;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750313669;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-19 06:19:58", "2025-06-19 06:19:58", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8046", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-19 06:24:53", "2025-06-19 06:24:53", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750314293;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750314293;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-19 06:26:55", "2025-06-19 06:26:55", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8047", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-19 06:24:58", "2025-06-19 06:24:58", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750314298;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750314298;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-19 06:27:00", "2025-06-19 06:27:00", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8048", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-19 06:31:55", "2025-06-19 06:31:55", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750314715;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750314715;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-19 06:35:59", "2025-06-19 06:35:59", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8049", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-19 06:32:00", "2025-06-19 06:32:00", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750314720;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750314720;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-19 06:36:04", "2025-06-19 06:36:04", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8050", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-19 06:40:59", "2025-06-19 06:40:59", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750315259;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750315259;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-19 06:44:11", "2025-06-19 06:44:11", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8051", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-19 06:41:04", "2025-06-19 06:41:04", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750315264;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750315264;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-19 06:44:16", "2025-06-19 06:44:16", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8052", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-19 06:49:11", "2025-06-19 06:49:11", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750315751;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750315751;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-19 06:52:26", "2025-06-19 06:52:26", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8053", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-19 06:49:16", "2025-06-19 06:49:16", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750315756;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750315756;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-19 06:52:31", "2025-06-19 06:52:31", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8054", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-19 06:57:26", "2025-06-19 06:57:26", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750316246;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750316246;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-19 07:00:48", "2025-06-19 07:00:48", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8055", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-19 06:57:31", "2025-06-19 06:57:31", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750316251;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750316251;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-19 07:00:53", "2025-06-19 07:00:53", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8056", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-19 07:05:48", "2025-06-19 07:05:48", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750316748;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750316748;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-19 07:09:13", "2025-06-19 07:09:13", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8057", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-19 07:05:53", "2025-06-19 07:05:53", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750316753;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750316753;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-19 07:09:18", "2025-06-19 07:09:18", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8058", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-19 07:14:13", "2025-06-19 07:14:13", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750317253;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750317253;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-19 07:17:46", "2025-06-19 07:17:46", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8059", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-19 07:14:18", "2025-06-19 07:14:18", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750317258;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750317258;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-19 07:17:51", "2025-06-19 07:17:51", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8060", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-19 07:22:46", "2025-06-19 07:22:46", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750317766;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750317766;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-19 07:26:21", "2025-06-19 07:26:21", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8061", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-19 07:22:51", "2025-06-19 07:22:51", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750317771;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750317771;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-19 07:26:26", "2025-06-19 07:26:26", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8062", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-19 07:31:21", "2025-06-19 07:31:21", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750318281;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750318281;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-19 07:34:52", "2025-06-19 07:34:52", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8063", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-19 07:31:26", "2025-06-19 07:31:26", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750318286;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750318286;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-19 07:34:57", "2025-06-19 07:34:57", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8064", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-19 07:39:52", "2025-06-19 07:39:52", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750318792;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750318792;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-19 07:43:23", "2025-06-19 07:43:23", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8065", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-19 07:39:57", "2025-06-19 07:39:57", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750318797;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750318797;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-19 07:43:29", "2025-06-19 07:43:29", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8066", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-19 07:48:23", "2025-06-19 07:48:23", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750319303;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750319303;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-19 07:51:55", "2025-06-19 07:51:55", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8067", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-19 07:48:29", "2025-06-19 07:48:29", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750319309;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750319309;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-19 07:52:01", "2025-06-19 07:52:01", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8068", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-19 07:56:55", "2025-06-19 07:56:55", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750319815;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750319815;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-19 08:00:25", "2025-06-19 08:00:25", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8069", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-19 07:57:01", "2025-06-19 07:57:01", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750319821;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750319821;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-19 08:00:31", "2025-06-19 08:00:31", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8070", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-19 08:05:25", "2025-06-19 08:05:25", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750320325;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750320325;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-19 08:17:37", "2025-06-19 08:17:37", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8071", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-19 08:05:31", "2025-06-19 08:05:31", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750320331;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750320331;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-19 08:17:43", "2025-06-19 08:17:43", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8072", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-19 08:22:37", "2025-06-19 08:22:37", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750321357;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750321357;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-19 08:26:01", "2025-06-19 08:26:01", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8073", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-19 08:22:43", "2025-06-19 08:22:43", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750321363;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750321363;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-19 08:26:07", "2025-06-19 08:26:07", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8074", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-19 08:31:02", "2025-06-19 08:31:02", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750321862;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750321862;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-19 08:34:37", "2025-06-19 08:34:37", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8075", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-19 08:31:07", "2025-06-19 08:31:07", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750321867;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750321867;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-19 08:34:44", "2025-06-19 08:34:44", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8076", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-19 08:39:37", "2025-06-19 08:39:37", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750322377;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750322377;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-19 08:43:14", "2025-06-19 08:43:14", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8077", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-19 08:39:44", "2025-06-19 08:39:44", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750322384;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750322384;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-19 08:43:19", "2025-06-19 08:43:19", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8078", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-19 08:48:14", "2025-06-19 08:48:14", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750322894;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750322894;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-19 08:56:03", "2025-06-19 08:56:03", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8079", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-19 08:48:19", "2025-06-19 08:48:19", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750322899;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750322899;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-19 08:56:08", "2025-06-19 08:56:08", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8080", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-19 09:01:03", "2025-06-19 09:01:03", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750323663;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750323663;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-19 09:04:37", "2025-06-19 09:04:37", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8081", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-19 09:01:08", "2025-06-19 09:01:08", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750323668;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750323668;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-19 09:04:42", "2025-06-19 09:04:42", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8082", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-19 09:09:37", "2025-06-19 09:09:37", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750324177;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750324177;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-19 09:09:44", "2025-06-19 09:09:44", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8083", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-19 09:09:42", "2025-06-19 09:09:42", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750324182;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750324182;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-19 09:09:49", "2025-06-19 09:09:49", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8084", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-19 09:14:44", "2025-06-19 09:14:44", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750324484;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750324484;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-19 09:21:50", "2025-06-19 09:21:50", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8085", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-19 09:14:49", "2025-06-19 09:14:49", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750324489;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750324489;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-19 09:21:55", "2025-06-19 09:21:55", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8086", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-19 09:26:50", "2025-06-19 09:26:50", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750325210;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750325210;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-19 09:28:39", "2025-06-19 09:28:39", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8087", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-19 09:26:55", "2025-06-19 09:26:55", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750325215;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750325215;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-19 09:28:45", "2025-06-19 09:28:45", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8088", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-19 09:33:40", "2025-06-19 09:33:40", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750325620;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750325620;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-19 09:38:05", "2025-06-19 09:38:05", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8089", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-19 09:33:45", "2025-06-19 09:33:45", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750325625;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750325625;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-19 09:38:11", "2025-06-19 09:38:11", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8090", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-19 09:43:05", "2025-06-19 09:43:05", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750326185;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750326185;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-19 09:47:17", "2025-06-19 09:47:17", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8091", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-19 09:43:11", "2025-06-19 09:43:11", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750326191;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750326191;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-19 09:47:22", "2025-06-19 09:47:22", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8092", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-19 09:52:17", "2025-06-19 09:52:17", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750326737;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750326737;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-19 09:52:50", "2025-06-19 09:52:50", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8093", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-19 09:52:22", "2025-06-19 09:52:22", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750326742;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750326742;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-19 09:52:56", "2025-06-19 09:52:56", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8094", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-19 09:57:50", "2025-06-19 09:57:50", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750327070;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750327070;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-19 10:00:05", "2025-06-19 10:00:05", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8095", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-19 09:57:56", "2025-06-19 09:57:56", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750327076;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750327076;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-19 10:03:25", "2025-06-19 10:03:25", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8096", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-19 10:05:05", "2025-06-19 10:05:05", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750327505;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750327505;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-19 10:08:40", "2025-06-19 10:08:40", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8097", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-19 10:08:25", "2025-06-19 10:08:25", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750327705;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750327705;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-19 10:08:45", "2025-06-19 10:08:45", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8098", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-19 10:13:40", "2025-06-19 10:13:40", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750328020;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750328020;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-19 10:16:03", "2025-06-19 10:16:03", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8099", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-19 10:13:45", "2025-06-19 10:13:45", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750328025;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750328025;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-19 10:16:09", "2025-06-19 10:16:09", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8100", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-19 10:21:03", "2025-06-19 10:21:03", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750328463;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750328463;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-19 10:21:29", "2025-06-19 10:21:29", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8101", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-19 10:21:09", "2025-06-19 10:21:09", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750328469;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750328469;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-19 10:21:34", "2025-06-19 10:21:34", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8102", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-19 10:26:29", "2025-06-19 10:26:29", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750328789;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750328789;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-19 10:36:44", "2025-06-19 10:36:44", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8103", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-19 10:26:34", "2025-06-19 10:26:34", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750328794;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750328794;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-19 10:36:50", "2025-06-19 10:36:50", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8104", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-19 10:41:44", "2025-06-19 10:41:44", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750329704;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750329704;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-19 10:43:00", "2025-06-19 10:43:00", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8105", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-19 10:41:50", "2025-06-19 10:41:50", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750329710;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750329710;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-19 10:43:06", "2025-06-19 10:43:06", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8106", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-19 10:48:00", "2025-06-19 10:48:00", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750330080;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750330080;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-19 10:51:35", "2025-06-19 10:51:35", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8107", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-19 10:48:06", "2025-06-19 10:48:06", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750330086;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750330086;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-19 10:51:40", "2025-06-19 10:51:40", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8108", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-19 10:56:35", "2025-06-19 10:56:35", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750330595;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750330595;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-19 10:57:56", "2025-06-19 10:57:56", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8109", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-19 10:56:40", "2025-06-19 10:56:40", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750330600;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750330600;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-19 10:58:02", "2025-06-19 10:58:02", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8110", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-19 11:02:56", "2025-06-19 11:02:56", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750330976;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750330976;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-19 11:05:24", "2025-06-19 11:05:24", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8111", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-19 11:03:02", "2025-06-19 11:03:02", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750330982;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750330982;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-19 11:05:30", "2025-06-19 11:05:30", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8112", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-19 11:10:24", "2025-06-19 11:10:24", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750331424;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750331424;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-19 11:13:20", "2025-06-19 11:13:20", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8113", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-19 11:10:30", "2025-06-19 11:10:30", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750331430;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750331430;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-19 11:13:26", "2025-06-19 11:13:26", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8114", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-19 11:18:20", "2025-06-19 11:18:20", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750331900;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750331900;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-19 11:19:08", "2025-06-19 11:19:08", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8115", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-19 11:18:26", "2025-06-19 11:18:26", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750331906;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750331906;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-19 11:19:13", "2025-06-19 11:19:13", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8116", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-19 11:24:08", "2025-06-19 11:24:08", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750332248;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750332248;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-19 11:25:08", "2025-06-19 11:25:08", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8117", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-19 11:24:13", "2025-06-19 11:24:13", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750332253;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750332253;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-19 11:25:14", "2025-06-19 11:25:14", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8118", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-19 11:30:08", "2025-06-19 11:30:08", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750332608;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750332608;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-19 11:31:08", "2025-06-19 11:31:08", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8119", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-19 11:30:14", "2025-06-19 11:30:14", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750332614;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750332614;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-19 11:31:13", "2025-06-19 11:31:13", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8120", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-19 11:36:08", "2025-06-19 11:36:08", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750332968;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750332968;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-19 11:37:08", "2025-06-19 11:37:08", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8121", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-19 11:36:13", "2025-06-19 11:36:13", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750332973;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750332973;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-19 11:37:13", "2025-06-19 11:37:13", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8122", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-19 11:42:08", "2025-06-19 11:42:08", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750333328;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750333328;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-19 11:43:08", "2025-06-19 11:43:08", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8123", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-19 11:42:13", "2025-06-19 11:42:13", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750333333;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750333333;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-19 11:43:13", "2025-06-19 11:43:13", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8124", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-19 11:48:08", "2025-06-19 11:48:08", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750333688;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750333688;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-19 11:49:08", "2025-06-19 11:49:08", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8125", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-19 11:48:13", "2025-06-19 11:48:13", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750333693;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750333693;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-19 11:49:14", "2025-06-19 11:49:14", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8126", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-19 11:54:08", "2025-06-19 11:54:08", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750334048;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750334048;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-19 11:55:08", "2025-06-19 11:55:08", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8127", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-19 11:54:14", "2025-06-19 11:54:14", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750334054;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750334054;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-19 11:55:14", "2025-06-19 11:55:14", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8128", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-19 12:00:08", "2025-06-19 12:00:08", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750334408;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750334408;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-19 12:01:40", "2025-06-19 12:01:40", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8129", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-19 12:00:14", "2025-06-19 12:00:14", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750334414;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750334414;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-19 12:02:05", "2025-06-19 12:02:05", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8130", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-19 12:06:40", "2025-06-19 12:06:40", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750334800;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750334800;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-19 12:07:09", "2025-06-19 12:07:09", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8131", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-19 12:07:05", "2025-06-19 12:07:05", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750334825;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750334825;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-19 12:07:14", "2025-06-19 12:07:14", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8132", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-19 12:12:09", "2025-06-19 12:12:09", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750335129;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750335129;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-19 12:13:09", "2025-06-19 12:13:09", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8133", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-19 12:12:14", "2025-06-19 12:12:14", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750335134;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750335134;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-19 12:13:14", "2025-06-19 12:13:14", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8134", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-19 12:18:09", "2025-06-19 12:18:09", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750335489;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750335489;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-19 12:19:08", "2025-06-19 12:19:08", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8135", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-19 12:18:14", "2025-06-19 12:18:14", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750335494;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750335494;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-19 12:19:14", "2025-06-19 12:19:14", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8136", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-19 12:24:08", "2025-06-19 12:24:08", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750335848;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750335848;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-19 12:25:08", "2025-06-19 12:25:08", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8137", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-19 12:24:14", "2025-06-19 12:24:14", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750335854;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750335854;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-19 12:25:14", "2025-06-19 12:25:14", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8138", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-19 12:30:08", "2025-06-19 12:30:08", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750336208;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750336208;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-19 12:31:09", "2025-06-19 12:31:09", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8139", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-19 12:30:14", "2025-06-19 12:30:14", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750336214;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750336214;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-19 12:31:15", "2025-06-19 12:31:15", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8140", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-19 12:36:09", "2025-06-19 12:36:09", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750336569;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750336569;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-19 12:37:08", "2025-06-19 12:37:08", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8141", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-19 12:36:15", "2025-06-19 12:36:15", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750336575;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750336575;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-19 12:37:14", "2025-06-19 12:37:14", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8142", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-19 12:42:09", "2025-06-19 12:42:09", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750336929;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750336929;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-19 12:43:08", "2025-06-19 12:43:08", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8143", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-19 12:42:14", "2025-06-19 12:42:14", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750336934;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750336934;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-19 12:43:14", "2025-06-19 12:43:14", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8144", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-19 12:48:08", "2025-06-19 12:48:08", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750337288;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750337288;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-19 12:49:08", "2025-06-19 12:49:08", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8145", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-19 12:48:14", "2025-06-19 12:48:14", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750337294;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750337294;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-19 12:49:14", "2025-06-19 12:49:14", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8146", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-19 12:54:08", "2025-06-19 12:54:08", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750337648;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750337648;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-19 12:55:09", "2025-06-19 12:55:09", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8147", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-19 12:54:14", "2025-06-19 12:54:14", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750337654;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750337654;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-19 12:55:14", "2025-06-19 12:55:14", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8148", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-19 13:00:09", "2025-06-19 13:00:09", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750338009;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750338009;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-19 13:01:29", "2025-06-19 13:01:29", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8149", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-19 13:00:14", "2025-06-19 13:00:14", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750338014;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750338014;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-19 13:02:08", "2025-06-19 13:02:08", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8150", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-19 13:06:29", "2025-06-19 13:06:29", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750338389;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750338389;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-19 13:07:08", "2025-06-19 13:07:08", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8151", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-19 13:07:08", "2025-06-19 13:07:08", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750338428;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750338428;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-19 13:07:14", "2025-06-19 13:07:14", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8152", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-19 13:12:08", "2025-06-19 13:12:08", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750338728;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750338728;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-19 13:13:08", "2025-06-19 13:13:08", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8153", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-19 13:12:14", "2025-06-19 13:12:14", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750338734;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750338734;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-19 13:13:13", "2025-06-19 13:13:13", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8154", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-19 13:18:08", "2025-06-19 13:18:08", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750339088;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750339088;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-19 13:19:08", "2025-06-19 13:19:08", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8155", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-19 13:18:13", "2025-06-19 13:18:13", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750339093;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750339093;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-19 13:19:13", "2025-06-19 13:19:13", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8156", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-19 13:24:08", "2025-06-19 13:24:08", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750339448;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750339448;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-19 13:25:08", "2025-06-19 13:25:08", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8157", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-19 13:24:13", "2025-06-19 13:24:13", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750339453;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750339453;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-19 13:25:14", "2025-06-19 13:25:14", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8158", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-19 13:30:08", "2025-06-19 13:30:08", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750339808;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750339808;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-19 13:31:09", "2025-06-19 13:31:09", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8159", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-19 13:30:14", "2025-06-19 13:30:14", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750339814;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750339814;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-19 13:31:15", "2025-06-19 13:31:15", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8160", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-19 13:36:09", "2025-06-19 13:36:09", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750340169;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750340169;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-19 13:37:08", "2025-06-19 13:37:08", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8161", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-19 13:36:15", "2025-06-19 13:36:15", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750340175;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750340175;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-19 13:37:13", "2025-06-19 13:37:13", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8162", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-19 13:42:08", "2025-06-19 13:42:08", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750340528;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750340528;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-19 13:43:08", "2025-06-19 13:43:08", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8163", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-19 13:42:13", "2025-06-19 13:42:13", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750340533;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750340533;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-19 13:43:14", "2025-06-19 13:43:14", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8164", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-19 13:48:08", "2025-06-19 13:48:08", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750340888;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750340888;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-19 13:49:09", "2025-06-19 13:49:09", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8165", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-19 13:48:14", "2025-06-19 13:48:14", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750340894;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750340894;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-19 13:49:14", "2025-06-19 13:49:14", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8166", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-19 13:54:09", "2025-06-19 13:54:09", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750341249;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750341249;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-19 13:55:09", "2025-06-19 13:55:09", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8167", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-19 13:54:14", "2025-06-19 13:54:14", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750341254;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750341254;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-19 13:55:14", "2025-06-19 13:55:14", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8168", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-19 14:00:09", "2025-06-19 14:00:09", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750341609;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750341609;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-19 14:01:09", "2025-06-19 14:01:09", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8169", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-19 14:00:14", "2025-06-19 14:00:14", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750341614;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750341614;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-19 14:01:14", "2025-06-19 14:01:14", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8170", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-19 14:06:09", "2025-06-19 14:06:09", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750341969;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750341969;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-19 14:07:09", "2025-06-19 14:07:09", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8171", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-19 14:06:14", "2025-06-19 14:06:14", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750341974;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750341974;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-19 14:07:14", "2025-06-19 14:07:14", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8172", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-19 14:12:09", "2025-06-19 14:12:09", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750342329;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750342329;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-19 14:13:08", "2025-06-19 14:13:08", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8173", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-19 14:12:14", "2025-06-19 14:12:14", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750342334;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750342334;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-19 14:13:14", "2025-06-19 14:13:14", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8174", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-19 14:18:08", "2025-06-19 14:18:08", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750342688;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750342688;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-19 14:19:09", "2025-06-19 14:19:09", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8175", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-19 14:18:14", "2025-06-19 14:18:14", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750342694;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750342694;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-19 14:19:14", "2025-06-19 14:19:14", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8176", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-19 14:24:09", "2025-06-19 14:24:09", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750343049;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750343049;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-19 14:25:09", "2025-06-19 14:25:09", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8177", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-19 14:24:14", "2025-06-19 14:24:14", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750343054;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750343054;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-19 14:25:14", "2025-06-19 14:25:14", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8178", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-19 14:30:09", "2025-06-19 14:30:09", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750343409;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750343409;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-19 14:43:16", "2025-06-19 14:43:16", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8179", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-19 14:30:14", "2025-06-19 14:30:14", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750343414;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750343414;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-19 14:43:21", "2025-06-19 14:43:21", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8180", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-19 14:48:16", "2025-06-19 14:48:16", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750344496;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750344496;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-19 14:57:58", "2025-06-19 14:57:58", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8181", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-19 14:48:21", "2025-06-19 14:48:21", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750344501;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750344501;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-19 14:58:04", "2025-06-19 14:58:04", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8182", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-19 15:02:58", "2025-06-19 15:02:58", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750345378;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750345378;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-19 15:24:21", "2025-06-19 15:24:21", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8183", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-19 15:03:04", "2025-06-19 15:03:04", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750345384;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750345384;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-19 15:24:26", "2025-06-19 15:24:26", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8184", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-19 15:29:21", "2025-06-19 15:29:21", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750346961;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750346961;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-19 15:31:22", "2025-06-19 15:31:22", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8185", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-19 15:29:26", "2025-06-19 15:29:26", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750346966;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750346966;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-19 15:31:27", "2025-06-19 15:31:27", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8186", "woocommerce_refresh_order_count_cache", "complete", "2025-06-20 03:31:16", "2025-06-20 03:31:16", "10", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750390276;s:18:\"\0*\0first_timestamp\";i:1750259475;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750390276;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "10", "1", "2025-06-20 03:32:09", "2025-06-20 03:32:09", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8187", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-19 15:36:22", "2025-06-19 15:36:22", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750347382;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750347382;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-19 15:37:06", "2025-06-19 15:37:06", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8188", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-19 15:36:27", "2025-06-19 15:36:27", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750347387;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750347387;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-19 15:38:06", "2025-06-19 15:38:06", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8189", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-19 15:42:06", "2025-06-19 15:42:06", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750347726;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750347726;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-19 15:45:19", "2025-06-19 15:45:19", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8190", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-19 15:43:06", "2025-06-19 15:43:06", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750347786;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750347786;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-19 15:45:25", "2025-06-19 15:45:25", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8191", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-19 15:50:19", "2025-06-19 15:50:19", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750348219;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750348219;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-19 15:52:10", "2025-06-19 15:52:10", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8192", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-19 15:50:25", "2025-06-19 15:50:25", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750348225;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750348225;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-19 15:52:15", "2025-06-19 15:52:15", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8193", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-19 15:57:10", "2025-06-19 15:57:10", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750348630;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750348630;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-19 15:58:49", "2025-06-19 15:58:49", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8194", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-19 15:57:15", "2025-06-19 15:57:15", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750348635;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750348635;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-19 15:58:54", "2025-06-19 15:58:54", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8195", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-19 16:03:49", "2025-06-19 16:03:49", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750349029;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750349029;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-19 16:25:38", "2025-06-19 16:25:38", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8196", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-19 16:03:54", "2025-06-19 16:03:54", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750349034;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750349034;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-19 16:25:43", "2025-06-19 16:25:43", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8197", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-19 16:30:38", "2025-06-19 16:30:38", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750350638;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750350638;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-19 16:32:10", "2025-06-19 16:32:10", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8198", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-19 16:30:43", "2025-06-19 16:30:43", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750350643;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750350643;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-19 16:32:16", "2025-06-19 16:32:16", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8199", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-19 16:37:10", "2025-06-19 16:37:10", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750351030;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750351030;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-19 16:38:50", "2025-06-19 16:38:50", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8200", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-19 16:37:16", "2025-06-19 16:37:16", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750351036;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750351036;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-19 16:38:55", "2025-06-19 16:38:55", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8201", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-19 16:43:50", "2025-06-19 16:43:50", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750351430;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750351430;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-19 16:45:09", "2025-06-19 16:45:09", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8202", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-19 16:43:55", "2025-06-19 16:43:55", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750351435;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750351435;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-19 16:45:14", "2025-06-19 16:45:14", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8203", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-19 16:50:09", "2025-06-19 16:50:09", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750351809;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750351809;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-19 16:51:31", "2025-06-19 16:51:31", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8204", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-19 16:50:14", "2025-06-19 16:50:14", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750351814;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750351814;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-19 16:51:37", "2025-06-19 16:51:37", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8205", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-19 16:56:31", "2025-06-19 16:56:31", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750352191;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750352191;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-19 16:57:55", "2025-06-19 16:57:55", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8206", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-19 16:56:37", "2025-06-19 16:56:37", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750352197;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750352197;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-19 16:58:00", "2025-06-19 16:58:00", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8207", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-19 17:02:55", "2025-06-19 17:02:55", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750352575;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750352575;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-19 17:09:06", "2025-06-19 17:09:06", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8208", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-19 17:03:00", "2025-06-19 17:03:00", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750352580;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750352580;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-19 17:09:12", "2025-06-19 17:09:12", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8209", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-19 17:14:06", "2025-06-19 17:14:06", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750353246;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750353246;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-19 17:15:57", "2025-06-19 17:15:57", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8210", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-19 17:14:12", "2025-06-19 17:14:12", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750353252;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750353252;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-19 17:16:03", "2025-06-19 17:16:03", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8211", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-19 17:20:57", "2025-06-19 17:20:57", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750353657;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750353657;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-19 17:21:09", "2025-06-19 17:21:09", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8212", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-19 17:21:03", "2025-06-19 17:21:03", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750353663;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750353663;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-19 17:21:15", "2025-06-19 17:21:15", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8213", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-19 17:26:09", "2025-06-19 17:26:09", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750353969;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750353969;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-19 17:30:46", "2025-06-19 17:30:46", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8214", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-19 17:26:15", "2025-06-19 17:26:15", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750353975;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750353975;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-19 17:30:51", "2025-06-19 17:30:51", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8215", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-19 17:35:46", "2025-06-19 17:35:46", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750354546;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750354546;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-19 17:37:09", "2025-06-19 17:37:09", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8216", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-19 17:35:51", "2025-06-19 17:35:51", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750354551;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750354551;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-19 17:37:15", "2025-06-19 17:37:15", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8217", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-19 17:42:09", "2025-06-19 17:42:09", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750354929;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750354929;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-19 17:43:31", "2025-06-19 17:43:31", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8218", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-19 17:42:15", "2025-06-19 17:42:15", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750354935;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750354935;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-19 17:43:36", "2025-06-19 17:43:36", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8219", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-19 17:48:31", "2025-06-19 17:48:31", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750355311;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750355311;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-19 17:50:02", "2025-06-19 17:50:02", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8220", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-19 17:48:36", "2025-06-19 17:48:36", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750355316;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750355316;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-19 17:50:08", "2025-06-19 17:50:08", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8221", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-19 17:55:02", "2025-06-19 17:55:02", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750355702;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750355702;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-19 17:56:29", "2025-06-19 17:56:29", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8222", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-19 17:55:08", "2025-06-19 17:55:08", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750355708;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750355708;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-19 17:56:35", "2025-06-19 17:56:35", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8223", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-19 18:01:29", "2025-06-19 18:01:29", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750356089;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750356089;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-19 18:08:53", "2025-06-19 18:08:53", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8224", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-19 18:01:35", "2025-06-19 18:01:35", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750356095;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750356095;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-19 18:08:59", "2025-06-19 18:08:59", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8225", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-19 18:13:53", "2025-06-19 18:13:53", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750356833;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750356833;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-19 18:15:55", "2025-06-19 18:15:55", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8226", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-19 18:13:59", "2025-06-19 18:13:59", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750356839;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750356839;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-19 18:16:00", "2025-06-19 18:16:00", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8227", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-19 18:20:55", "2025-06-19 18:20:55", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750357255;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750357255;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-19 18:22:29", "2025-06-19 18:22:29", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8228", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-19 18:21:00", "2025-06-19 18:21:00", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750357260;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750357260;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-19 18:22:35", "2025-06-19 18:22:35", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8229", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-19 18:27:29", "2025-06-19 18:27:29", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750357649;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750357649;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-19 18:28:59", "2025-06-19 18:28:59", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8230", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-19 18:27:35", "2025-06-19 18:27:35", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750357655;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750357655;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-19 18:29:05", "2025-06-19 18:29:05", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8231", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-19 18:33:59", "2025-06-19 18:33:59", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750358039;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750358039;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-19 18:35:24", "2025-06-19 18:35:24", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8232", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-19 18:34:05", "2025-06-19 18:34:05", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750358045;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750358045;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-19 18:35:29", "2025-06-19 18:35:29", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8233", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-19 18:40:24", "2025-06-19 18:40:24", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750358424;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750358424;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-19 18:42:10", "2025-06-19 18:42:10", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8234", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-19 18:40:29", "2025-06-19 18:40:29", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750358429;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750358429;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-19 18:42:15", "2025-06-19 18:42:15", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8235", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-19 18:47:10", "2025-06-19 18:47:10", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750358830;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750358830;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-19 18:48:36", "2025-06-19 18:48:36", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8236", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-19 18:47:15", "2025-06-19 18:47:15", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750358835;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750358835;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-19 18:48:41", "2025-06-19 18:48:41", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8237", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-19 18:53:36", "2025-06-19 18:53:36", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750359216;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750359216;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-19 18:59:38", "2025-06-19 18:59:38", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8238", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-19 18:53:41", "2025-06-19 18:53:41", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750359221;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750359221;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-19 18:59:44", "2025-06-19 18:59:44", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8239", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-19 19:04:38", "2025-06-19 19:04:38", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750359878;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750359878;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-19 19:10:28", "2025-06-19 19:10:28", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8240", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-19 19:04:44", "2025-06-19 19:04:44", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750359884;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750359884;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-19 19:10:33", "2025-06-19 19:10:33", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8241", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-19 19:15:28", "2025-06-19 19:15:28", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750360528;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750360528;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-19 19:20:03", "2025-06-19 19:20:03", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8242", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-19 19:15:33", "2025-06-19 19:15:33", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750360533;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750360533;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-19 19:20:09", "2025-06-19 19:20:09", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8243", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-19 19:25:03", "2025-06-19 19:25:03", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750361103;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750361103;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-19 19:26:37", "2025-06-19 19:26:37", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8244", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-19 19:25:09", "2025-06-19 19:25:09", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750361109;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750361109;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-19 19:26:42", "2025-06-19 19:26:42", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8245", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-19 19:31:37", "2025-06-19 19:31:37", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750361497;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750361497;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-19 19:33:44", "2025-06-19 19:33:44", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8246", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-19 19:31:42", "2025-06-19 19:31:42", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750361502;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750361502;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-19 19:33:49", "2025-06-19 19:33:49", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8247", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-19 19:38:44", "2025-06-19 19:38:44", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750361924;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750361924;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-19 19:39:46", "2025-06-19 19:39:46", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8248", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-19 19:38:49", "2025-06-19 19:38:49", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750361929;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750361929;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-19 19:39:52", "2025-06-19 19:39:52", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8249", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-19 19:44:46", "2025-06-19 19:44:46", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750362286;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750362286;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-19 19:46:35", "2025-06-19 19:46:35", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8250", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-19 19:44:52", "2025-06-19 19:44:52", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750362292;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750362292;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-19 19:46:40", "2025-06-19 19:46:40", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8251", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-19 19:51:35", "2025-06-19 19:51:35", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750362695;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750362695;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-19 19:59:48", "2025-06-19 19:59:48", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8252", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-19 19:51:40", "2025-06-19 19:51:40", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750362700;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750362700;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-19 19:59:53", "2025-06-19 19:59:53", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8253", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-19 20:04:48", "2025-06-19 20:04:48", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750363488;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750363488;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-19 20:16:14", "2025-06-19 20:16:14", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8254", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-19 20:04:53", "2025-06-19 20:04:53", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750363493;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750363493;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-19 20:16:19", "2025-06-19 20:16:19", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8255", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-19 20:21:14", "2025-06-19 20:21:14", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750364474;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750364474;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-19 20:26:04", "2025-06-19 20:26:04", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8256", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-19 20:21:19", "2025-06-19 20:21:19", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750364479;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750364479;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-19 20:26:09", "2025-06-19 20:26:09", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8257", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-19 20:31:04", "2025-06-19 20:31:04", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750365064;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750365064;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-19 20:32:34", "2025-06-19 20:32:34", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8258", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-19 20:31:09", "2025-06-19 20:31:09", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750365069;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750365069;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-19 20:32:40", "2025-06-19 20:32:40", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8259", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-19 20:37:34", "2025-06-19 20:37:34", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750365454;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750365454;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-19 20:39:10", "2025-06-19 20:39:10", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8260", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-19 20:37:40", "2025-06-19 20:37:40", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750365460;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750365460;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-19 20:42:42", "2025-06-19 20:42:42", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8261", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-19 20:44:10", "2025-06-19 20:44:10", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750365850;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750365850;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-19 20:45:42", "2025-06-19 20:45:42", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8262", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-19 20:47:42", "2025-06-19 20:47:42", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750366062;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750366062;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-19 20:52:26", "2025-06-19 20:52:26", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8263", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-19 20:50:42", "2025-06-19 20:50:42", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750366242;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750366242;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-19 20:58:57", "2025-06-19 20:58:57", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8264", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-19 20:57:26", "2025-06-19 20:57:26", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750366646;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750366646;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-19 20:59:03", "2025-06-19 20:59:03", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8265", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-19 21:03:57", "2025-06-19 21:03:57", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750367037;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750367037;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-19 21:29:09", "2025-06-19 21:29:09", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8266", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-19 21:04:03", "2025-06-19 21:04:03", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750367043;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750367043;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-19 21:29:15", "2025-06-19 21:29:15", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8267", "woocommerce_cleanup_draft_orders", "complete", "2025-06-20 21:29:03", "2025-06-20 21:29:03", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750454943;s:18:\"\0*\0first_timestamp\";i:1744536626;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750454943;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-06-20 21:38:04", "2025-06-20 21:38:04", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8268", "wpforms_process_forms_locator_scan", "complete", "2025-06-20 21:29:03", "2025-06-20 21:29:03", "10", "{\"tasks_meta_id\":1}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750454943;s:18:\"\0*\0first_timestamp\";i:1744536754;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750454943;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2025-06-20 21:38:04", "2025-06-20 21:38:04", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8269", "wpforms_process_purge_spam", "complete", "2025-06-20 21:29:03", "2025-06-20 21:29:03", "10", "{\"tasks_meta_id\":2}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750454943;s:18:\"\0*\0first_timestamp\";i:1744536754;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750454943;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2025-06-20 21:38:04", "2025-06-20 21:38:04", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8270", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-19 21:34:09", "2025-06-19 21:34:09", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750368849;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750368849;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-19 21:40:08", "2025-06-19 21:40:08", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8271", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-19 21:34:15", "2025-06-19 21:34:15", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750368855;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750368855;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-19 21:40:13", "2025-06-19 21:40:13", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8272", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-19 21:45:08", "2025-06-19 21:45:08", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750369508;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750369508;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-19 21:49:06", "2025-06-19 21:49:06", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8273", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-19 21:45:13", "2025-06-19 21:45:13", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750369513;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750369513;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-19 21:49:11", "2025-06-19 21:49:11", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8274", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-19 21:54:06", "2025-06-19 21:54:06", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750370046;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750370046;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-19 21:55:10", "2025-06-19 21:55:10", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8275", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-19 21:54:11", "2025-06-19 21:54:11", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750370051;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750370051;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-19 21:55:15", "2025-06-19 21:55:15", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8276", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-19 22:00:10", "2025-06-19 22:00:10", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750370410;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750370410;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-19 22:23:35", "2025-06-19 22:23:35", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8277", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-19 22:00:15", "2025-06-19 22:00:15", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750370415;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750370415;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-19 22:23:41", "2025-06-19 22:23:41", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8278", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-19 22:28:35", "2025-06-19 22:28:35", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750372115;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750372115;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-19 22:30:24", "2025-06-19 22:30:24", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8279", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-19 22:28:41", "2025-06-19 22:28:41", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750372121;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750372121;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-19 22:30:29", "2025-06-19 22:30:29", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8280", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-19 22:35:24", "2025-06-19 22:35:24", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750372524;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750372524;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-19 22:37:11", "2025-06-19 22:37:11", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8281", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-19 22:35:29", "2025-06-19 22:35:29", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750372529;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750372529;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-19 22:37:16", "2025-06-19 22:37:16", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8282", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-19 22:42:11", "2025-06-19 22:42:11", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750372931;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750372931;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-19 22:42:17", "2025-06-19 22:42:17", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8283", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-19 22:42:16", "2025-06-19 22:42:16", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750372936;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750372936;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-19 22:42:24", "2025-06-19 22:42:24", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8284", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-19 22:47:17", "2025-06-19 22:47:17", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750373237;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750373237;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-19 22:51:04", "2025-06-19 22:51:04", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8285", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-19 22:47:24", "2025-06-19 22:47:24", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750373244;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750373244;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-19 22:51:10", "2025-06-19 22:51:10", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8286", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-19 22:56:04", "2025-06-19 22:56:04", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750373764;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750373764;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-19 22:57:57", "2025-06-19 22:57:57", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8287", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-19 22:56:10", "2025-06-19 22:56:10", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750373770;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750373770;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-19 22:58:03", "2025-06-19 22:58:03", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8288", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-19 23:02:57", "2025-06-19 23:02:57", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750374177;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750374177;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-19 23:05:01", "2025-06-19 23:05:01", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8289", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-19 23:03:03", "2025-06-19 23:03:03", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750374183;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750374183;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-19 23:05:07", "2025-06-19 23:05:07", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8290", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-19 23:10:01", "2025-06-19 23:10:01", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750374601;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750374601;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-19 23:11:56", "2025-06-19 23:11:56", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8291", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-19 23:10:07", "2025-06-19 23:10:07", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750374607;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750374607;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-19 23:12:01", "2025-06-19 23:12:01", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8292", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-19 23:16:56", "2025-06-19 23:16:56", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750375016;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750375016;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-19 23:18:28", "2025-06-19 23:18:28", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8293", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-19 23:17:01", "2025-06-19 23:17:01", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750375021;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750375021;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-19 23:18:34", "2025-06-19 23:18:34", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8294", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-19 23:23:28", "2025-06-19 23:23:28", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750375408;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750375408;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-19 23:25:48", "2025-06-19 23:25:48", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8295", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-19 23:23:34", "2025-06-19 23:23:34", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750375414;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750375414;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-19 23:25:53", "2025-06-19 23:25:53", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8296", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-19 23:30:48", "2025-06-19 23:30:48", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750375848;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750375848;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-19 23:32:48", "2025-06-19 23:32:48", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8297", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-19 23:30:53", "2025-06-19 23:30:53", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750375853;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750375853;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-19 23:32:55", "2025-06-19 23:32:55", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8298", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-19 23:37:48", "2025-06-19 23:37:48", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750376268;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750376268;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-19 23:39:43", "2025-06-19 23:39:43", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8299", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-19 23:37:55", "2025-06-19 23:37:55", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750376275;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750376275;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-19 23:39:49", "2025-06-19 23:39:49", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8300", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-19 23:44:43", "2025-06-19 23:44:43", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750376683;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750376683;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-19 23:46:44", "2025-06-19 23:46:44", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8301", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-19 23:44:49", "2025-06-19 23:44:49", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750376689;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750376689;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-19 23:46:49", "2025-06-19 23:46:49", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8302", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-19 23:51:44", "2025-06-19 23:51:44", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750377104;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750377104;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-19 23:53:44", "2025-06-19 23:53:44", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8303", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-19 23:51:49", "2025-06-19 23:51:49", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750377109;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750377109;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-19 23:53:49", "2025-06-19 23:53:49", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8304", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-19 23:58:44", "2025-06-19 23:58:44", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750377524;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750377524;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-20 00:00:52", "2025-06-20 00:00:52", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8305", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-19 23:58:49", "2025-06-19 23:58:49", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750377529;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750377529;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-20 00:00:58", "2025-06-20 00:00:58", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8306", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-20 00:05:52", "2025-06-20 00:05:52", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750377952;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750377952;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-20 00:10:54", "2025-06-20 00:10:54", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8307", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-20 00:05:58", "2025-06-20 00:05:58", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750377958;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750377958;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-20 00:11:00", "2025-06-20 00:11:00", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8308", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-20 00:15:54", "2025-06-20 00:15:54", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750378554;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750378554;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-20 00:17:54", "2025-06-20 00:17:54", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8309", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-20 00:16:00", "2025-06-20 00:16:00", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750378560;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750378560;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-20 00:18:00", "2025-06-20 00:18:00", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8310", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-20 00:22:54", "2025-06-20 00:22:54", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750378974;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750378974;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-20 00:29:29", "2025-06-20 00:29:29", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8311", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-20 00:23:00", "2025-06-20 00:23:00", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750378980;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750378980;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-20 00:29:35", "2025-06-20 00:29:35", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8312", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-20 00:34:29", "2025-06-20 00:34:29", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750379669;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750379669;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-20 00:35:11", "2025-06-20 00:35:11", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8313", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-20 00:34:35", "2025-06-20 00:34:35", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750379675;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750379675;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-20 00:35:17", "2025-06-20 00:35:17", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8314", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-20 00:40:11", "2025-06-20 00:40:11", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750380011;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750380011;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-20 00:45:36", "2025-06-20 00:45:36", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8315", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-20 00:40:17", "2025-06-20 00:40:17", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750380017;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750380017;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-20 00:50:35", "2025-06-20 00:50:35", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8316", "image-optimization/cleanup/stuck-operation", "failed", "2025-06-20 00:50:36", "2025-06-20 00:50:36", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750380636;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750380636;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "0", "2025-06-20 00:57:42", "2025-06-20 00:57:42", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8317", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-20 00:55:35", "2025-06-20 00:55:35", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750380935;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750380935;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-20 00:57:47", "2025-06-20 00:57:47", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8318", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-20 01:02:42", "2025-06-20 01:02:42", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750381362;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750381362;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-20 01:10:35", "2025-06-20 01:10:35", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8319", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-20 01:02:47", "2025-06-20 01:02:47", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750381367;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750381367;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-20 01:10:41", "2025-06-20 01:10:41", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8320", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-20 01:15:35", "2025-06-20 01:15:35", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750382135;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750382135;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-20 02:00:36", "2025-06-20 02:00:36", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8321", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-20 01:15:41", "2025-06-20 01:15:41", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750382141;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750382141;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-20 02:00:42", "2025-06-20 02:00:42", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8322", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-20 02:05:36", "2025-06-20 02:05:36", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750385136;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750385136;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-20 02:13:29", "2025-06-20 02:13:29", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8323", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-20 02:05:42", "2025-06-20 02:05:42", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750385142;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750385142;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-20 02:13:34", "2025-06-20 02:13:34", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8324", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-20 02:18:29", "2025-06-20 02:18:29", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750385909;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750385909;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-20 02:46:34", "2025-06-20 02:46:34", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8325", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-20 02:18:34", "2025-06-20 02:18:34", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750385914;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750385914;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-20 02:46:39", "2025-06-20 02:46:39", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8326", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-20 02:51:34", "2025-06-20 02:51:34", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750387894;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750387894;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-20 02:52:26", "2025-06-20 02:52:26", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8327", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-20 02:51:39", "2025-06-20 02:51:39", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750387899;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750387899;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-20 02:52:31", "2025-06-20 02:52:31", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8328", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-20 02:57:26", "2025-06-20 02:57:26", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750388246;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750388246;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-20 02:57:50", "2025-06-20 02:57:50", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8329", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-20 02:57:31", "2025-06-20 02:57:31", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750388251;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750388251;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-20 02:57:55", "2025-06-20 02:57:55", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8330", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-20 03:02:50", "2025-06-20 03:02:50", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750388570;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750388570;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-20 03:08:34", "2025-06-20 03:08:34", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8331", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-20 03:02:55", "2025-06-20 03:02:55", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750388575;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750388575;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-20 03:08:40", "2025-06-20 03:08:40", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8332", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-20 03:13:34", "2025-06-20 03:13:34", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750389214;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750389214;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-20 03:15:12", "2025-06-20 03:15:12", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8333", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-20 03:13:40", "2025-06-20 03:13:40", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750389220;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750389220;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-20 03:15:18", "2025-06-20 03:15:18", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8334", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-20 03:20:12", "2025-06-20 03:20:12", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750389612;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750389612;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-20 03:20:57", "2025-06-20 03:20:57", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8335", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-20 03:20:18", "2025-06-20 03:20:18", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750389618;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750389618;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-20 03:21:02", "2025-06-20 03:21:02", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8336", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-20 03:25:57", "2025-06-20 03:25:57", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750389957;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750389957;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-20 03:26:30", "2025-06-20 03:26:30", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8337", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-20 03:26:02", "2025-06-20 03:26:02", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750389962;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750389962;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-20 03:26:36", "2025-06-20 03:26:36", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8338", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-20 03:31:30", "2025-06-20 03:31:30", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750390290;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750390290;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-20 03:32:16", "2025-06-20 03:32:16", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8339", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-20 03:31:36", "2025-06-20 03:31:36", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750390296;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750390296;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-20 03:32:21", "2025-06-20 03:32:21", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8340", "woocommerce_refresh_order_count_cache", "complete", "2025-06-20 15:32:09", "2025-06-20 15:32:09", "10", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750433529;s:18:\"\0*\0first_timestamp\";i:1750259475;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750433529;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "10", "1", "2025-06-20 15:33:34", "2025-06-20 15:33:34", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8341", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-20 03:37:16", "2025-06-20 03:37:16", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750390636;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750390636;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-20 03:38:04", "2025-06-20 03:38:04", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8342", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-20 03:37:21", "2025-06-20 03:37:21", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750390641;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750390641;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-20 03:38:10", "2025-06-20 03:38:10", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8343", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-20 03:43:04", "2025-06-20 03:43:04", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750390984;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750390984;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-20 03:43:52", "2025-06-20 03:43:52", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8344", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-20 03:43:10", "2025-06-20 03:43:10", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750390990;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750390990;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-20 03:43:57", "2025-06-20 03:43:57", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8345", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-20 03:48:52", "2025-06-20 03:48:52", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750391332;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750391332;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-20 03:49:41", "2025-06-20 03:49:41", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8346", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-20 03:48:57", "2025-06-20 03:48:57", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750391337;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750391337;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-20 03:49:46", "2025-06-20 03:49:46", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8347", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-20 03:54:41", "2025-06-20 03:54:41", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750391681;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750391681;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-20 03:55:27", "2025-06-20 03:55:27", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8348", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-20 03:54:46", "2025-06-20 03:54:46", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750391686;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750391686;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-20 03:55:32", "2025-06-20 03:55:32", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8349", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-20 04:00:27", "2025-06-20 04:00:27", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750392027;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750392027;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-20 04:01:06", "2025-06-20 04:01:06", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8350", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-20 04:00:32", "2025-06-20 04:00:32", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750392032;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750392032;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-20 04:01:12", "2025-06-20 04:01:12", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8351", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-20 04:06:06", "2025-06-20 04:06:06", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750392366;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750392366;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-20 04:06:38", "2025-06-20 04:06:38", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8352", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-20 04:06:12", "2025-06-20 04:06:12", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750392372;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750392372;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-20 04:06:43", "2025-06-20 04:06:43", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8353", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-20 04:11:38", "2025-06-20 04:11:38", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750392698;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750392698;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-20 04:12:03", "2025-06-20 04:12:03", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8354", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-20 04:11:43", "2025-06-20 04:11:43", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750392703;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750392703;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-20 04:12:08", "2025-06-20 04:12:08", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8355", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-20 04:17:03", "2025-06-20 04:17:03", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750393023;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750393023;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-20 04:17:35", "2025-06-20 04:17:35", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8356", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-20 04:17:08", "2025-06-20 04:17:08", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750393028;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750393028;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-20 04:17:40", "2025-06-20 04:17:40", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8357", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-20 04:22:35", "2025-06-20 04:22:35", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750393355;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750393355;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-20 04:22:58", "2025-06-20 04:22:58", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8358", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-20 04:22:40", "2025-06-20 04:22:40", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750393360;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750393360;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-20 04:23:04", "2025-06-20 04:23:04", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8359", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-20 04:27:58", "2025-06-20 04:27:58", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750393678;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750393678;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-20 04:28:18", "2025-06-20 04:28:18", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8360", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-20 04:28:04", "2025-06-20 04:28:04", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750393684;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750393684;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-20 04:28:23", "2025-06-20 04:28:23", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8361", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-20 04:33:18", "2025-06-20 04:33:18", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750393998;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750393998;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-20 04:39:03", "2025-06-20 04:39:03", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8362", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-20 04:33:23", "2025-06-20 04:33:23", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750394003;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750394003;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-20 04:39:09", "2025-06-20 04:39:09", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8363", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-20 04:44:03", "2025-06-20 04:44:03", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750394643;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750394643;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-20 04:44:15", "2025-06-20 04:44:15", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8364", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-20 04:44:09", "2025-06-20 04:44:09", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750394649;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750394649;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-20 04:44:21", "2025-06-20 04:44:21", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8365", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-20 04:49:15", "2025-06-20 04:49:15", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750394955;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750394955;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-20 04:49:28", "2025-06-20 04:49:28", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8366", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-20 04:49:21", "2025-06-20 04:49:21", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750394961;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750394961;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-20 04:49:34", "2025-06-20 04:49:34", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8367", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-20 04:54:28", "2025-06-20 04:54:28", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750395268;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750395268;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-20 04:54:36", "2025-06-20 04:54:36", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8368", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-20 04:54:34", "2025-06-20 04:54:34", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750395274;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750395274;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-20 04:54:42", "2025-06-20 04:54:42", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8369", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-20 04:59:36", "2025-06-20 04:59:36", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750395576;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750395576;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-20 04:59:45", "2025-06-20 04:59:45", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8370", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-20 04:59:42", "2025-06-20 04:59:42", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750395582;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750395582;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-20 04:59:51", "2025-06-20 04:59:51", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8371", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-20 05:04:45", "2025-06-20 05:04:45", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750395885;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750395885;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-20 05:20:16", "2025-06-20 05:20:16", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8372", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-20 05:04:51", "2025-06-20 05:04:51", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750395891;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750395891;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-20 05:20:22", "2025-06-20 05:20:22", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8373", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-20 05:25:16", "2025-06-20 05:25:16", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750397116;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750397116;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-20 05:25:25", "2025-06-20 05:25:25", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8374", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-20 05:25:22", "2025-06-20 05:25:22", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750397122;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750397122;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-20 05:25:30", "2025-06-20 05:25:30", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8375", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-20 05:30:25", "2025-06-20 05:30:25", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750397425;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750397425;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-20 05:30:33", "2025-06-20 05:30:33", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8376", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-20 05:30:30", "2025-06-20 05:30:30", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750397430;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750397430;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-20 05:30:38", "2025-06-20 05:30:38", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8377", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-20 05:35:33", "2025-06-20 05:35:33", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750397733;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750397733;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-20 05:35:48", "2025-06-20 05:35:48", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8378", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-20 05:35:38", "2025-06-20 05:35:38", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750397738;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750397738;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-20 05:35:53", "2025-06-20 05:35:53", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8379", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-20 05:40:48", "2025-06-20 05:40:48", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750398048;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750398048;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-20 05:40:57", "2025-06-20 05:40:57", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8380", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-20 05:40:53", "2025-06-20 05:40:53", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750398053;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750398053;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-20 05:41:03", "2025-06-20 05:41:03", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8381", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-20 05:45:57", "2025-06-20 05:45:57", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750398357;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750398357;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-20 05:46:05", "2025-06-20 05:46:05", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8382", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-20 05:46:03", "2025-06-20 05:46:03", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750398363;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750398363;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-20 05:46:11", "2025-06-20 05:46:11", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8383", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-20 05:51:05", "2025-06-20 05:51:05", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750398665;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750398665;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-20 05:51:19", "2025-06-20 05:51:19", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8384", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-20 05:51:11", "2025-06-20 05:51:11", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750398671;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750398671;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-20 05:51:24", "2025-06-20 05:51:24", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8385", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-20 05:56:19", "2025-06-20 05:56:19", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750398979;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750398979;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-20 05:56:33", "2025-06-20 05:56:33", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8386", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-20 05:56:24", "2025-06-20 05:56:24", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750398984;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750398984;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-20 05:56:38", "2025-06-20 05:56:38", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8387", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-20 06:01:33", "2025-06-20 06:01:33", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750399293;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750399293;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-20 06:05:37", "2025-06-20 06:05:37", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8388", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-20 06:01:38", "2025-06-20 06:01:38", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750399298;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750399298;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-20 06:05:42", "2025-06-20 06:05:42", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8389", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-20 06:10:37", "2025-06-20 06:10:37", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750399837;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750399837;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-20 06:17:23", "2025-06-20 06:17:23", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8390", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-20 06:10:42", "2025-06-20 06:10:42", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750399842;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750399842;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-20 06:17:28", "2025-06-20 06:17:28", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8391", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-20 06:22:23", "2025-06-20 06:22:23", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750400543;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750400543;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-20 06:22:41", "2025-06-20 06:22:41", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8392", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-20 06:22:28", "2025-06-20 06:22:28", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750400548;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750400548;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-20 06:22:47", "2025-06-20 06:22:47", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8393", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-20 06:27:41", "2025-06-20 06:27:41", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750400861;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750400861;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-20 06:33:16", "2025-06-20 06:33:16", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8394", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-20 06:27:47", "2025-06-20 06:27:47", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750400867;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750400867;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-20 06:33:21", "2025-06-20 06:33:21", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8395", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-20 06:38:16", "2025-06-20 06:38:16", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750401496;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750401496;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-20 06:38:38", "2025-06-20 06:38:38", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8396", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-20 06:38:21", "2025-06-20 06:38:21", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750401501;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750401501;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-20 06:38:44", "2025-06-20 06:38:44", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8397", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-20 06:43:38", "2025-06-20 06:43:38", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750401818;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750401818;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-20 06:43:57", "2025-06-20 06:43:57", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8398", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-20 06:43:44", "2025-06-20 06:43:44", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750401824;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750401824;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-20 06:44:03", "2025-06-20 06:44:03", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8399", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-20 06:48:57", "2025-06-20 06:48:57", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750402137;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750402137;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-20 06:49:19", "2025-06-20 06:49:19", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8400", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-20 06:49:03", "2025-06-20 06:49:03", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750402143;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750402143;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-20 06:49:24", "2025-06-20 06:49:24", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8401", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-20 06:54:19", "2025-06-20 06:54:19", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750402459;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750402459;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-20 06:54:41", "2025-06-20 06:54:41", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8402", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-20 06:54:24", "2025-06-20 06:54:24", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750402464;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750402464;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-20 06:54:47", "2025-06-20 06:54:47", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8403", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-20 06:59:41", "2025-06-20 06:59:41", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750402781;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750402781;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-20 07:00:00", "2025-06-20 07:00:00", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8404", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-20 06:59:47", "2025-06-20 06:59:47", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750402787;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750402787;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-20 07:00:06", "2025-06-20 07:00:06", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8405", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-20 07:05:00", "2025-06-20 07:05:00", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750403100;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750403100;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-20 07:06:24", "2025-06-20 07:06:24", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8406", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-20 07:05:06", "2025-06-20 07:05:06", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750403106;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750403106;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-20 07:06:29", "2025-06-20 07:06:29", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8407", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-20 07:11:24", "2025-06-20 07:11:24", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750403484;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750403484;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-20 07:17:00", "2025-06-20 07:17:00", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8408", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-20 07:11:29", "2025-06-20 07:11:29", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750403489;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750403489;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-20 07:17:06", "2025-06-20 07:17:06", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8409", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-20 07:22:00", "2025-06-20 07:22:00", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750404120;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750404120;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-20 07:25:26", "2025-06-20 07:25:26", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8410", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-20 07:22:06", "2025-06-20 07:22:06", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750404126;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750404126;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-20 07:25:31", "2025-06-20 07:25:31", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8411", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-20 07:30:26", "2025-06-20 07:30:26", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750404626;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750404626;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-20 07:31:52", "2025-06-20 07:31:52", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8412", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-20 07:30:31", "2025-06-20 07:30:31", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750404631;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750404631;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-20 07:31:57", "2025-06-20 07:31:57", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8413", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-20 07:36:52", "2025-06-20 07:36:52", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750405012;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750405012;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-20 07:37:11", "2025-06-20 07:37:11", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8414", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-20 07:36:57", "2025-06-20 07:36:57", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750405017;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750405017;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-20 07:37:17", "2025-06-20 07:37:17", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8415", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-20 07:42:11", "2025-06-20 07:42:11", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750405331;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750405331;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-20 07:42:39", "2025-06-20 07:42:39", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8416", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-20 07:42:17", "2025-06-20 07:42:17", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750405337;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750405337;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-20 07:42:45", "2025-06-20 07:42:45", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8417", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-20 07:47:39", "2025-06-20 07:47:39", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750405659;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750405659;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-20 07:48:02", "2025-06-20 07:48:02", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8418", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-20 07:47:45", "2025-06-20 07:47:45", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750405665;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750405665;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-20 07:48:07", "2025-06-20 07:48:07", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8419", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-20 07:53:02", "2025-06-20 07:53:02", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750405982;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750405982;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-20 07:53:29", "2025-06-20 07:53:29", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8420", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-20 07:53:07", "2025-06-20 07:53:07", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750405987;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750405987;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-20 07:53:35", "2025-06-20 07:53:35", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8421", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-20 07:58:29", "2025-06-20 07:58:29", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750406309;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750406309;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-20 07:58:46", "2025-06-20 07:58:46", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8422", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-20 07:58:35", "2025-06-20 07:58:35", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750406315;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750406315;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-20 07:58:51", "2025-06-20 07:58:51", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8423", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-20 08:03:46", "2025-06-20 08:03:46", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750406626;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750406626;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-20 08:04:13", "2025-06-20 08:04:13", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8424", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-20 08:03:51", "2025-06-20 08:03:51", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750406631;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750406631;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-20 08:04:19", "2025-06-20 08:04:19", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8425", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-20 08:09:13", "2025-06-20 08:09:13", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750406953;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750406953;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-20 08:09:32", "2025-06-20 08:09:32", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8426", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-20 08:09:19", "2025-06-20 08:09:19", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750406959;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750406959;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-20 08:09:38", "2025-06-20 08:09:38", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8427", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-20 08:14:32", "2025-06-20 08:14:32", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750407272;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750407272;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-20 08:18:53", "2025-06-20 08:18:53", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8428", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-20 08:14:38", "2025-06-20 08:14:38", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750407278;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750407278;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-20 08:20:11", "2025-06-20 08:20:11", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8429", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-20 08:23:53", "2025-06-20 08:23:53", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750407833;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750407833;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-20 08:25:36", "2025-06-20 08:25:36", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8430", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-20 08:25:11", "2025-06-20 08:25:11", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750407911;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750407911;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-20 08:25:41", "2025-06-20 08:25:41", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8431", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-20 08:30:36", "2025-06-20 08:30:36", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750408236;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750408236;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-20 08:31:02", "2025-06-20 08:31:02", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8432", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-20 08:30:41", "2025-06-20 08:30:41", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750408241;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750408241;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-20 08:31:08", "2025-06-20 08:31:08", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8433", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-20 08:36:02", "2025-06-20 08:36:02", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750408562;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750408562;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-20 08:36:28", "2025-06-20 08:36:28", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8434", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-20 08:36:08", "2025-06-20 08:36:08", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750408568;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750408568;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-20 08:36:33", "2025-06-20 08:36:33", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8435", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-20 08:41:28", "2025-06-20 08:41:28", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750408888;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750408888;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-20 08:41:53", "2025-06-20 08:41:53", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8436", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-20 08:41:33", "2025-06-20 08:41:33", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750408893;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750408893;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-20 08:41:59", "2025-06-20 08:41:59", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8437", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-20 08:46:53", "2025-06-20 08:46:53", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750409213;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750409213;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-20 08:47:26", "2025-06-20 08:47:26", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8438", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-20 08:46:59", "2025-06-20 08:46:59", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750409219;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750409219;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-20 08:47:31", "2025-06-20 08:47:31", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8439", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-20 08:52:26", "2025-06-20 08:52:26", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750409546;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750409546;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-20 08:52:55", "2025-06-20 08:52:55", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8440", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-20 08:52:31", "2025-06-20 08:52:31", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750409551;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750409551;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-20 08:53:01", "2025-06-20 08:53:01", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8441", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-20 08:57:55", "2025-06-20 08:57:55", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750409875;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750409875;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-20 08:58:22", "2025-06-20 08:58:22", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8442", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-20 08:58:01", "2025-06-20 08:58:01", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750409881;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750409881;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-20 08:58:27", "2025-06-20 08:58:27", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8443", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-20 09:03:22", "2025-06-20 09:03:22", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750410202;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750410202;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-20 09:07:15", "2025-06-20 09:07:15", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8444", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-20 09:03:27", "2025-06-20 09:03:27", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750410207;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750410207;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-20 09:07:21", "2025-06-20 09:07:21", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8445", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-20 09:12:15", "2025-06-20 09:12:15", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750410735;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750410735;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-20 09:13:48", "2025-06-20 09:13:48", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8446", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-20 09:12:21", "2025-06-20 09:12:21", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750410741;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750410741;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-20 09:13:54", "2025-06-20 09:13:54", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8447", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-20 09:18:48", "2025-06-20 09:18:48", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750411128;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750411128;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-20 09:23:54", "2025-06-20 09:23:54", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8448", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-20 09:18:54", "2025-06-20 09:18:54", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750411134;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750411134;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-20 09:23:59", "2025-06-20 09:23:59", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8449", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-20 09:28:54", "2025-06-20 09:28:54", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750411734;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750411734;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-20 09:29:39", "2025-06-20 09:29:39", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8450", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-20 09:28:59", "2025-06-20 09:28:59", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750411739;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750411739;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-20 09:29:45", "2025-06-20 09:29:45", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8451", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-20 09:34:39", "2025-06-20 09:34:39", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750412079;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750412079;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-20 09:39:01", "2025-06-20 09:39:01", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8452", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-20 09:34:45", "2025-06-20 09:34:45", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750412085;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750412085;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-20 09:39:07", "2025-06-20 09:39:07", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8453", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-20 09:44:01", "2025-06-20 09:44:01", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750412641;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750412641;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-20 09:44:11", "2025-06-20 09:44:11", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8454", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-20 09:44:07", "2025-06-20 09:44:07", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750412647;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750412647;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-20 09:44:16", "2025-06-20 09:44:16", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8455", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-20 09:49:11", "2025-06-20 09:49:11", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750412951;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750412951;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-20 09:54:19", "2025-06-20 09:54:19", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8456", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-20 09:49:16", "2025-06-20 09:49:16", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750412956;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750412956;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-20 09:54:25", "2025-06-20 09:54:25", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8457", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-20 09:59:19", "2025-06-20 09:59:19", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750413559;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750413559;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-20 10:09:43", "2025-06-20 10:09:43", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8458", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-20 09:59:25", "2025-06-20 09:59:25", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750413565;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750413565;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-20 10:09:48", "2025-06-20 10:09:48", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8459", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-20 10:14:43", "2025-06-20 10:14:43", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750414483;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750414483;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-20 10:19:52", "2025-06-20 10:19:52", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8460", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-20 10:14:48", "2025-06-20 10:14:48", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750414488;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750414488;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-20 10:19:58", "2025-06-20 10:19:58", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8461", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-20 10:24:52", "2025-06-20 10:24:52", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750415092;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750415092;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-20 10:25:07", "2025-06-20 10:25:07", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8462", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-20 10:24:58", "2025-06-20 10:24:58", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750415098;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750415098;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-20 10:25:13", "2025-06-20 10:25:13", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8463", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-20 10:30:07", "2025-06-20 10:30:07", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750415407;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750415407;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-20 10:30:16", "2025-06-20 10:30:16", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8464", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-20 10:30:13", "2025-06-20 10:30:13", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750415413;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750415413;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-20 10:30:22", "2025-06-20 10:30:22", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8465", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-20 10:35:16", "2025-06-20 10:35:16", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750415716;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750415716;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-20 10:35:27", "2025-06-20 10:35:27", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8466", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-20 10:35:22", "2025-06-20 10:35:22", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750415722;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750415722;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-20 10:35:32", "2025-06-20 10:35:32", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8467", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-20 10:40:27", "2025-06-20 10:40:27", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750416027;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750416027;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-20 10:40:49", "2025-06-20 10:40:49", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8468", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-20 10:40:32", "2025-06-20 10:40:32", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750416032;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750416032;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-20 10:40:54", "2025-06-20 10:40:54", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8469", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-20 10:45:49", "2025-06-20 10:45:49", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750416349;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750416349;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-20 10:46:10", "2025-06-20 10:46:10", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8470", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-20 10:45:54", "2025-06-20 10:45:54", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750416354;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750416354;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-20 10:46:15", "2025-06-20 10:46:15", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8471", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-20 10:51:10", "2025-06-20 10:51:10", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750416670;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750416670;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-20 10:51:28", "2025-06-20 10:51:28", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8472", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-20 10:51:15", "2025-06-20 10:51:15", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750416675;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750416675;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-20 10:51:34", "2025-06-20 10:51:34", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8473", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-20 10:56:28", "2025-06-20 10:56:28", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750416988;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750416988;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-20 10:56:45", "2025-06-20 10:56:45", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8474", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-20 10:56:34", "2025-06-20 10:56:34", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750416994;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750416994;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-20 10:56:51", "2025-06-20 10:56:51", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8475", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-20 11:01:45", "2025-06-20 11:01:45", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750417305;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750417305;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-20 11:17:43", "2025-06-20 11:17:43", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8476", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-20 11:01:51", "2025-06-20 11:01:51", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750417311;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750417311;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-20 11:17:48", "2025-06-20 11:17:48", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8477", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-20 11:22:43", "2025-06-20 11:22:43", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750418563;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750418563;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-20 11:22:55", "2025-06-20 11:22:55", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8478", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-20 11:22:48", "2025-06-20 11:22:48", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750418568;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750418568;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-20 11:23:02", "2025-06-20 11:23:02", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8479", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-20 11:27:55", "2025-06-20 11:27:55", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750418875;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750418875;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-20 11:28:12", "2025-06-20 11:28:12", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8480", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-20 11:28:02", "2025-06-20 11:28:02", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750418882;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750418882;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-20 11:28:17", "2025-06-20 11:28:17", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8481", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-20 11:33:12", "2025-06-20 11:33:12", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750419192;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750419192;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-20 11:38:28", "2025-06-20 11:38:28", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8482", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-20 11:33:17", "2025-06-20 11:33:17", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750419197;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750419197;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-20 11:38:34", "2025-06-20 11:38:34", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8483", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-20 11:43:28", "2025-06-20 11:43:28", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750419808;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750419808;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-20 11:43:42", "2025-06-20 11:43:42", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8484", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-20 11:43:34", "2025-06-20 11:43:34", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750419814;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750419814;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-20 11:43:48", "2025-06-20 11:43:48", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8485", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-20 11:48:42", "2025-06-20 11:48:42", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750420122;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750420122;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-20 11:48:59", "2025-06-20 11:48:59", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8486", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-20 11:48:48", "2025-06-20 11:48:48", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750420128;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750420128;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-20 11:49:05", "2025-06-20 11:49:05", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8487", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-20 11:53:59", "2025-06-20 11:53:59", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750420439;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750420439;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-20 11:54:14", "2025-06-20 11:54:14", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8488", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-20 11:54:05", "2025-06-20 11:54:05", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750420445;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750420445;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-20 11:54:20", "2025-06-20 11:54:20", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8489", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-20 11:59:14", "2025-06-20 11:59:14", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750420754;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750420754;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-20 11:59:28", "2025-06-20 11:59:28", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8490", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-20 11:59:20", "2025-06-20 11:59:20", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750420760;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750420760;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-20 11:59:34", "2025-06-20 11:59:34", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8491", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-20 12:04:28", "2025-06-20 12:04:28", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750421068;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750421068;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-20 12:20:45", "2025-06-20 12:20:45", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8492", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-20 12:04:34", "2025-06-20 12:04:34", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750421074;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750421074;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-20 12:20:50", "2025-06-20 12:20:50", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8493", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-20 12:25:45", "2025-06-20 12:25:45", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750422345;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750422345;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-20 12:26:05", "2025-06-20 12:26:05", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8494", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-20 12:25:50", "2025-06-20 12:25:50", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750422350;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750422350;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-20 12:26:11", "2025-06-20 12:26:11", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8495", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-20 12:31:05", "2025-06-20 12:31:05", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750422665;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750422665;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-20 12:31:27", "2025-06-20 12:31:27", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8496", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-20 12:31:11", "2025-06-20 12:31:11", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750422671;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750422671;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-20 12:31:33", "2025-06-20 12:31:33", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8497", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-20 12:36:27", "2025-06-20 12:36:27", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750422987;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750422987;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-20 12:36:48", "2025-06-20 12:36:48", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8498", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-20 12:36:33", "2025-06-20 12:36:33", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750422993;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750422993;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-20 12:36:54", "2025-06-20 12:36:54", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8499", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-20 12:41:48", "2025-06-20 12:41:48", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750423308;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750423308;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-20 12:42:11", "2025-06-20 12:42:11", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8500", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-20 12:41:54", "2025-06-20 12:41:54", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750423314;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750423314;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-20 12:42:16", "2025-06-20 12:42:16", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8501", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-20 12:47:11", "2025-06-20 12:47:11", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750423631;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750423631;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-20 12:47:33", "2025-06-20 12:47:33", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8502", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-20 12:47:16", "2025-06-20 12:47:16", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750423636;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750423636;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-20 12:47:39", "2025-06-20 12:47:39", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8503", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-20 12:52:33", "2025-06-20 12:52:33", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750423953;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750423953;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-20 12:52:52", "2025-06-20 12:52:52", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8504", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-20 12:52:39", "2025-06-20 12:52:39", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750423959;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750423959;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-20 12:52:58", "2025-06-20 12:52:58", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8505", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-20 12:57:52", "2025-06-20 12:57:52", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750424272;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750424272;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-20 12:58:11", "2025-06-20 12:58:11", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8506", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-20 12:57:58", "2025-06-20 12:57:58", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750424278;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750424278;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-20 12:58:17", "2025-06-20 12:58:17", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8507", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-20 13:03:11", "2025-06-20 13:03:11", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750424591;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750424591;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-20 13:03:33", "2025-06-20 13:03:33", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8508", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-20 13:03:17", "2025-06-20 13:03:17", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750424597;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750424597;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-20 13:03:38", "2025-06-20 13:03:38", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8509", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-20 13:08:33", "2025-06-20 13:08:33", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750424913;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750424913;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-20 13:08:52", "2025-06-20 13:08:52", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8510", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-20 13:08:38", "2025-06-20 13:08:38", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750424918;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750424918;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-20 13:08:57", "2025-06-20 13:08:57", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8511", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-20 13:13:52", "2025-06-20 13:13:52", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750425232;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750425232;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-20 13:14:12", "2025-06-20 13:14:12", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8512", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-20 13:13:57", "2025-06-20 13:13:57", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750425237;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750425237;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-20 13:14:18", "2025-06-20 13:14:18", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8513", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-20 13:19:12", "2025-06-20 13:19:12", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750425552;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750425552;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-20 13:19:33", "2025-06-20 13:19:33", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8514", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-20 13:19:18", "2025-06-20 13:19:18", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750425558;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750425558;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-20 13:19:38", "2025-06-20 13:19:38", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8515", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-20 13:24:33", "2025-06-20 13:24:33", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750425873;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750425873;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-20 13:24:54", "2025-06-20 13:24:54", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8516", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-20 13:24:38", "2025-06-20 13:24:38", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750425878;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750425878;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-20 13:24:59", "2025-06-20 13:24:59", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8517", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-20 13:29:54", "2025-06-20 13:29:54", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750426194;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750426194;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-20 13:30:15", "2025-06-20 13:30:15", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8518", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-20 13:29:59", "2025-06-20 13:29:59", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750426199;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750426199;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-20 13:30:20", "2025-06-20 13:30:20", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8519", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-20 13:35:15", "2025-06-20 13:35:15", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750426515;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750426515;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-20 13:35:31", "2025-06-20 13:35:31", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8520", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-20 13:35:20", "2025-06-20 13:35:20", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750426520;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750426520;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-20 13:35:36", "2025-06-20 13:35:36", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8521", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-20 13:40:31", "2025-06-20 13:40:31", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750426831;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750426831;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-20 13:40:47", "2025-06-20 13:40:47", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8522", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-20 13:40:36", "2025-06-20 13:40:36", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750426836;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750426836;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-20 13:40:53", "2025-06-20 13:40:53", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8523", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-20 13:45:47", "2025-06-20 13:45:47", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750427147;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750427147;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-20 13:46:07", "2025-06-20 13:46:07", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8524", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-20 13:45:53", "2025-06-20 13:45:53", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750427153;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750427153;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-20 13:46:13", "2025-06-20 13:46:13", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8525", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-20 13:51:07", "2025-06-20 13:51:07", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750427467;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750427467;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-20 13:51:26", "2025-06-20 13:51:26", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8526", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-20 13:51:13", "2025-06-20 13:51:13", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750427473;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750427473;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-20 13:51:32", "2025-06-20 13:51:32", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8527", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-20 13:56:26", "2025-06-20 13:56:26", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750427786;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750427786;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-20 13:56:43", "2025-06-20 13:56:43", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8528", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-20 13:56:32", "2025-06-20 13:56:32", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750427792;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750427792;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-20 13:56:49", "2025-06-20 13:56:49", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8529", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-20 14:01:43", "2025-06-20 14:01:43", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750428103;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750428103;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-20 14:23:34", "2025-06-20 14:23:34", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8530", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-20 14:01:49", "2025-06-20 14:01:49", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750428109;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750428109;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-20 14:23:40", "2025-06-20 14:23:40", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8531", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-20 14:28:34", "2025-06-20 14:28:34", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750429714;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750429714;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-20 14:28:54", "2025-06-20 14:28:54", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8532", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-20 14:28:40", "2025-06-20 14:28:40", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750429720;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750429720;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-20 14:28:59", "2025-06-20 14:28:59", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8533", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-20 14:33:54", "2025-06-20 14:33:54", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750430034;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750430034;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-20 14:34:24", "2025-06-20 14:34:24", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8534", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-20 14:33:59", "2025-06-20 14:33:59", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750430039;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750430039;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-20 14:34:29", "2025-06-20 14:34:29", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8535", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-20 14:39:24", "2025-06-20 14:39:24", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750430364;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750430364;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-20 14:39:44", "2025-06-20 14:39:44", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8536", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-20 14:39:29", "2025-06-20 14:39:29", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750430369;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750430369;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-20 14:39:50", "2025-06-20 14:39:50", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8537", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-20 14:44:44", "2025-06-20 14:44:44", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750430684;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750430684;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-20 14:45:09", "2025-06-20 14:45:09", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8538", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-20 14:44:50", "2025-06-20 14:44:50", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750430690;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750430690;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-20 14:45:15", "2025-06-20 14:45:15", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8539", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-20 14:50:09", "2025-06-20 14:50:09", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750431009;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750431009;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-20 14:50:34", "2025-06-20 14:50:34", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8540", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-20 14:50:15", "2025-06-20 14:50:15", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750431015;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750431015;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-20 14:50:40", "2025-06-20 14:50:40", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8541", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-20 14:55:34", "2025-06-20 14:55:34", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750431334;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750431334;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-20 14:56:00", "2025-06-20 14:56:00", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8542", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-20 14:55:40", "2025-06-20 14:55:40", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750431340;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750431340;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-20 14:56:06", "2025-06-20 14:56:06", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8543", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-20 15:01:00", "2025-06-20 15:01:00", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750431660;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750431660;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-20 15:02:26", "2025-06-20 15:02:26", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8544", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-20 15:01:06", "2025-06-20 15:01:06", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750431666;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750431666;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-20 15:02:32", "2025-06-20 15:02:32", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8545", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-20 15:07:26", "2025-06-20 15:07:26", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750432046;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750432046;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-20 15:12:12", "2025-06-20 15:12:12", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8546", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-20 15:07:32", "2025-06-20 15:07:32", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750432052;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750432052;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-20 15:12:18", "2025-06-20 15:12:18", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8547", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-20 15:17:12", "2025-06-20 15:17:12", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750432632;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750432632;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-20 15:17:39", "2025-06-20 15:17:39", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8548", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-20 15:17:18", "2025-06-20 15:17:18", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750432638;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750432638;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-20 15:17:45", "2025-06-20 15:17:45", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8549", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-20 15:22:39", "2025-06-20 15:22:39", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750432959;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750432959;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-20 15:23:07", "2025-06-20 15:23:07", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8550", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-20 15:22:45", "2025-06-20 15:22:45", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750432965;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750432965;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-20 15:23:13", "2025-06-20 15:23:13", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8551", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-20 15:28:07", "2025-06-20 15:28:07", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750433287;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750433287;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-20 15:28:20", "2025-06-20 15:28:20", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8552", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-20 15:28:13", "2025-06-20 15:28:13", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750433293;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750433293;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-20 15:28:26", "2025-06-20 15:28:26", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8553", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-20 15:33:20", "2025-06-20 15:33:20", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750433600;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750433600;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-20 15:33:40", "2025-06-20 15:33:40", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8554", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-20 15:33:26", "2025-06-20 15:33:26", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750433606;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750433606;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-20 15:33:46", "2025-06-20 15:33:46", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8555", "woocommerce_refresh_order_count_cache", "complete", "2025-06-21 03:33:34", "2025-06-21 03:33:34", "10", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750476814;s:18:\"\0*\0first_timestamp\";i:1750259475;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750476814;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "10", "1", "2025-06-21 03:33:35", "2025-06-21 03:33:35", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8556", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-20 15:38:40", "2025-06-20 15:38:40", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750433920;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750433920;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-20 15:39:01", "2025-06-20 15:39:01", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8557", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-20 15:38:46", "2025-06-20 15:38:46", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750433926;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750433926;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-20 15:39:08", "2025-06-20 15:39:08", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8558", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-20 15:44:01", "2025-06-20 15:44:01", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750434241;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750434241;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-20 15:44:24", "2025-06-20 15:44:24", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8559", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-20 15:44:08", "2025-06-20 15:44:08", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750434248;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750434248;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-20 15:44:29", "2025-06-20 15:44:29", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8560", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-20 15:49:24", "2025-06-20 15:49:24", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750434564;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750434564;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-20 15:49:44", "2025-06-20 15:49:44", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8561", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-20 15:49:29", "2025-06-20 15:49:29", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750434569;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750434569;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-20 15:49:49", "2025-06-20 15:49:49", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8562", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-20 15:54:44", "2025-06-20 15:54:44", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750434884;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750434884;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-20 15:58:34", "2025-06-20 15:58:34", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8563", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-20 15:54:49", "2025-06-20 15:54:49", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750434889;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750434889;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-20 15:58:40", "2025-06-20 15:58:40", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8564", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-20 16:03:34", "2025-06-20 16:03:34", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750435414;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750435414;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-20 16:07:08", "2025-06-20 16:07:08", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8565", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-20 16:03:40", "2025-06-20 16:03:40", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750435420;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750435420;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-20 16:10:42", "2025-06-20 16:10:42", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8566", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-20 16:12:08", "2025-06-20 16:12:08", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750435928;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750435928;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-20 16:16:00", "2025-06-20 16:16:00", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8567", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-20 16:15:42", "2025-06-20 16:15:42", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750436142;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750436142;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-20 16:16:06", "2025-06-20 16:16:06", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8568", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-20 16:21:00", "2025-06-20 16:21:00", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750436460;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750436460;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-20 16:26:05", "2025-06-20 16:26:05", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8569", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-20 16:21:06", "2025-06-20 16:21:06", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750436466;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750436466;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-20 16:26:11", "2025-06-20 16:26:11", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8570", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-20 16:31:05", "2025-06-20 16:31:05", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750437065;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750437065;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-20 16:36:12", "2025-06-20 16:36:12", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8571", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-20 16:31:11", "2025-06-20 16:31:11", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750437071;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750437071;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-20 16:36:18", "2025-06-20 16:36:18", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8572", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-20 16:41:12", "2025-06-20 16:41:12", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750437672;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750437672;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-20 16:46:06", "2025-06-20 16:46:06", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8573", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-20 16:41:18", "2025-06-20 16:41:18", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750437678;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750437678;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-20 16:46:11", "2025-06-20 16:46:11", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8574", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-20 16:51:06", "2025-06-20 16:51:06", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750438266;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750438266;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-20 16:52:35", "2025-06-20 16:52:35", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8575", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-20 16:51:11", "2025-06-20 16:51:11", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750438271;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750438271;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-20 16:52:41", "2025-06-20 16:52:41", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8576", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-20 16:57:35", "2025-06-20 16:57:35", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750438655;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750438655;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-20 17:00:26", "2025-06-20 17:00:26", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8577", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-20 16:57:41", "2025-06-20 16:57:41", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750438661;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750438661;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-20 17:00:32", "2025-06-20 17:00:32", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8578", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-20 17:05:26", "2025-06-20 17:05:26", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750439126;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750439126;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-20 17:14:39", "2025-06-20 17:14:39", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8579", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-20 17:05:32", "2025-06-20 17:05:32", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750439132;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750439132;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-20 17:14:45", "2025-06-20 17:14:45", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8580", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-20 17:19:39", "2025-06-20 17:19:39", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750439979;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750439979;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-20 17:19:45", "2025-06-20 17:19:45", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8581", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-20 17:19:45", "2025-06-20 17:19:45", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750439985;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750439985;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-20 17:19:51", "2025-06-20 17:19:51", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8582", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-20 17:24:45", "2025-06-20 17:24:45", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750440285;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750440285;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-20 17:29:20", "2025-06-20 17:29:20", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8583", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-20 17:24:51", "2025-06-20 17:24:51", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750440291;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750440291;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-20 17:29:26", "2025-06-20 17:29:26", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8584", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-20 17:34:20", "2025-06-20 17:34:20", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750440860;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750440860;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-20 17:38:54", "2025-06-20 17:38:54", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8585", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-20 17:34:26", "2025-06-20 17:34:26", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750440866;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750440866;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-20 17:39:00", "2025-06-20 17:39:00", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8586", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-20 17:43:54", "2025-06-20 17:43:54", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750441434;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750441434;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-20 17:48:30", "2025-06-20 17:48:30", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8587", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-20 17:44:00", "2025-06-20 17:44:00", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750441440;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750441440;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-20 17:48:36", "2025-06-20 17:48:36", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8588", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-20 17:53:30", "2025-06-20 17:53:30", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750442010;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750442010;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-20 17:56:01", "2025-06-20 17:56:01", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8589", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-20 17:53:36", "2025-06-20 17:53:36", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750442016;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750442016;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-20 17:58:10", "2025-06-20 17:58:10", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8590", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-20 18:01:01", "2025-06-20 18:01:01", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750442461;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750442461;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-20 18:07:43", "2025-06-20 18:07:43", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8591", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-20 18:03:10", "2025-06-20 18:03:10", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750442590;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750442590;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-20 18:07:48", "2025-06-20 18:07:48", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8592", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-20 18:12:43", "2025-06-20 18:12:43", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750443163;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750443163;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-20 18:17:09", "2025-06-20 18:17:09", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8593", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-20 18:12:48", "2025-06-20 18:12:48", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750443168;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750443168;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-20 18:17:14", "2025-06-20 18:17:14", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8594", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-20 18:22:09", "2025-06-20 18:22:09", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750443729;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750443729;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-20 18:22:15", "2025-06-20 18:22:15", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8595", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-20 18:22:14", "2025-06-20 18:22:14", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750443734;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750443734;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-20 18:22:20", "2025-06-20 18:22:20", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8596", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-20 18:27:15", "2025-06-20 18:27:15", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750444035;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750444035;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-20 18:31:31", "2025-06-20 18:31:31", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8597", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-20 18:27:20", "2025-06-20 18:27:20", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750444040;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750444040;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-20 18:31:37", "2025-06-20 18:31:37", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8598", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-20 18:36:31", "2025-06-20 18:36:31", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750444591;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750444591;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-20 18:37:58", "2025-06-20 18:37:58", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8599", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-20 18:36:37", "2025-06-20 18:36:37", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750444597;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750444597;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-20 18:38:03", "2025-06-20 18:38:03", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8600", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-20 18:42:58", "2025-06-20 18:42:58", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750444978;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750444978;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-20 18:45:38", "2025-06-20 18:45:38", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8601", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-20 18:43:03", "2025-06-20 18:43:03", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750444983;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750444983;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-20 18:45:44", "2025-06-20 18:45:44", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8602", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-20 18:50:38", "2025-06-20 18:50:38", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750445438;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750445438;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-20 18:55:04", "2025-06-20 18:55:04", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8603", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-20 18:50:44", "2025-06-20 18:50:44", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750445444;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750445444;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-20 18:55:10", "2025-06-20 18:55:10", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8604", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-20 19:00:04", "2025-06-20 19:00:04", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750446004;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750446004;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-20 19:14:16", "2025-06-20 19:14:16", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8605", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-20 19:00:10", "2025-06-20 19:00:10", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750446010;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750446010;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-20 19:14:22", "2025-06-20 19:14:22", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8606", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-20 19:19:16", "2025-06-20 19:19:16", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750447156;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750447156;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-20 19:22:36", "2025-06-20 19:22:36", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8607", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-20 19:19:22", "2025-06-20 19:19:22", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750447162;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750447162;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-20 19:22:42", "2025-06-20 19:22:42", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8608", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-20 19:27:36", "2025-06-20 19:27:36", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750447656;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750447656;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-20 19:27:56", "2025-06-20 19:27:56", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8609", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-20 19:27:42", "2025-06-20 19:27:42", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750447662;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750447662;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-20 19:28:02", "2025-06-20 19:28:02", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8610", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-20 19:32:56", "2025-06-20 19:32:56", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750447976;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750447976;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-20 19:37:10", "2025-06-20 19:37:10", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8611", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-20 19:33:02", "2025-06-20 19:33:02", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750447982;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750447982;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-20 19:37:15", "2025-06-20 19:37:15", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8612", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-20 19:42:10", "2025-06-20 19:42:10", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750448530;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750448530;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-20 19:46:32", "2025-06-20 19:46:32", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8613", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-20 19:42:15", "2025-06-20 19:42:15", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750448535;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750448535;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-20 19:46:37", "2025-06-20 19:46:37", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8614", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-20 19:51:32", "2025-06-20 19:51:32", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750449092;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750449092;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-20 19:55:49", "2025-06-20 19:55:49", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8615", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-20 19:51:37", "2025-06-20 19:51:37", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750449097;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750449097;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-20 19:55:55", "2025-06-20 19:55:55", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8616", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-20 20:00:49", "2025-06-20 20:00:49", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750449649;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750449649;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-20 20:19:38", "2025-06-20 20:19:38", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8617", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-20 20:00:55", "2025-06-20 20:00:55", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750449655;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750449655;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-20 20:19:44", "2025-06-20 20:19:44", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8618", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-20 20:24:38", "2025-06-20 20:24:38", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750451078;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750451078;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-20 20:28:52", "2025-06-20 20:28:52", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8619", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-20 20:24:44", "2025-06-20 20:24:44", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750451084;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750451084;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-20 20:28:58", "2025-06-20 20:28:58", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8620", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-20 20:33:52", "2025-06-20 20:33:52", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750451632;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750451632;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-20 20:38:15", "2025-06-20 20:38:15", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8621", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-20 20:33:58", "2025-06-20 20:33:58", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750451638;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750451638;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-20 20:38:21", "2025-06-20 20:38:21", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8622", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-20 20:43:15", "2025-06-20 20:43:15", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750452195;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750452195;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-20 20:47:29", "2025-06-20 20:47:29", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8623", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-20 20:43:21", "2025-06-20 20:43:21", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750452201;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750452201;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-20 20:47:35", "2025-06-20 20:47:35", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8624", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-20 20:52:29", "2025-06-20 20:52:29", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750452749;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750452749;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-20 20:56:45", "2025-06-20 20:56:45", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8625", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-20 20:52:35", "2025-06-20 20:52:35", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750452755;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750452755;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-20 20:56:51", "2025-06-20 20:56:51", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8626", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-20 21:01:45", "2025-06-20 21:01:45", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750453305;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750453305;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-20 21:02:11", "2025-06-20 21:02:11", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8627", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-20 21:01:51", "2025-06-20 21:01:51", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750453311;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750453311;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-20 21:02:17", "2025-06-20 21:02:17", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8628", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-20 21:07:11", "2025-06-20 21:07:11", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750453631;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750453631;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-20 21:10:31", "2025-06-20 21:10:31", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8629", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-20 21:07:17", "2025-06-20 21:07:17", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750453637;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750453637;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-20 21:10:37", "2025-06-20 21:10:37", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8630", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-20 21:15:31", "2025-06-20 21:15:31", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750454131;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750454131;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-20 21:19:46", "2025-06-20 21:19:46", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8631", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-20 21:15:37", "2025-06-20 21:15:37", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750454137;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750454137;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-20 21:19:52", "2025-06-20 21:19:52", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8632", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-20 21:24:46", "2025-06-20 21:24:46", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750454686;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750454686;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-20 21:33:34", "2025-06-20 21:33:34", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8633", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-20 21:24:52", "2025-06-20 21:24:52", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750454692;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750454692;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-20 21:33:40", "2025-06-20 21:33:40", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8634", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-20 21:38:34", "2025-06-20 21:38:34", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750455514;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750455514;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-20 21:42:48", "2025-06-20 21:42:48", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8635", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-20 21:38:40", "2025-06-20 21:38:40", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750455520;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750455520;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-20 21:42:54", "2025-06-20 21:42:54", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8636", "woocommerce_cleanup_draft_orders", "complete", "2025-06-21 21:38:04", "2025-06-21 21:38:04", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750541884;s:18:\"\0*\0first_timestamp\";i:1744536626;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750541884;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-06-21 21:38:19", "2025-06-21 21:38:19", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8637", "wpforms_process_forms_locator_scan", "complete", "2025-06-21 21:38:04", "2025-06-21 21:38:04", "10", "{\"tasks_meta_id\":1}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750541884;s:18:\"\0*\0first_timestamp\";i:1744536754;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750541884;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2025-06-21 21:38:19", "2025-06-21 21:38:19", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8638", "wpforms_process_purge_spam", "complete", "2025-06-21 21:38:04", "2025-06-21 21:38:04", "10", "{\"tasks_meta_id\":2}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750541884;s:18:\"\0*\0first_timestamp\";i:1744536754;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750541884;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2025-06-21 21:38:19", "2025-06-21 21:38:19", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8639", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-20 21:47:48", "2025-06-20 21:47:48", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750456068;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750456068;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-20 21:52:08", "2025-06-20 21:52:08", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8640", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-20 21:47:54", "2025-06-20 21:47:54", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750456074;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750456074;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-20 21:52:14", "2025-06-20 21:52:14", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8641", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-20 21:57:08", "2025-06-20 21:57:08", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750456628;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750456628;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-20 22:20:23", "2025-06-20 22:20:23", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8642", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-20 21:57:14", "2025-06-20 21:57:14", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750456634;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750456634;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-20 22:20:29", "2025-06-20 22:20:29", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8643", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-20 22:25:23", "2025-06-20 22:25:23", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750458323;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750458323;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-20 22:25:29", "2025-06-20 22:25:29", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8644", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-20 22:25:29", "2025-06-20 22:25:29", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750458329;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750458329;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-20 22:25:34", "2025-06-20 22:25:34", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8645", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-20 22:30:29", "2025-06-20 22:30:29", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750458629;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750458629;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-20 22:34:30", "2025-06-20 22:34:30", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8646", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-20 22:30:34", "2025-06-20 22:30:34", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750458634;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750458634;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-20 22:34:36", "2025-06-20 22:34:36", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8647", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-20 22:39:30", "2025-06-20 22:39:30", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750459170;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750459170;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-20 22:43:59", "2025-06-20 22:43:59", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8648", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-20 22:39:36", "2025-06-20 22:39:36", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750459176;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750459176;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-20 22:44:05", "2025-06-20 22:44:05", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8649", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-20 22:48:59", "2025-06-20 22:48:59", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750459739;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750459739;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-20 22:53:30", "2025-06-20 22:53:30", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8650", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-20 22:49:05", "2025-06-20 22:49:05", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750459745;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750459745;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-20 22:53:35", "2025-06-20 22:53:35", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8651", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-20 22:58:30", "2025-06-20 22:58:30", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750460310;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750460310;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-20 23:11:18", "2025-06-20 23:11:18", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8652", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-20 22:58:35", "2025-06-20 22:58:35", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750460315;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750460315;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-20 23:11:25", "2025-06-20 23:11:25", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8653", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-20 23:16:18", "2025-06-20 23:16:18", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750461378;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750461378;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-20 23:17:21", "2025-06-20 23:17:21", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8654", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-20 23:16:25", "2025-06-20 23:16:25", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750461385;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750461385;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-20 23:17:27", "2025-06-20 23:17:27", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8655", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-20 23:22:21", "2025-06-20 23:22:21", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750461741;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750461741;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-20 23:26:54", "2025-06-20 23:26:54", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8656", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-20 23:22:27", "2025-06-20 23:22:27", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750461747;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750461747;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-20 23:27:01", "2025-06-20 23:27:01", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8657", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-20 23:31:54", "2025-06-20 23:31:54", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750462314;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750462314;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-20 23:36:20", "2025-06-20 23:36:20", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8658", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-20 23:32:01", "2025-06-20 23:32:01", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750462321;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750462321;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-20 23:36:26", "2025-06-20 23:36:26", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8659", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-20 23:41:20", "2025-06-20 23:41:20", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750462880;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750462880;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-20 23:45:57", "2025-06-20 23:45:57", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8660", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-20 23:41:26", "2025-06-20 23:41:26", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750462886;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750462886;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-20 23:46:03", "2025-06-20 23:46:03", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8661", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-20 23:50:57", "2025-06-20 23:50:57", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750463457;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750463457;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-20 23:55:26", "2025-06-20 23:55:26", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8662", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-20 23:51:03", "2025-06-20 23:51:03", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750463463;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750463463;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-20 23:55:31", "2025-06-20 23:55:31", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8663", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-21 00:00:26", "2025-06-21 00:00:26", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750464026;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750464026;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-21 00:10:09", "2025-06-21 00:10:09", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8664", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-21 00:00:31", "2025-06-21 00:00:31", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750464031;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750464031;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-21 00:10:14", "2025-06-21 00:10:14", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8665", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-21 00:15:09", "2025-06-21 00:15:09", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750464909;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750464909;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-21 00:19:51", "2025-06-21 00:19:51", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8666", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-21 00:15:14", "2025-06-21 00:15:14", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750464914;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750464914;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-21 00:19:57", "2025-06-21 00:19:57", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8667", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-21 00:24:51", "2025-06-21 00:24:51", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750465491;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750465491;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-21 00:29:31", "2025-06-21 00:29:31", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8668", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-21 00:24:57", "2025-06-21 00:24:57", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750465497;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750465497;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-21 00:29:37", "2025-06-21 00:29:37", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8669", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-21 00:34:31", "2025-06-21 00:34:31", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750466071;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750466071;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-21 00:39:13", "2025-06-21 00:39:13", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8670", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-21 00:34:37", "2025-06-21 00:34:37", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750466077;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750466077;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-21 00:39:18", "2025-06-21 00:39:18", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8671", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-21 00:44:13", "2025-06-21 00:44:13", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750466653;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750466653;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-21 00:48:54", "2025-06-21 00:48:54", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8672", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-21 00:44:19", "2025-06-21 00:44:19", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750466659;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750466659;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-21 00:49:00", "2025-06-21 00:49:00", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8673", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-21 00:53:54", "2025-06-21 00:53:54", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750467234;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750467234;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-21 00:56:04", "2025-06-21 00:56:04", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8674", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-21 00:54:00", "2025-06-21 00:54:00", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750467240;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750467240;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-21 00:56:09", "2025-06-21 00:56:09", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8675", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-21 01:01:04", "2025-06-21 01:01:04", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750467664;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750467664;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-21 01:18:10", "2025-06-21 01:18:10", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8676", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-21 01:01:09", "2025-06-21 01:01:09", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750467669;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750467669;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-21 01:18:15", "2025-06-21 01:18:15", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8677", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-21 01:23:10", "2025-06-21 01:23:10", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750468990;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750468990;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-21 01:27:40", "2025-06-21 01:27:40", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8678", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-21 01:23:15", "2025-06-21 01:23:15", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750468995;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750468995;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-21 01:27:46", "2025-06-21 01:27:46", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8679", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-21 01:32:40", "2025-06-21 01:32:40", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750469560;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750469560;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-21 01:37:27", "2025-06-21 01:37:27", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8680", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-21 01:32:46", "2025-06-21 01:32:46", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750469566;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750469566;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-21 01:37:33", "2025-06-21 01:37:33", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8681", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-21 01:42:27", "2025-06-21 01:42:27", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750470147;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750470147;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-21 01:47:12", "2025-06-21 01:47:12", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8682", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-21 01:42:33", "2025-06-21 01:42:33", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750470153;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750470153;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-21 01:47:17", "2025-06-21 01:47:17", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8683", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-21 01:52:12", "2025-06-21 01:52:12", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750470732;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750470732;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-21 01:53:14", "2025-06-21 01:53:14", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8684", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-21 01:52:17", "2025-06-21 01:52:17", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750470737;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750470737;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-21 01:53:20", "2025-06-21 01:53:20", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8685", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-21 01:58:14", "2025-06-21 01:58:14", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750471094;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750471094;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-21 02:07:12", "2025-06-21 02:07:12", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8686", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-21 01:58:20", "2025-06-21 01:58:20", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750471100;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750471100;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-21 02:07:17", "2025-06-21 02:07:17", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8687", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-21 02:12:12", "2025-06-21 02:12:12", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750471932;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750471932;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-21 02:17:17", "2025-06-21 02:17:17", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8688", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-21 02:12:17", "2025-06-21 02:12:17", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750471937;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750471937;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-21 02:17:22", "2025-06-21 02:17:22", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8689", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-21 02:22:17", "2025-06-21 02:22:17", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750472537;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750472537;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-21 02:25:15", "2025-06-21 02:25:15", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8690", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-21 02:22:22", "2025-06-21 02:22:22", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750472542;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750472542;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-21 02:25:21", "2025-06-21 02:25:21", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8691", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-21 02:30:15", "2025-06-21 02:30:15", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750473015;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750473015;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-21 02:32:25", "2025-06-21 02:32:25", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8692", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-21 02:30:21", "2025-06-21 02:30:21", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750473021;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750473021;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-21 02:32:30", "2025-06-21 02:32:30", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8693", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-21 02:37:25", "2025-06-21 02:37:25", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750473445;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750473445;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-21 02:41:36", "2025-06-21 02:41:36", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8694", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-21 02:37:30", "2025-06-21 02:37:30", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750473450;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750473450;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-21 02:42:24", "2025-06-21 02:42:24", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8695", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-21 02:46:36", "2025-06-21 02:46:36", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750473996;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750473996;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-21 02:47:27", "2025-06-21 02:47:27", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8696", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-21 02:47:24", "2025-06-21 02:47:24", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750474044;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750474044;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-21 02:47:33", "2025-06-21 02:47:33", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8697", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-21 02:52:27", "2025-06-21 02:52:27", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750474347;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750474347;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-21 02:57:30", "2025-06-21 02:57:30", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8698", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-21 02:52:33", "2025-06-21 02:52:33", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750474353;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750474353;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-21 02:57:36", "2025-06-21 02:57:36", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8699", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-21 03:02:30", "2025-06-21 03:02:30", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750474950;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750474950;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-21 03:03:06", "2025-06-21 03:03:06", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8700", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-21 03:02:36", "2025-06-21 03:02:36", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750474956;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750474956;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-21 03:03:12", "2025-06-21 03:03:12", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8701", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-21 03:08:06", "2025-06-21 03:08:06", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750475286;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750475286;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-21 03:12:43", "2025-06-21 03:12:43", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8702", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-21 03:08:12", "2025-06-21 03:08:12", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750475292;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750475292;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-21 03:12:49", "2025-06-21 03:12:49", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8703", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-21 03:17:43", "2025-06-21 03:17:43", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750475863;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750475863;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-21 03:20:54", "2025-06-21 03:20:54", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8704", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-21 03:17:49", "2025-06-21 03:17:49", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750475869;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750475869;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-21 03:20:59", "2025-06-21 03:20:59", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8705", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-21 03:25:54", "2025-06-21 03:25:54", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750476354;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750476354;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-21 03:26:01", "2025-06-21 03:26:01", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8706", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-21 03:25:59", "2025-06-21 03:25:59", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750476359;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750476359;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-21 03:26:08", "2025-06-21 03:26:08", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8707", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-21 03:31:01", "2025-06-21 03:31:01", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750476661;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750476661;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-21 03:33:29", "2025-06-21 03:33:29", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8708", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-21 03:31:08", "2025-06-21 03:31:08", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750476668;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750476668;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-21 03:33:35", "2025-06-21 03:33:35", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8709", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-21 03:38:29", "2025-06-21 03:38:29", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750477109;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750477109;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-21 03:39:25", "2025-06-21 03:39:25", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8710", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-21 03:38:35", "2025-06-21 03:38:35", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750477115;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750477115;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-21 03:39:31", "2025-06-21 03:39:31", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8711", "woocommerce_refresh_order_count_cache", "complete", "2025-06-21 15:33:35", "2025-06-21 15:33:35", "10", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750520015;s:18:\"\0*\0first_timestamp\";i:1750259475;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750520015;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "10", "1", "2025-06-21 15:35:57", "2025-06-21 15:35:57", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8712", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-21 03:44:25", "2025-06-21 03:44:25", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750477465;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750477465;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-21 03:45:50", "2025-06-21 03:45:50", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8713", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-21 03:44:31", "2025-06-21 03:44:31", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750477471;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750477471;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-21 03:45:56", "2025-06-21 03:45:56", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8714", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-21 03:50:50", "2025-06-21 03:50:50", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750477850;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750477850;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-21 03:51:33", "2025-06-21 03:51:33", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8715", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-21 03:50:56", "2025-06-21 03:50:56", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750477856;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750477856;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-21 03:51:39", "2025-06-21 03:51:39", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8716", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-21 03:56:33", "2025-06-21 03:56:33", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750478193;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750478193;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-21 03:58:46", "2025-06-21 03:58:46", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8717", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-21 03:56:39", "2025-06-21 03:56:39", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750478199;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750478199;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-21 03:58:52", "2025-06-21 03:58:52", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8718", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-21 04:03:46", "2025-06-21 04:03:46", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750478626;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750478626;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-21 04:06:39", "2025-06-21 04:06:39", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8719", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-21 04:03:52", "2025-06-21 04:03:52", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750478632;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750478632;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-21 04:06:46", "2025-06-21 04:06:46", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8720", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-21 04:11:39", "2025-06-21 04:11:39", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750479099;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750479099;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-21 04:14:28", "2025-06-21 04:14:28", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8721", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-21 04:11:46", "2025-06-21 04:11:46", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750479106;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750479106;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-21 04:14:34", "2025-06-21 04:14:34", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8722", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-21 04:19:28", "2025-06-21 04:19:28", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750479568;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750479568;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-21 04:19:44", "2025-06-21 04:19:44", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8723", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-21 04:19:34", "2025-06-21 04:19:34", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750479574;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750479574;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-21 04:19:50", "2025-06-21 04:19:50", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8724", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-21 04:24:44", "2025-06-21 04:24:44", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750479884;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750479884;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-21 04:25:01", "2025-06-21 04:25:01", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8725", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-21 04:24:50", "2025-06-21 04:24:50", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750479890;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750479890;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-21 04:25:08", "2025-06-21 04:25:08", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8726", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-21 04:30:01", "2025-06-21 04:30:01", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750480201;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750480201;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-21 04:30:13", "2025-06-21 04:30:13", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8727", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-21 04:30:08", "2025-06-21 04:30:08", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750480208;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750480208;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-21 04:30:19", "2025-06-21 04:30:19", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8728", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-21 04:35:13", "2025-06-21 04:35:13", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750480513;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750480513;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-21 04:37:57", "2025-06-21 04:37:57", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8729", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-21 04:35:19", "2025-06-21 04:35:19", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750480519;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750480519;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-21 04:38:03", "2025-06-21 04:38:03", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8730", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-21 04:42:57", "2025-06-21 04:42:57", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750480977;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750480977;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-21 04:44:46", "2025-06-21 04:44:46", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8731", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-21 04:43:03", "2025-06-21 04:43:03", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750480983;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750480983;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-21 04:44:52", "2025-06-21 04:44:52", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8732", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-21 04:49:46", "2025-06-21 04:49:46", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750481386;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750481386;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-21 04:50:41", "2025-06-21 04:50:41", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8733", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-21 04:49:52", "2025-06-21 04:49:52", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750481392;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750481392;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-21 04:50:47", "2025-06-21 04:50:47", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8734", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-21 04:55:41", "2025-06-21 04:55:41", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750481741;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750481741;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-21 04:58:15", "2025-06-21 04:58:15", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8735", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-21 04:55:47", "2025-06-21 04:55:47", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750481747;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750481747;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-21 04:58:21", "2025-06-21 04:58:21", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8736", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-21 05:03:15", "2025-06-21 05:03:15", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750482195;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750482195;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-21 05:03:21", "2025-06-21 05:03:21", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8737", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-21 05:03:21", "2025-06-21 05:03:21", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750482201;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750482201;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-21 05:03:27", "2025-06-21 05:03:27", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8738", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-21 05:08:21", "2025-06-21 05:08:21", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750482501;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750482501;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-21 05:09:27", "2025-06-21 05:09:27", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8739", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-21 05:08:27", "2025-06-21 05:08:27", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750482507;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750482507;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-21 05:09:33", "2025-06-21 05:09:33", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8740", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-21 05:14:27", "2025-06-21 05:14:27", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750482867;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750482867;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-21 05:15:59", "2025-06-21 05:15:59", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8741", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-21 05:14:33", "2025-06-21 05:14:33", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750482873;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750482873;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-21 05:16:05", "2025-06-21 05:16:05", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8742", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-21 05:20:59", "2025-06-21 05:20:59", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750483259;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750483259;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-21 05:21:25", "2025-06-21 05:21:25", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8743", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-21 05:21:05", "2025-06-21 05:21:05", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750483265;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750483265;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-21 05:23:29", "2025-06-21 05:23:29", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8744", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-21 05:26:25", "2025-06-21 05:26:25", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750483585;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750483585;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-21 05:28:12", "2025-06-21 05:28:12", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8745", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-21 05:28:29", "2025-06-21 05:28:29", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750483709;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750483709;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-21 05:30:29", "2025-06-21 05:30:29", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8746", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-21 05:33:12", "2025-06-21 05:33:12", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750483992;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750483992;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-21 05:34:31", "2025-06-21 05:34:31", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8747", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-21 05:35:29", "2025-06-21 05:35:29", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750484129;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750484129;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-21 05:37:24", "2025-06-21 05:37:24", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8748", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-21 05:39:31", "2025-06-21 05:39:31", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750484371;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750484371;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-21 05:39:44", "2025-06-21 05:39:44", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8749", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-21 05:42:24", "2025-06-21 05:42:24", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750484544;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750484544;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-21 05:44:11", "2025-06-21 05:44:11", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8750", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-21 05:44:44", "2025-06-21 05:44:44", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750484684;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750484684;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-21 05:46:27", "2025-06-21 05:46:27", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8751", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-21 05:49:11", "2025-06-21 05:49:11", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750484951;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750484951;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-21 05:49:29", "2025-06-21 05:49:29", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8752", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-21 05:51:27", "2025-06-21 05:51:27", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750485087;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750485087;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-21 05:53:12", "2025-06-21 05:53:12", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8753", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-21 05:54:29", "2025-06-21 05:54:29", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750485269;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750485269;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-21 05:56:38", "2025-06-21 05:56:38", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8754", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-21 05:58:12", "2025-06-21 05:58:12", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750485492;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750485492;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-21 06:04:17", "2025-06-21 06:04:17", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8755", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-21 06:01:38", "2025-06-21 06:01:38", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750485698;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750485698;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-21 06:04:23", "2025-06-21 06:04:23", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8756", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-21 06:09:17", "2025-06-21 06:09:17", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750486157;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750486157;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-21 06:11:25", "2025-06-21 06:11:25", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8757", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-21 06:09:23", "2025-06-21 06:09:23", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750486163;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750486163;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-21 06:11:31", "2025-06-21 06:11:31", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8758", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-21 06:16:25", "2025-06-21 06:16:25", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750486585;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750486585;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-21 06:18:09", "2025-06-21 06:18:09", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8759", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-21 06:16:31", "2025-06-21 06:16:31", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750486591;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750486591;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-21 06:18:15", "2025-06-21 06:18:15", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8760", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-21 06:23:09", "2025-06-21 06:23:09", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750486989;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750486989;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-21 06:25:04", "2025-06-21 06:25:04", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8761", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-21 06:23:15", "2025-06-21 06:23:15", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750486995;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750486995;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-21 06:25:10", "2025-06-21 06:25:10", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8762", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-21 06:30:04", "2025-06-21 06:30:04", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750487404;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750487404;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-21 06:32:03", "2025-06-21 06:32:03", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8763", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-21 06:30:10", "2025-06-21 06:30:10", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750487410;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750487410;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-21 06:32:09", "2025-06-21 06:32:09", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8764", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-21 06:37:03", "2025-06-21 06:37:03", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750487823;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750487823;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-21 06:38:58", "2025-06-21 06:38:58", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8765", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-21 06:37:09", "2025-06-21 06:37:09", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750487829;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750487829;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-21 06:39:04", "2025-06-21 06:39:04", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8766", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-21 06:43:58", "2025-06-21 06:43:58", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750488238;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750488238;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-21 06:48:11", "2025-06-21 06:48:11", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8767", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-21 06:44:04", "2025-06-21 06:44:04", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750488244;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750488244;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-21 06:48:16", "2025-06-21 06:48:16", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8768", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-21 06:53:11", "2025-06-21 06:53:11", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750488791;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750488791;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-21 06:55:09", "2025-06-21 06:55:09", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8769", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-21 06:53:16", "2025-06-21 06:53:16", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750488796;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750488796;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-21 06:55:14", "2025-06-21 06:55:14", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8770", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-21 07:00:09", "2025-06-21 07:00:09", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750489209;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750489209;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-21 07:08:43", "2025-06-21 07:08:43", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8771", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-21 07:00:14", "2025-06-21 07:00:14", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750489214;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750489214;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-21 07:09:08", "2025-06-21 07:09:08", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8772", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-21 07:13:43", "2025-06-21 07:13:43", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750490023;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750490023;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-21 07:13:48", "2025-06-21 07:13:48", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8773", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-21 07:14:08", "2025-06-21 07:14:08", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750490048;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750490048;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-21 07:16:20", "2025-06-21 07:16:20", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8774", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-21 07:18:48", "2025-06-21 07:18:48", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750490328;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750490328;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-21 07:20:15", "2025-06-21 07:20:15", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8775", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-21 07:21:20", "2025-06-21 07:21:20", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750490480;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750490480;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-21 07:23:50", "2025-06-21 07:23:50", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8776", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-21 07:25:15", "2025-06-21 07:25:15", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750490715;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750490715;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-21 07:26:16", "2025-06-21 07:26:16", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8777", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-21 07:28:50", "2025-06-21 07:28:50", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750490930;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750490930;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-21 07:29:40", "2025-06-21 07:29:40", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8778", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-21 07:31:16", "2025-06-21 07:31:16", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750491076;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750491076;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-21 07:33:39", "2025-06-21 07:33:39", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8779", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-21 07:34:40", "2025-06-21 07:34:40", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750491280;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750491280;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-21 07:36:05", "2025-06-21 07:36:05", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8780", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-21 07:38:39", "2025-06-21 07:38:39", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750491519;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750491519;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-21 07:40:54", "2025-06-21 07:40:54", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8781", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-21 07:41:05", "2025-06-21 07:41:05", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750491665;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750491665;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-21 07:43:34", "2025-06-21 07:43:34", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8782", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-21 07:45:54", "2025-06-21 07:45:54", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750491954;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750491954;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-21 07:47:12", "2025-06-21 07:47:12", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8783", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-21 07:48:34", "2025-06-21 07:48:34", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750492114;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750492114;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-21 07:49:51", "2025-06-21 07:49:51", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8784", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-21 07:52:12", "2025-06-21 07:52:12", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750492332;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750492332;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-21 07:53:27", "2025-06-21 07:53:27", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8785", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-21 07:54:51", "2025-06-21 07:54:51", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750492491;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750492491;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-21 07:55:55", "2025-06-21 07:55:55", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8786", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-21 07:58:27", "2025-06-21 07:58:27", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750492707;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750492707;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-21 08:00:10", "2025-06-21 08:00:10", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8787", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-21 08:00:55", "2025-06-21 08:00:55", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750492855;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750492855;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-21 08:01:07", "2025-06-21 08:01:07", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8788", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-21 08:05:10", "2025-06-21 08:05:10", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750493110;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750493110;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-21 08:05:52", "2025-06-21 08:05:52", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8789", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-21 08:06:07", "2025-06-21 08:06:07", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750493167;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750493167;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-21 08:08:24", "2025-06-21 08:08:24", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8790", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-21 08:10:52", "2025-06-21 08:10:52", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750493452;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750493452;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-21 08:13:23", "2025-06-21 08:13:23", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8791", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-21 08:13:24", "2025-06-21 08:13:24", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750493604;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750493604;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-21 08:15:52", "2025-06-21 08:15:52", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8792", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-21 08:18:23", "2025-06-21 08:18:23", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750493903;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750493903;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-21 08:20:52", "2025-06-21 08:20:52", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8793", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-21 08:20:52", "2025-06-21 08:20:52", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750494052;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750494052;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-21 08:20:58", "2025-06-21 08:20:58", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8794", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-21 08:25:52", "2025-06-21 08:25:52", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750494352;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750494352;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-21 08:28:23", "2025-06-21 08:28:23", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8795", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-21 08:25:58", "2025-06-21 08:25:58", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750494358;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750494358;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-21 08:28:29", "2025-06-21 08:28:29", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8796", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-21 08:33:23", "2025-06-21 08:33:23", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750494803;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750494803;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-21 08:35:58", "2025-06-21 08:35:58", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8797", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-21 08:33:29", "2025-06-21 08:33:29", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750494809;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750494809;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-21 08:36:04", "2025-06-21 08:36:04", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8798", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-21 08:40:58", "2025-06-21 08:40:58", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750495258;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750495258;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-21 08:43:31", "2025-06-21 08:43:31", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8799", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-21 08:41:04", "2025-06-21 08:41:04", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750495264;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750495264;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-21 08:43:36", "2025-06-21 08:43:36", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8800", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-21 08:48:31", "2025-06-21 08:48:31", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750495711;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750495711;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-21 08:51:04", "2025-06-21 08:51:04", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8801", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-21 08:48:36", "2025-06-21 08:48:36", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750495716;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750495716;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-21 08:51:10", "2025-06-21 08:51:10", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8802", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-21 08:56:04", "2025-06-21 08:56:04", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750496164;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750496164;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-21 09:02:06", "2025-06-21 09:02:06", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8803", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-21 08:56:10", "2025-06-21 08:56:10", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750496170;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750496170;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-21 09:02:11", "2025-06-21 09:02:11", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8804", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-21 09:07:06", "2025-06-21 09:07:06", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750496826;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750496826;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-21 09:08:40", "2025-06-21 09:08:40", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8805", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-21 09:07:11", "2025-06-21 09:07:11", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750496831;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750496831;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-21 09:08:45", "2025-06-21 09:08:45", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8806", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-21 09:13:40", "2025-06-21 09:13:40", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750497220;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750497220;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-21 09:16:13", "2025-06-21 09:16:13", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8807", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-21 09:13:45", "2025-06-21 09:13:45", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750497225;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750497225;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-21 09:16:19", "2025-06-21 09:16:19", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8808", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-21 09:21:13", "2025-06-21 09:21:13", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750497673;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750497673;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-21 09:23:44", "2025-06-21 09:23:44", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8809", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-21 09:21:19", "2025-06-21 09:21:19", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750497679;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750497679;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-21 09:23:50", "2025-06-21 09:23:50", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8810", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-21 09:28:44", "2025-06-21 09:28:44", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750498124;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750498124;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-21 09:28:52", "2025-06-21 09:28:52", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8811", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-21 09:28:50", "2025-06-21 09:28:50", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750498130;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750498130;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-21 09:28:58", "2025-06-21 09:28:58", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8812", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-21 09:33:52", "2025-06-21 09:33:52", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750498432;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750498432;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-21 09:34:52", "2025-06-21 09:34:52", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8813", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-21 09:33:58", "2025-06-21 09:33:58", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750498438;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750498438;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-21 09:34:58", "2025-06-21 09:34:58", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8814", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-21 09:39:52", "2025-06-21 09:39:52", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750498792;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750498792;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-21 09:41:26", "2025-06-21 09:41:26", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8815", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-21 09:39:58", "2025-06-21 09:39:58", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750498798;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750498798;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-21 09:41:32", "2025-06-21 09:41:32", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8816", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-21 09:46:26", "2025-06-21 09:46:26", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750499186;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750499186;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-21 09:48:59", "2025-06-21 09:48:59", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8817", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-21 09:46:32", "2025-06-21 09:46:32", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750499192;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750499192;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-21 09:49:05", "2025-06-21 09:49:05", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8818", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-21 09:53:59", "2025-06-21 09:53:59", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750499639;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750499639;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-21 09:54:18", "2025-06-21 09:54:18", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8819", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-21 09:54:05", "2025-06-21 09:54:05", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750499645;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750499645;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-21 09:54:23", "2025-06-21 09:54:23", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8820", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-21 09:59:18", "2025-06-21 09:59:18", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750499958;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750499958;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-21 10:08:36", "2025-06-21 10:08:36", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8821", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-21 09:59:23", "2025-06-21 09:59:23", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750499963;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750499963;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-21 10:08:42", "2025-06-21 10:08:42", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8822", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-21 10:13:36", "2025-06-21 10:13:36", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750500816;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750500816;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-21 10:14:01", "2025-06-21 10:14:01", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8823", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-21 10:13:42", "2025-06-21 10:13:42", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750500822;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750500822;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-21 10:14:07", "2025-06-21 10:14:07", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8824", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-21 10:19:01", "2025-06-21 10:19:01", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750501141;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750501141;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-21 10:21:50", "2025-06-21 10:21:50", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8825", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-21 10:19:07", "2025-06-21 10:19:07", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750501147;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750501147;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-21 10:21:55", "2025-06-21 10:21:55", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8826", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-21 10:26:50", "2025-06-21 10:26:50", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750501610;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750501610;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-21 10:29:21", "2025-06-21 10:29:21", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8827", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-21 10:26:55", "2025-06-21 10:26:55", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750501615;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750501615;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-21 10:29:26", "2025-06-21 10:29:26", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8828", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-21 10:34:21", "2025-06-21 10:34:21", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750502061;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750502061;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-21 10:36:53", "2025-06-21 10:36:53", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8829", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-21 10:34:26", "2025-06-21 10:34:26", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750502066;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750502066;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-21 10:36:59", "2025-06-21 10:36:59", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8830", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-21 10:41:53", "2025-06-21 10:41:53", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750502513;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750502513;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-21 10:44:28", "2025-06-21 10:44:28", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8831", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-21 10:41:59", "2025-06-21 10:41:59", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750502519;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750502519;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-21 10:44:34", "2025-06-21 10:44:34", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8832", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-21 10:49:28", "2025-06-21 10:49:28", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750502968;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750502968;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-21 10:49:35", "2025-06-21 10:49:35", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8833", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-21 10:49:34", "2025-06-21 10:49:34", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750502974;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750502974;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-21 10:49:40", "2025-06-21 10:49:40", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8834", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-21 10:54:35", "2025-06-21 10:54:35", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750503275;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750503275;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-21 10:57:10", "2025-06-21 10:57:10", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8835", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-21 10:54:40", "2025-06-21 10:54:40", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750503280;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750503280;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-21 10:57:16", "2025-06-21 10:57:16", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8836", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-21 11:02:10", "2025-06-21 11:02:10", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750503730;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750503730;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-21 11:09:54", "2025-06-21 11:09:54", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8837", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-21 11:02:16", "2025-06-21 11:02:16", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750503736;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750503736;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-21 11:10:00", "2025-06-21 11:10:00", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8838", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-21 11:14:54", "2025-06-21 11:14:54", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750504494;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750504494;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-21 11:15:50", "2025-06-21 11:15:50", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8839", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-21 11:15:00", "2025-06-21 11:15:00", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750504500;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750504500;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-21 11:15:56", "2025-06-21 11:15:56", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8840", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-21 11:20:50", "2025-06-21 11:20:50", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750504850;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750504850;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-21 11:22:38", "2025-06-21 11:22:38", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8841", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-21 11:20:56", "2025-06-21 11:20:56", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750504856;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750504856;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-21 11:22:44", "2025-06-21 11:22:44", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8842", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-21 11:27:38", "2025-06-21 11:27:38", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750505258;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750505258;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-21 11:28:35", "2025-06-21 11:28:35", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8843", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-21 11:27:44", "2025-06-21 11:27:44", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750505264;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750505264;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-21 11:28:41", "2025-06-21 11:28:41", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8844", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-21 11:33:35", "2025-06-21 11:33:35", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750505615;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750505615;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-21 11:35:15", "2025-06-21 11:35:15", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8845", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-21 11:33:41", "2025-06-21 11:33:41", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750505621;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750505621;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-21 11:35:21", "2025-06-21 11:35:21", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8846", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-21 11:40:15", "2025-06-21 11:40:15", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750506015;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750506015;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-21 11:41:06", "2025-06-21 11:41:06", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8847", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-21 11:40:21", "2025-06-21 11:40:21", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750506021;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750506021;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-21 11:42:52", "2025-06-21 11:42:52", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8848", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-21 11:46:06", "2025-06-21 11:46:06", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750506366;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750506366;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-21 11:47:54", "2025-06-21 11:47:54", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8849", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-21 11:47:52", "2025-06-21 11:47:52", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750506472;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750506472;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-21 11:48:00", "2025-06-21 11:48:00", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8850", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-21 11:52:54", "2025-06-21 11:52:54", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750506774;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750506774;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-21 11:55:27", "2025-06-21 11:55:27", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8851", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-21 11:53:00", "2025-06-21 11:53:00", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750506780;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750506780;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-21 11:55:33", "2025-06-21 11:55:33", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8852", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-21 12:00:27", "2025-06-21 12:00:27", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750507227;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750507227;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-21 12:10:42", "2025-06-21 12:10:42", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8853", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-21 12:00:33", "2025-06-21 12:00:33", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750507233;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750507233;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-21 12:10:48", "2025-06-21 12:10:48", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8854", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-21 12:15:42", "2025-06-21 12:15:42", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750508142;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750508142;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-21 12:18:19", "2025-06-21 12:18:19", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8855", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-21 12:15:48", "2025-06-21 12:15:48", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750508148;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750508148;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-21 12:18:25", "2025-06-21 12:18:25", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8856", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-21 12:23:19", "2025-06-21 12:23:19", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750508599;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750508599;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-21 12:25:54", "2025-06-21 12:25:54", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8857", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-21 12:23:25", "2025-06-21 12:23:25", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750508605;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750508605;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-21 12:25:59", "2025-06-21 12:25:59", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8858", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-21 12:30:54", "2025-06-21 12:30:54", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750509054;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750509054;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-21 12:33:27", "2025-06-21 12:33:27", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8859", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-21 12:30:59", "2025-06-21 12:30:59", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750509059;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750509059;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-21 12:33:33", "2025-06-21 12:33:33", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8860", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-21 12:38:27", "2025-06-21 12:38:27", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750509507;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750509507;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-21 12:38:38", "2025-06-21 12:38:38", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8861", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-21 12:38:33", "2025-06-21 12:38:33", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750509513;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750509513;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-21 12:38:44", "2025-06-21 12:38:44", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8862", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-21 12:43:38", "2025-06-21 12:43:38", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750509818;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750509818;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-21 12:46:13", "2025-06-21 12:46:13", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8863", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-21 12:43:44", "2025-06-21 12:43:44", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750509824;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750509824;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-21 12:46:19", "2025-06-21 12:46:19", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8864", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-21 12:51:13", "2025-06-21 12:51:13", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750510273;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750510273;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-21 12:51:26", "2025-06-21 12:51:26", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8865", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-21 12:51:19", "2025-06-21 12:51:19", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750510279;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750510279;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-21 12:51:32", "2025-06-21 12:51:32", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8866", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-21 12:56:26", "2025-06-21 12:56:26", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750510586;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750510586;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-21 12:58:58", "2025-06-21 12:58:58", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8867", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-21 12:56:32", "2025-06-21 12:56:32", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750510592;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750510592;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-21 12:59:04", "2025-06-21 12:59:04", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8868", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-21 13:03:58", "2025-06-21 13:03:58", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750511038;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750511038;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-21 13:09:16", "2025-06-21 13:09:16", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8869", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-21 13:04:04", "2025-06-21 13:04:04", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750511044;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750511044;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-21 13:09:21", "2025-06-21 13:09:21", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8870", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-21 13:14:16", "2025-06-21 13:14:16", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750511656;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750511656;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-21 13:16:50", "2025-06-21 13:16:50", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8871", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-21 13:14:21", "2025-06-21 13:14:21", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750511661;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750511661;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-21 13:16:57", "2025-06-21 13:16:57", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8872", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-21 13:21:50", "2025-06-21 13:21:50", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750512110;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750512110;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-21 13:21:56", "2025-06-21 13:21:56", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8873", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-21 13:21:57", "2025-06-21 13:21:57", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750512117;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750512117;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-21 13:24:28", "2025-06-21 13:24:28", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8874", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-21 13:26:56", "2025-06-21 13:26:56", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750512416;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750512416;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-21 13:29:31", "2025-06-21 13:29:31", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8875", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-21 13:29:28", "2025-06-21 13:29:28", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750512568;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750512568;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-21 13:29:37", "2025-06-21 13:29:37", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8876", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-21 13:34:31", "2025-06-21 13:34:31", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750512871;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750512871;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-21 13:34:40", "2025-06-21 13:34:40", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8877", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-21 13:34:37", "2025-06-21 13:34:37", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750512877;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750512877;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-21 13:34:46", "2025-06-21 13:34:46", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8878", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-21 13:39:40", "2025-06-21 13:39:40", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750513180;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750513180;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-21 13:42:18", "2025-06-21 13:42:18", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8879", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-21 13:39:46", "2025-06-21 13:39:46", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750513186;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750513186;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-21 13:42:23", "2025-06-21 13:42:23", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8880", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-21 13:47:18", "2025-06-21 13:47:18", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750513638;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750513638;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-21 13:47:23", "2025-06-21 13:47:23", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8881", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-21 13:47:23", "2025-06-21 13:47:23", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750513643;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750513643;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-21 13:47:29", "2025-06-21 13:47:29", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8882", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-21 13:52:23", "2025-06-21 13:52:23", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750513943;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750513943;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-21 13:55:35", "2025-06-21 13:55:35", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8883", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-21 13:52:29", "2025-06-21 13:52:29", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750513949;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750513949;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-21 13:55:41", "2025-06-21 13:55:41", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8884", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-21 14:00:35", "2025-06-21 14:00:35", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750514435;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750514435;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-21 14:09:41", "2025-06-21 14:09:41", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8885", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-21 14:00:41", "2025-06-21 14:00:41", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750514441;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750514441;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-21 14:10:20", "2025-06-21 14:10:20", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8886", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-21 14:14:41", "2025-06-21 14:14:41", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750515281;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750515281;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-21 14:15:24", "2025-06-21 14:15:24", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8887", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-21 14:15:20", "2025-06-21 14:15:20", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750515320;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750515320;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-21 14:15:29", "2025-06-21 14:15:29", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8888", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-21 14:20:24", "2025-06-21 14:20:24", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750515624;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750515624;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-21 14:23:00", "2025-06-21 14:23:00", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8889", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-21 14:20:29", "2025-06-21 14:20:29", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750515629;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750515629;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-21 14:23:07", "2025-06-21 14:23:07", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8890", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-21 14:28:00", "2025-06-21 14:28:00", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750516080;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750516080;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-21 14:32:55", "2025-06-21 14:32:55", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8891", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-21 14:28:07", "2025-06-21 14:28:07", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750516087;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750516087;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-21 14:33:01", "2025-06-21 14:33:01", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8892", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-21 14:37:55", "2025-06-21 14:37:55", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750516675;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750516675;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-21 14:40:20", "2025-06-21 14:40:20", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8893", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-21 14:38:01", "2025-06-21 14:38:01", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750516681;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750516681;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-21 14:40:26", "2025-06-21 14:40:26", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8894", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-21 14:45:20", "2025-06-21 14:45:20", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750517120;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750517120;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-21 14:47:37", "2025-06-21 14:47:37", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8895", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-21 14:45:26", "2025-06-21 14:45:26", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750517126;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750517126;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-21 14:47:43", "2025-06-21 14:47:43", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8896", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-21 14:52:37", "2025-06-21 14:52:37", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750517557;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750517557;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-21 14:54:53", "2025-06-21 14:54:53", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8897", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-21 14:52:43", "2025-06-21 14:52:43", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750517563;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750517563;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-21 14:54:59", "2025-06-21 14:54:59", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8898", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-21 14:59:53", "2025-06-21 14:59:53", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750517993;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750517993;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-21 15:07:00", "2025-06-21 15:07:00", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8899", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-21 14:59:59", "2025-06-21 14:59:59", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750517999;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750517999;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-21 15:07:06", "2025-06-21 15:07:06", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8900", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-21 15:12:00", "2025-06-21 15:12:00", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750518720;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750518720;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-21 15:14:17", "2025-06-21 15:14:17", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8901", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-21 15:12:06", "2025-06-21 15:12:06", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750518726;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750518726;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-21 15:14:23", "2025-06-21 15:14:23", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8902", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-21 15:19:17", "2025-06-21 15:19:17", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750519157;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750519157;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-21 15:21:38", "2025-06-21 15:21:38", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8903", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-21 15:19:23", "2025-06-21 15:19:23", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750519163;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750519163;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-21 15:21:44", "2025-06-21 15:21:44", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8904", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-21 15:26:38", "2025-06-21 15:26:38", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750519598;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750519598;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-21 15:28:51", "2025-06-21 15:28:51", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8905", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-21 15:26:44", "2025-06-21 15:26:44", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750519604;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750519604;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-21 15:28:57", "2025-06-21 15:28:57", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8906", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-21 15:33:51", "2025-06-21 15:33:51", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750520031;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750520031;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-21 15:36:03", "2025-06-21 15:36:03", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8907", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-21 15:33:57", "2025-06-21 15:33:57", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750520037;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750520037;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-21 15:36:09", "2025-06-21 15:36:09", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8908", "woocommerce_refresh_order_count_cache", "complete", "2025-06-22 03:35:57", "2025-06-22 03:35:57", "10", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750563357;s:18:\"\0*\0first_timestamp\";i:1750259475;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750563357;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "10", "1", "2025-06-22 03:55:29", "2025-06-22 03:55:29", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8909", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-21 15:41:03", "2025-06-21 15:41:03", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750520463;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750520463;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-21 15:43:25", "2025-06-21 15:43:25", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8910", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-21 15:41:09", "2025-06-21 15:41:09", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750520469;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750520469;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-21 15:43:31", "2025-06-21 15:43:31", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8911", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-21 15:48:25", "2025-06-21 15:48:25", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750520905;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750520905;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-21 15:50:43", "2025-06-21 15:50:43", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8912", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-21 15:48:31", "2025-06-21 15:48:31", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750520911;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750520911;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-21 15:50:48", "2025-06-21 15:50:48", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8913", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-21 15:55:43", "2025-06-21 15:55:43", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750521343;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750521343;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-21 15:57:43", "2025-06-21 15:57:43", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8914", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-21 15:55:48", "2025-06-21 15:55:48", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750521348;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750521348;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-21 15:57:49", "2025-06-21 15:57:49", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8915", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-21 16:02:43", "2025-06-21 16:02:43", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750521763;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750521763;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-21 16:04:23", "2025-06-21 16:04:23", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8916", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-21 16:02:49", "2025-06-21 16:02:49", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750521769;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750521769;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-21 16:04:29", "2025-06-21 16:04:29", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8917", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-21 16:09:23", "2025-06-21 16:09:23", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750522163;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750522163;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-21 16:09:44", "2025-06-21 16:09:44", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8918", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-21 16:09:29", "2025-06-21 16:09:29", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750522169;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750522169;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-21 16:09:50", "2025-06-21 16:09:50", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8919", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-21 16:14:44", "2025-06-21 16:14:44", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750522484;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750522484;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-21 16:17:08", "2025-06-21 16:17:08", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8920", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-21 16:14:50", "2025-06-21 16:14:50", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750522490;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750522490;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-21 16:17:14", "2025-06-21 16:17:14", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8921", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-21 16:22:08", "2025-06-21 16:22:08", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750522928;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750522928;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-21 16:24:19", "2025-06-21 16:24:19", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8922", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-21 16:22:14", "2025-06-21 16:22:14", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750522934;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750522934;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-21 16:24:25", "2025-06-21 16:24:25", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8923", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-21 16:29:19", "2025-06-21 16:29:19", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750523359;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750523359;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-21 16:31:41", "2025-06-21 16:31:41", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8924", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-21 16:29:25", "2025-06-21 16:29:25", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750523365;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750523365;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-21 16:31:47", "2025-06-21 16:31:47", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8925", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-21 16:36:41", "2025-06-21 16:36:41", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750523801;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750523801;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-21 16:39:03", "2025-06-21 16:39:03", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8926", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-21 16:36:47", "2025-06-21 16:36:47", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750523807;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750523807;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-21 16:41:30", "2025-06-21 16:41:30", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8927", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-21 16:44:03", "2025-06-21 16:44:03", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750524243;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750524243;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-21 16:46:24", "2025-06-21 16:46:24", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8928", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-21 16:46:30", "2025-06-21 16:46:30", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750524390;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750524390;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-21 16:48:53", "2025-06-21 16:48:53", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8929", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-21 16:51:24", "2025-06-21 16:51:24", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750524684;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750524684;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-21 16:53:48", "2025-06-21 16:53:48", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8930", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-21 16:53:53", "2025-06-21 16:53:53", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750524833;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750524833;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-21 16:56:00", "2025-06-21 16:56:00", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8931", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-21 16:58:48", "2025-06-21 16:58:48", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750525128;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750525128;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-21 17:01:59", "2025-06-21 17:01:59", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8932", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-21 17:01:00", "2025-06-21 17:01:00", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750525260;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750525260;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-21 17:02:05", "2025-06-21 17:02:05", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8933", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-21 17:06:59", "2025-06-21 17:06:59", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750525619;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750525619;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-21 17:08:41", "2025-06-21 17:08:41", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8934", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-21 17:07:05", "2025-06-21 17:07:05", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750525625;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750525625;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-21 17:08:47", "2025-06-21 17:08:47", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8935", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-21 17:13:41", "2025-06-21 17:13:41", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750526021;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750526021;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-21 17:17:25", "2025-06-21 17:17:25", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8936", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-21 17:13:47", "2025-06-21 17:13:47", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750526027;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750526027;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-21 17:17:30", "2025-06-21 17:17:30", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8937", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-21 17:22:25", "2025-06-21 17:22:25", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750526545;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750526545;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-21 17:24:26", "2025-06-21 17:24:26", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8938", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-21 17:22:30", "2025-06-21 17:22:30", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750526550;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750526550;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-21 17:24:32", "2025-06-21 17:24:32", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8939", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-21 17:29:26", "2025-06-21 17:29:26", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750526966;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750526966;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-21 17:42:16", "2025-06-21 17:42:16", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8940", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-21 17:29:32", "2025-06-21 17:29:32", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750526972;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750526972;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-21 17:42:22", "2025-06-21 17:42:22", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8941", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-21 17:47:16", "2025-06-21 17:47:16", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750528036;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750528036;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-21 17:53:42", "2025-06-21 17:53:42", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8942", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-21 17:47:22", "2025-06-21 17:47:22", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750528042;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750528042;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-21 17:53:48", "2025-06-21 17:53:48", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8943", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-21 17:58:42", "2025-06-21 17:58:42", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750528722;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750528722;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-21 18:14:27", "2025-06-21 18:14:27", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8944", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-21 17:58:48", "2025-06-21 17:58:48", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750528728;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750528728;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-21 18:14:32", "2025-06-21 18:14:32", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8945", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-21 18:19:27", "2025-06-21 18:19:27", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750529967;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750529967;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-21 18:29:45", "2025-06-21 18:29:45", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8946", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-21 18:19:32", "2025-06-21 18:19:32", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750529972;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750529972;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-21 18:29:52", "2025-06-21 18:29:52", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8947", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-21 18:34:45", "2025-06-21 18:34:45", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750530885;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750530885;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-21 18:39:43", "2025-06-21 18:39:43", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8948", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-21 18:34:52", "2025-06-21 18:34:52", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750530892;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750530892;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-21 18:42:34", "2025-06-21 18:42:34", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8949", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-21 18:44:43", "2025-06-21 18:44:43", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750531483;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750531483;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-21 18:44:59", "2025-06-21 18:44:59", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8950", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-21 18:47:34", "2025-06-21 18:47:34", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750531654;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750531654;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-21 18:51:09", "2025-06-21 18:51:09", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8951", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-21 18:49:59", "2025-06-21 18:49:59", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750531799;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750531799;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-21 18:51:15", "2025-06-21 18:51:15", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8952", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-21 18:56:09", "2025-06-21 18:56:09", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750532169;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750532169;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-21 19:02:56", "2025-06-21 19:02:56", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8953", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-21 18:56:15", "2025-06-21 18:56:15", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750532175;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750532175;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-21 19:03:02", "2025-06-21 19:03:02", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8954", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-21 19:07:56", "2025-06-21 19:07:56", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750532876;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750532876;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-21 19:17:35", "2025-06-21 19:17:35", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8955", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-21 19:08:02", "2025-06-21 19:08:02", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750532882;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750532882;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-21 19:18:18", "2025-06-21 19:18:18", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8956", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-21 19:22:35", "2025-06-21 19:22:35", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750533755;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750533755;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-21 19:34:55", "2025-06-21 19:34:55", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8957", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-21 19:23:18", "2025-06-21 19:23:18", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750533798;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750533798;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-21 19:35:01", "2025-06-21 19:35:01", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8958", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-21 19:39:55", "2025-06-21 19:39:55", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750534795;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750534795;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-21 19:51:11", "2025-06-21 19:51:11", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8959", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-21 19:40:01", "2025-06-21 19:40:01", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750534801;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750534801;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-21 20:08:53", "2025-06-21 20:08:53", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8960", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-21 19:56:11", "2025-06-21 19:56:11", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750535771;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750535771;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-21 20:08:59", "2025-06-21 20:08:59", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8961", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-21 20:13:53", "2025-06-21 20:13:53", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750536833;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750536833;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-21 20:14:26", "2025-06-21 20:14:26", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8962", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-21 20:13:59", "2025-06-21 20:13:59", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750536839;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750536839;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-21 20:14:32", "2025-06-21 20:14:32", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8963", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-21 20:19:26", "2025-06-21 20:19:26", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750537166;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750537166;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-21 20:21:39", "2025-06-21 20:21:39", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8964", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-21 20:19:32", "2025-06-21 20:19:32", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750537172;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750537172;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-21 20:21:45", "2025-06-21 20:21:45", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8965", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-21 20:26:39", "2025-06-21 20:26:39", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750537599;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750537599;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-21 20:28:53", "2025-06-21 20:28:53", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8966", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-21 20:26:45", "2025-06-21 20:26:45", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750537605;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750537605;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-21 20:28:59", "2025-06-21 20:28:59", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8967", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-21 20:33:53", "2025-06-21 20:33:53", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750538033;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750538033;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-21 20:36:08", "2025-06-21 20:36:08", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8968", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-21 20:33:59", "2025-06-21 20:33:59", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750538039;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750538039;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-21 20:36:14", "2025-06-21 20:36:14", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8969", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-21 20:41:08", "2025-06-21 20:41:08", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750538468;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750538468;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-21 20:43:21", "2025-06-21 20:43:21", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8970", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-21 20:41:14", "2025-06-21 20:41:14", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750538474;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750538474;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-21 20:43:27", "2025-06-21 20:43:27", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8971", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-21 20:48:21", "2025-06-21 20:48:21", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750538901;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750538901;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-21 20:50:37", "2025-06-21 20:50:37", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8972", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-21 20:48:27", "2025-06-21 20:48:27", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750538907;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750538907;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-21 20:50:43", "2025-06-21 20:50:43", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8973", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-21 20:55:37", "2025-06-21 20:55:37", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750539337;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750539337;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-21 20:57:50", "2025-06-21 20:57:50", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8974", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-21 20:55:43", "2025-06-21 20:55:43", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750539343;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750539343;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-21 20:57:56", "2025-06-21 20:57:56", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8975", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-21 21:02:50", "2025-06-21 21:02:50", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750539770;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750539770;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-21 21:09:13", "2025-06-21 21:09:13", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8976", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-21 21:02:56", "2025-06-21 21:02:56", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750539776;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750539776;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-21 21:10:29", "2025-06-21 21:10:29", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8977", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-21 21:14:13", "2025-06-21 21:14:13", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750540453;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750540453;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-21 21:14:41", "2025-06-21 21:14:41", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8978", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-21 21:15:29", "2025-06-21 21:15:29", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750540529;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750540529;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-21 21:17:55", "2025-06-21 21:17:55", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8979", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-21 21:19:41", "2025-06-21 21:19:41", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750540781;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750540781;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-21 21:20:25", "2025-06-21 21:20:25", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8980", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-21 21:22:55", "2025-06-21 21:22:55", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750540975;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750540975;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-21 21:25:28", "2025-06-21 21:25:28", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8981", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-21 21:25:25", "2025-06-21 21:25:25", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750541125;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750541125;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-21 21:25:34", "2025-06-21 21:25:34", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8982", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-21 21:30:28", "2025-06-21 21:30:28", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750541428;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750541428;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-21 21:31:34", "2025-06-21 21:31:34", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8983", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-21 21:30:34", "2025-06-21 21:30:34", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750541434;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750541434;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-21 21:31:40", "2025-06-21 21:31:40", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8984", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-21 21:36:34", "2025-06-21 21:36:34", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750541794;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750541794;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-21 21:37:30", "2025-06-21 21:37:30", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8985", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-21 21:36:40", "2025-06-21 21:36:40", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750541800;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750541800;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-21 21:37:36", "2025-06-21 21:37:36", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8986", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-21 21:42:30", "2025-06-21 21:42:30", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750542150;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750542150;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-21 21:42:45", "2025-06-21 21:42:45", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8987", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-21 21:42:36", "2025-06-21 21:42:36", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750542156;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750542156;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-21 21:42:51", "2025-06-21 21:42:51", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8988", "woocommerce_cleanup_draft_orders", "complete", "2025-06-22 21:38:19", "2025-06-22 21:38:19", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750628299;s:18:\"\0*\0first_timestamp\";i:1744536626;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750628299;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-06-22 22:49:03", "2025-06-22 22:49:03", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8989", "wpforms_process_forms_locator_scan", "complete", "2025-06-22 21:38:19", "2025-06-22 21:38:19", "10", "{\"tasks_meta_id\":1}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750628299;s:18:\"\0*\0first_timestamp\";i:1744536754;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750628299;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2025-06-22 22:49:03", "2025-06-22 22:49:03", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8990", "wpforms_process_purge_spam", "complete", "2025-06-22 21:38:19", "2025-06-22 21:38:19", "10", "{\"tasks_meta_id\":2}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750628299;s:18:\"\0*\0first_timestamp\";i:1744536754;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750628299;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2025-06-22 22:49:03", "2025-06-22 22:49:03", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8991", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-21 21:47:45", "2025-06-21 21:47:45", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750542465;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750542465;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-21 21:48:15", "2025-06-21 21:48:15", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8992", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-21 21:47:51", "2025-06-21 21:47:51", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750542471;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750542471;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-21 21:48:21", "2025-06-21 21:48:21", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8993", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-21 21:53:15", "2025-06-21 21:53:15", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750542795;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750542795;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-21 21:55:11", "2025-06-21 21:55:11", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8994", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-21 21:53:21", "2025-06-21 21:53:21", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750542801;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750542801;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-21 21:55:17", "2025-06-21 21:55:17", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8995", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-21 22:00:11", "2025-06-21 22:00:11", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750543211;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750543211;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-21 22:05:48", "2025-06-21 22:05:48", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8996", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-21 22:00:17", "2025-06-21 22:00:17", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750543217;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750543217;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-21 22:05:55", "2025-06-21 22:05:55", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8997", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-21 22:10:48", "2025-06-21 22:10:48", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750543848;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750543848;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-21 22:12:46", "2025-06-21 22:12:46", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8998", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-21 22:10:55", "2025-06-21 22:10:55", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750543855;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750543855;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-21 22:12:53", "2025-06-21 22:12:53", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("8999", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-21 22:17:46", "2025-06-21 22:17:46", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750544266;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750544266;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-21 22:18:44", "2025-06-21 22:18:44", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("9000", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-21 22:17:53", "2025-06-21 22:17:53", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750544273;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750544273;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-21 22:18:50", "2025-06-21 22:18:50", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("9001", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-21 22:23:44", "2025-06-21 22:23:44", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750544624;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750544624;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-21 22:25:29", "2025-06-21 22:25:29", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("9002", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-21 22:23:50", "2025-06-21 22:23:50", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750544630;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750544630;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-21 22:25:34", "2025-06-21 22:25:34", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("9003", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-21 22:30:29", "2025-06-21 22:30:29", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750545029;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750545029;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-21 22:33:03", "2025-06-21 22:33:03", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("9004", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-21 22:30:34", "2025-06-21 22:30:34", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750545034;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750545034;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-21 22:33:09", "2025-06-21 22:33:09", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("9005", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-21 22:38:03", "2025-06-21 22:38:03", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750545483;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750545483;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-21 22:40:39", "2025-06-21 22:40:39", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("9006", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-21 22:38:09", "2025-06-21 22:38:09", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750545489;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750545489;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-21 22:43:13", "2025-06-21 22:43:13", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("9007", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-21 22:45:39", "2025-06-21 22:45:39", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750545939;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750545939;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-21 22:48:20", "2025-06-21 22:48:20", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("9008", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-21 22:48:13", "2025-06-21 22:48:13", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750546093;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750546093;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-21 22:48:26", "2025-06-21 22:48:26", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("9009", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-21 22:53:20", "2025-06-21 22:53:20", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750546400;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750546400;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-21 22:55:54", "2025-06-21 22:55:54", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("9010", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-21 22:53:26", "2025-06-21 22:53:26", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750546406;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750546406;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-21 22:56:01", "2025-06-21 22:56:01", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("9011", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-21 23:00:54", "2025-06-21 23:00:54", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750546854;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750546854;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-21 23:01:02", "2025-06-21 23:01:02", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("9012", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-21 23:01:01", "2025-06-21 23:01:01", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750546861;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750546861;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-21 23:01:08", "2025-06-21 23:01:08", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("9013", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-21 23:06:02", "2025-06-21 23:06:02", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750547162;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750547162;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-21 23:08:39", "2025-06-21 23:08:39", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("9014", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-21 23:06:08", "2025-06-21 23:06:08", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750547168;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750547168;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-21 23:08:45", "2025-06-21 23:08:45", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("9015", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-21 23:13:39", "2025-06-21 23:13:39", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750547619;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750547619;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-21 23:15:38", "2025-06-21 23:15:38", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("9016", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-21 23:13:45", "2025-06-21 23:13:45", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750547625;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750547625;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-21 23:15:44", "2025-06-21 23:15:44", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("9017", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-21 23:20:38", "2025-06-21 23:20:38", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750548038;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750548038;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-21 23:21:21", "2025-06-21 23:21:21", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("9018", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-21 23:20:44", "2025-06-21 23:20:44", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750548044;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750548044;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-21 23:21:27", "2025-06-21 23:21:27", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("9019", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-21 23:26:21", "2025-06-21 23:26:21", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750548381;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750548381;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-21 23:28:52", "2025-06-21 23:28:52", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("9020", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-21 23:26:27", "2025-06-21 23:26:27", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750548387;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750548387;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-21 23:28:58", "2025-06-21 23:28:58", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("9021", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-21 23:33:52", "2025-06-21 23:33:52", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750548832;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750548832;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-21 23:36:28", "2025-06-21 23:36:28", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("9022", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-21 23:33:58", "2025-06-21 23:33:58", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750548838;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750548838;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-21 23:36:34", "2025-06-21 23:36:34", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("9023", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-21 23:41:28", "2025-06-21 23:41:28", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750549288;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750549288;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-21 23:43:10", "2025-06-21 23:43:10", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("9024", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-21 23:41:34", "2025-06-21 23:41:34", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750549294;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750549294;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-21 23:43:16", "2025-06-21 23:43:16", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("9025", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-21 23:48:10", "2025-06-21 23:48:10", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750549690;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750549690;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-21 23:50:19", "2025-06-21 23:50:19", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("9026", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-21 23:48:16", "2025-06-21 23:48:16", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750549696;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750549696;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-21 23:50:25", "2025-06-21 23:50:25", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("9027", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-21 23:55:19", "2025-06-21 23:55:19", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750550119;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750550119;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-22 00:07:54", "2025-06-22 00:07:54", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("9028", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-21 23:55:25", "2025-06-21 23:55:25", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750550125;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750550125;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-22 00:08:00", "2025-06-22 00:08:00", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("9029", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-22 00:12:54", "2025-06-22 00:12:54", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750551174;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750551174;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-22 00:24:24", "2025-06-22 00:24:24", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("9030", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-22 00:13:00", "2025-06-22 00:13:00", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750551180;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750551180;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-22 00:24:30", "2025-06-22 00:24:30", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("9031", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-22 00:29:24", "2025-06-22 00:29:24", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750552164;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750552164;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-22 00:29:41", "2025-06-22 00:29:41", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("9032", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-22 00:29:30", "2025-06-22 00:29:30", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750552170;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750552170;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-22 00:29:47", "2025-06-22 00:29:47", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("9033", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-22 00:34:41", "2025-06-22 00:34:41", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750552481;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750552481;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-22 00:39:28", "2025-06-22 00:39:28", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("9034", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-22 00:34:47", "2025-06-22 00:34:47", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750552487;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750552487;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-22 00:43:27", "2025-06-22 00:43:27", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("9035", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-22 00:44:28", "2025-06-22 00:44:28", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750553068;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750553068;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-22 01:00:57", "2025-06-22 01:00:57", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("9036", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-22 00:48:27", "2025-06-22 00:48:27", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750553307;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750553307;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-22 01:19:13", "2025-06-22 01:19:13", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("9037", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-22 01:05:57", "2025-06-22 01:05:57", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750554357;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750554357;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-22 01:19:19", "2025-06-22 01:19:19", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("9038", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-22 01:24:13", "2025-06-22 01:24:13", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750555453;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750555453;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-22 01:36:56", "2025-06-22 01:36:56", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("9039", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-22 01:24:19", "2025-06-22 01:24:19", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750555459;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750555459;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-22 01:37:02", "2025-06-22 01:37:02", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("9040", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-22 01:41:56", "2025-06-22 01:41:56", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750556516;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750556516;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-22 01:52:24", "2025-06-22 01:52:24", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("9041", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-22 01:42:02", "2025-06-22 01:42:02", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750556522;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750556522;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-22 02:13:20", "2025-06-22 02:13:20", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("9042", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-22 01:57:24", "2025-06-22 01:57:24", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750557444;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750557444;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-22 02:13:26", "2025-06-22 02:13:26", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("9043", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-22 02:18:20", "2025-06-22 02:18:20", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750558700;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750558700;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-22 02:25:22", "2025-06-22 02:25:22", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("9044", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-22 02:18:26", "2025-06-22 02:18:26", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750558706;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750558706;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-22 02:25:27", "2025-06-22 02:25:27", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("9045", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-22 02:30:22", "2025-06-22 02:30:22", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750559422;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750559422;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-22 02:33:13", "2025-06-22 02:33:13", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("9046", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-22 02:30:27", "2025-06-22 02:30:27", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750559427;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750559427;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-22 02:33:19", "2025-06-22 02:33:19", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("9047", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-22 02:38:13", "2025-06-22 02:38:13", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750559893;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750559893;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-22 02:50:17", "2025-06-22 02:50:17", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("9048", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-22 02:38:19", "2025-06-22 02:38:19", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750559899;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750559899;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-22 02:50:23", "2025-06-22 02:50:23", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("9049", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-22 02:55:17", "2025-06-22 02:55:17", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750560917;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750560917;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-22 03:08:35", "2025-06-22 03:08:35", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("9050", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-22 02:55:23", "2025-06-22 02:55:23", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750560923;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750560923;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-22 03:08:41", "2025-06-22 03:08:41", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("9051", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-22 03:13:35", "2025-06-22 03:13:35", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750562015;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750562015;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-22 03:13:54", "2025-06-22 03:13:54", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("9052", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-22 03:13:41", "2025-06-22 03:13:41", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750562021;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750562021;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-22 03:14:00", "2025-06-22 03:14:00", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("9053", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-22 03:18:54", "2025-06-22 03:18:54", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750562334;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750562334;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-22 03:25:07", "2025-06-22 03:25:07", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("9054", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-22 03:19:00", "2025-06-22 03:19:00", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750562340;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750562340;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-22 03:39:16", "2025-06-22 03:39:16", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("9055", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-22 03:30:07", "2025-06-22 03:30:07", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750563007;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750563007;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-22 03:39:22", "2025-06-22 03:39:22", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("9056", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-22 03:44:16", "2025-06-22 03:44:16", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750563856;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750563856;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-22 03:55:35", "2025-06-22 03:55:35", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("9057", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-22 03:44:22", "2025-06-22 03:44:22", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750563862;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750563862;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-22 03:55:41", "2025-06-22 03:55:41", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("9058", "woocommerce_refresh_order_count_cache", "complete", "2025-06-22 15:55:29", "2025-06-22 15:55:29", "10", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750607729;s:18:\"\0*\0first_timestamp\";i:1750259475;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750607729;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "10", "1", "2025-06-22 15:55:52", "2025-06-22 15:55:52", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("9059", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-22 04:00:35", "2025-06-22 04:00:35", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750564835;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750564835;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-22 04:17:14", "2025-06-22 04:17:14", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("9060", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-22 04:00:41", "2025-06-22 04:00:41", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750564841;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750564841;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-22 04:29:53", "2025-06-22 04:29:53", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("9061", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-22 04:22:14", "2025-06-22 04:22:14", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750566134;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750566134;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-22 04:29:59", "2025-06-22 04:29:59", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("9062", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-22 04:34:53", "2025-06-22 04:34:53", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750566893;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750566893;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-22 04:41:15", "2025-06-22 04:41:15", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("9063", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-22 04:34:59", "2025-06-22 04:34:59", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750566899;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750566899;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-22 04:41:21", "2025-06-22 04:41:21", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("9064", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-22 04:46:15", "2025-06-22 04:46:15", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750567575;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750567575;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-22 05:05:37", "2025-06-22 05:05:37", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("9065", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-22 04:46:21", "2025-06-22 04:46:21", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750567581;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750567581;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-22 05:08:40", "2025-06-22 05:08:40", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("9066", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-22 05:10:37", "2025-06-22 05:10:37", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750569037;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750569037;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-22 05:19:42", "2025-06-22 05:19:42", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("9067", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-22 05:13:40", "2025-06-22 05:13:40", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750569220;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750569220;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-22 05:19:48", "2025-06-22 05:19:48", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("9068", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-22 05:24:42", "2025-06-22 05:24:42", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750569882;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750569882;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-22 05:37:10", "2025-06-22 05:37:10", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("9069", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-22 05:24:48", "2025-06-22 05:24:48", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750569888;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750569888;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-22 05:37:16", "2025-06-22 05:37:16", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("9070", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-22 05:42:10", "2025-06-22 05:42:10", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750570930;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750570930;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-22 05:46:59", "2025-06-22 05:46:59", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("9071", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-22 05:42:16", "2025-06-22 05:42:16", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750570936;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750570936;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-22 05:47:06", "2025-06-22 05:47:06", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("9072", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-22 05:51:59", "2025-06-22 05:51:59", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750571519;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750571519;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-22 05:54:10", "2025-06-22 05:54:10", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("9073", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-22 05:52:06", "2025-06-22 05:52:06", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750571526;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750571526;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-22 05:54:16", "2025-06-22 05:54:16", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("9074", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-22 05:59:10", "2025-06-22 05:59:10", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750571950;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750571950;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-22 06:20:04", "2025-06-22 06:20:04", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("9075", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-22 05:59:16", "2025-06-22 05:59:16", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750571956;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750571956;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-22 06:34:47", "2025-06-22 06:34:47", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("9076", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-22 06:25:04", "2025-06-22 06:25:04", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750573504;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750573504;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-22 06:34:53", "2025-06-22 06:34:53", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("9077", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-22 06:39:47", "2025-06-22 06:39:47", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750574387;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750574387;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-22 07:24:31", "2025-06-22 07:24:31", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("9078", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-22 06:39:53", "2025-06-22 06:39:53", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750574393;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750574393;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-22 07:25:55", "2025-06-22 07:25:55", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("9079", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-22 07:29:31", "2025-06-22 07:29:31", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750577371;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750577371;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-22 08:08:22", "2025-06-22 08:08:22", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("9080", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-22 07:30:55", "2025-06-22 07:30:55", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750577455;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750577455;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-22 08:08:28", "2025-06-22 08:08:28", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("9081", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-22 08:13:22", "2025-06-22 08:13:22", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750580002;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750580002;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-22 08:13:39", "2025-06-22 08:13:39", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("9082", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-22 08:13:28", "2025-06-22 08:13:28", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750580008;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750580008;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-22 08:13:45", "2025-06-22 08:13:45", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("9083", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-22 08:18:39", "2025-06-22 08:18:39", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750580319;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750580319;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-22 08:20:12", "2025-06-22 08:20:12", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("9084", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-22 08:18:45", "2025-06-22 08:18:45", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750580325;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750580325;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-22 08:34:31", "2025-06-22 08:34:31", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("9085", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-22 08:25:12", "2025-06-22 08:25:12", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750580712;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750580712;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-22 08:34:37", "2025-06-22 08:34:37", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("9086", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-22 08:39:31", "2025-06-22 08:39:31", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750581571;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750581571;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-22 09:07:22", "2025-06-22 09:07:22", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("9087", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-22 08:39:37", "2025-06-22 08:39:37", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750581577;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750581577;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-22 09:07:28", "2025-06-22 09:07:28", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("9088", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-22 09:12:22", "2025-06-22 09:12:22", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750583542;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750583542;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-22 09:31:49", "2025-06-22 09:31:49", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("9089", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-22 09:12:28", "2025-06-22 09:12:28", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750583548;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750583548;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-22 09:31:55", "2025-06-22 09:31:55", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("9090", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-22 09:36:49", "2025-06-22 09:36:49", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750585009;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750585009;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-22 09:39:48", "2025-06-22 09:39:48", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("9091", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-22 09:36:55", "2025-06-22 09:36:55", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750585015;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750585015;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-22 09:39:56", "2025-06-22 09:39:56", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("9092", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-22 09:44:48", "2025-06-22 09:44:48", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750585488;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750585488;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-22 10:24:18", "2025-06-22 10:24:18", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("9093", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-22 09:44:56", "2025-06-22 09:44:56", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750585496;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750585496;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-22 10:24:25", "2025-06-22 10:24:25", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("9094", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-22 10:29:18", "2025-06-22 10:29:18", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750588158;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750588158;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-22 10:43:53", "2025-06-22 10:43:53", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("9095", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-22 10:29:25", "2025-06-22 10:29:25", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750588165;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750588165;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-22 10:43:59", "2025-06-22 10:43:59", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("9096", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-22 10:48:53", "2025-06-22 10:48:53", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750589333;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750589333;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-22 11:04:52", "2025-06-22 11:04:52", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("9097", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-22 10:48:59", "2025-06-22 10:48:59", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750589339;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750589339;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-22 11:05:07", "2025-06-22 11:05:07", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("9098", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-22 11:09:52", "2025-06-22 11:09:52", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750590592;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750590592;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-22 11:19:14", "2025-06-22 11:19:14", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("9099", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-22 11:10:07", "2025-06-22 11:10:07", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750590607;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750590607;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-22 11:19:20", "2025-06-22 11:19:20", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("9100", "wpforms_email_summaries_fetch_info_blocks", "complete", "2025-06-29 11:19:07", "2025-06-29 11:19:07", "10", "{\"tasks_meta_id\":null}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1751195947;s:18:\"\0*\0first_timestamp\";i:1744412523;s:13:\"\0*\0recurrence\";i:604800;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1751195947;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:604800;}", "3", "1", "2025-06-29 11:56:33", "2025-06-29 11:56:33", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("9101", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-22 11:24:14", "2025-06-22 11:24:14", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750591454;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750591454;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-22 11:36:39", "2025-06-22 11:36:39", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("9102", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-22 11:24:20", "2025-06-22 11:24:20", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750591460;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750591460;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-22 11:36:45", "2025-06-22 11:36:45", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("9103", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-22 11:41:39", "2025-06-22 11:41:39", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750592499;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750592499;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-22 11:51:38", "2025-06-22 11:51:38", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("9104", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-22 11:41:45", "2025-06-22 11:41:45", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750592505;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750592505;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-22 11:51:44", "2025-06-22 11:51:44", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("9105", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-22 11:56:38", "2025-06-22 11:56:38", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750593398;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750593398;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-22 12:01:29", "2025-06-22 12:01:29", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("9106", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-22 11:56:44", "2025-06-22 11:56:44", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750593404;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750593404;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-22 12:16:25", "2025-06-22 12:16:25", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("9107", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-22 12:06:29", "2025-06-22 12:06:29", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750593989;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750593989;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-22 12:16:31", "2025-06-22 12:16:31", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("9108", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-22 12:21:25", "2025-06-22 12:21:25", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750594885;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750594885;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-22 12:25:05", "2025-06-22 12:25:05", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("9109", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-22 12:21:31", "2025-06-22 12:21:31", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750594891;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750594891;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-22 12:33:41", "2025-06-22 12:33:41", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("9110", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-22 12:30:05", "2025-06-22 12:30:05", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750595405;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750595405;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-22 12:33:46", "2025-06-22 12:33:46", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("9111", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-22 12:38:41", "2025-06-22 12:38:41", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750595921;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750595921;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-22 12:49:35", "2025-06-22 12:49:35", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("9112", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-22 12:38:46", "2025-06-22 12:38:46", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750595926;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750595926;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-22 12:49:41", "2025-06-22 12:49:41", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("9113", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-22 12:54:35", "2025-06-22 12:54:35", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750596875;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750596875;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-22 12:58:29", "2025-06-22 12:58:29", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("9114", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-22 12:54:41", "2025-06-22 12:54:41", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750596881;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750596881;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-22 12:58:35", "2025-06-22 12:58:35", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("9115", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-22 13:03:29", "2025-06-22 13:03:29", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750597409;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750597409;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-22 13:05:27", "2025-06-22 13:05:27", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("9116", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-22 13:03:35", "2025-06-22 13:03:35", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750597415;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750597415;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-22 13:05:32", "2025-06-22 13:05:32", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("9117", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-22 13:10:27", "2025-06-22 13:10:27", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750597827;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750597827;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-22 13:16:39", "2025-06-22 13:16:39", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("9118", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-22 13:10:32", "2025-06-22 13:10:32", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750597832;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750597832;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-22 13:16:45", "2025-06-22 13:16:45", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("9119", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-22 13:21:39", "2025-06-22 13:21:39", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750598499;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750598499;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-22 13:22:43", "2025-06-22 13:22:43", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("9120", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-22 13:21:45", "2025-06-22 13:21:45", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750598505;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750598505;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-22 13:22:49", "2025-06-22 13:22:49", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("9121", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-22 13:27:43", "2025-06-22 13:27:43", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750598863;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750598863;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-22 13:28:47", "2025-06-22 13:28:47", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("9122", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-22 13:27:49", "2025-06-22 13:27:49", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750598869;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750598869;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-22 13:28:54", "2025-06-22 13:28:54", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("9123", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-22 13:33:47", "2025-06-22 13:33:47", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750599227;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750599227;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-22 13:34:47", "2025-06-22 13:34:47", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("9124", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-22 13:33:54", "2025-06-22 13:33:54", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750599234;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750599234;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-22 13:34:53", "2025-06-22 13:34:53", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("9125", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-22 13:39:47", "2025-06-22 13:39:47", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750599587;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750599587;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-22 13:40:46", "2025-06-22 13:40:46", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("9126", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-22 13:39:53", "2025-06-22 13:39:53", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750599593;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750599593;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-22 13:40:52", "2025-06-22 13:40:52", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("9127", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-22 13:45:46", "2025-06-22 13:45:46", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750599946;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750599946;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-22 13:46:43", "2025-06-22 13:46:43", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("9128", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-22 13:45:52", "2025-06-22 13:45:52", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750599952;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750599952;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-22 13:46:48", "2025-06-22 13:46:48", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("9129", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-22 13:51:43", "2025-06-22 13:51:43", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750600303;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750600303;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-22 13:52:41", "2025-06-22 13:52:41", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("9130", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-22 13:51:48", "2025-06-22 13:51:48", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750600308;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750600308;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-22 13:52:47", "2025-06-22 13:52:47", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("9131", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-22 13:57:41", "2025-06-22 13:57:41", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750600661;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750600661;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-22 14:22:09", "2025-06-22 14:22:09", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("9132", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-22 13:57:47", "2025-06-22 13:57:47", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750600667;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750600667;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-22 14:22:15", "2025-06-22 14:22:15", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("9133", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-22 14:27:09", "2025-06-22 14:27:09", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750602429;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750602429;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-22 14:50:13", "2025-06-22 14:50:13", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("9134", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-22 14:27:15", "2025-06-22 14:27:15", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750602435;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750602435;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-22 15:00:03", "2025-06-22 15:00:03", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("9135", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-22 14:55:13", "2025-06-22 14:55:13", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750604113;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750604113;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-22 15:33:04", "2025-06-22 15:33:04", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("9136", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-22 15:05:03", "2025-06-22 15:05:03", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750604703;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750604703;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-22 15:38:27", "2025-06-22 15:38:27", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("9137", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-22 15:38:04", "2025-06-22 15:38:04", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750606684;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750606684;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-22 15:38:33", "2025-06-22 15:38:33", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("9138", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-22 15:43:27", "2025-06-22 15:43:27", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750607007;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750607007;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-22 15:54:13", "2025-06-22 15:54:13", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("9139", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-22 15:43:33", "2025-06-22 15:43:33", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750607013;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750607013;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-22 15:55:52", "2025-06-22 15:55:52", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("9140", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-22 15:59:13", "2025-06-22 15:59:13", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750607953;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750607953;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-22 16:36:07", "2025-06-22 16:36:07", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("9141", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-22 16:00:52", "2025-06-22 16:00:52", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750608052;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750608052;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-22 16:36:20", "2025-06-22 16:36:20", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("9142", "woocommerce_refresh_order_count_cache", "complete", "2025-06-23 03:55:52", "2025-06-23 03:55:52", "10", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750650952;s:18:\"\0*\0first_timestamp\";i:1750259475;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750650952;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "10", "1", "2025-06-23 04:43:25", "2025-06-23 04:43:25", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("9143", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-22 16:41:07", "2025-06-22 16:41:07", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750610467;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750610467;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-22 16:58:02", "2025-06-22 16:58:02", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("9144", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-22 16:41:20", "2025-06-22 16:41:20", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750610480;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750610480;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-22 16:58:08", "2025-06-22 16:58:08", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("9145", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-22 17:03:02", "2025-06-22 17:03:02", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750611782;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750611782;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-22 17:16:57", "2025-06-22 17:16:57", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("9146", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-22 17:03:08", "2025-06-22 17:03:08", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750611788;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750611788;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-22 17:17:04", "2025-06-22 17:17:04", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("9147", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-22 17:21:57", "2025-06-22 17:21:57", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750612917;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750612917;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-22 17:29:37", "2025-06-22 17:29:37", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("9148", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-22 17:22:04", "2025-06-22 17:22:04", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750612924;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750612924;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-22 17:29:43", "2025-06-22 17:29:43", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("9149", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-22 17:34:37", "2025-06-22 17:34:37", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750613677;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750613677;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-22 17:49:09", "2025-06-22 17:49:09", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("9150", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-22 17:34:43", "2025-06-22 17:34:43", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750613683;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750613683;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-22 17:49:15", "2025-06-22 17:49:15", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("9151", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-22 17:54:09", "2025-06-22 17:54:09", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750614849;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750614849;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-22 18:07:18", "2025-06-22 18:07:18", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("9152", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-22 17:54:15", "2025-06-22 17:54:15", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750614855;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750614855;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-22 18:07:23", "2025-06-22 18:07:23", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("9153", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-22 18:12:18", "2025-06-22 18:12:18", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750615938;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750615938;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-22 18:15:10", "2025-06-22 18:15:10", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("9154", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-22 18:12:23", "2025-06-22 18:12:23", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750615943;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750615943;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-22 18:15:16", "2025-06-22 18:15:16", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("9155", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-22 18:20:10", "2025-06-22 18:20:10", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750616410;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750616410;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-22 18:47:29", "2025-06-22 18:47:29", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("9156", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-22 18:20:16", "2025-06-22 18:20:16", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750616416;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750616416;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-22 18:47:35", "2025-06-22 18:47:35", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("9157", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-22 18:52:29", "2025-06-22 18:52:29", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750618349;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750618349;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-22 19:28:44", "2025-06-22 19:28:44", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("9158", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-22 18:52:35", "2025-06-22 18:52:35", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750618355;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750618355;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-22 19:29:05", "2025-06-22 19:29:05", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("9159", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-22 19:33:44", "2025-06-22 19:33:44", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750620824;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750620824;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-22 20:07:28", "2025-06-22 20:07:28", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("9160", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-22 19:34:05", "2025-06-22 19:34:05", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750620845;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750620845;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-22 20:09:34", "2025-06-22 20:09:34", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("9161", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-22 20:12:28", "2025-06-22 20:12:28", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750623148;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750623148;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-22 20:38:31", "2025-06-22 20:38:31", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("9162", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-22 20:14:34", "2025-06-22 20:14:34", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750623274;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750623274;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-22 20:38:37", "2025-06-22 20:38:37", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("9163", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-22 20:43:31", "2025-06-22 20:43:31", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750625011;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750625011;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-22 21:20:56", "2025-06-22 21:20:56", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("9164", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-22 20:43:37", "2025-06-22 20:43:37", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750625017;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750625017;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-22 21:21:02", "2025-06-22 21:21:02", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("9165", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-22 21:25:56", "2025-06-22 21:25:56", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750627556;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750627556;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-22 22:32:36", "2025-06-22 22:32:36", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("9166", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-22 21:26:02", "2025-06-22 21:26:02", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750627562;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750627562;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-22 22:49:03", "2025-06-22 22:49:03", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("9167", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-22 22:37:36", "2025-06-22 22:37:36", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750631856;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750631856;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-22 22:49:09", "2025-06-22 22:49:09", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("9168", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-22 22:54:03", "2025-06-22 22:54:03", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750632843;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750632843;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-22 22:55:15", "2025-06-22 22:55:15", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("9169", "woocommerce_cleanup_draft_orders", "complete", "2025-06-23 22:49:03", "2025-06-23 22:49:03", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750718943;s:18:\"\0*\0first_timestamp\";i:1744536626;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750718943;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-06-23 22:50:14", "2025-06-23 22:50:14", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("9170", "wpforms_process_forms_locator_scan", "complete", "2025-06-23 22:49:03", "2025-06-23 22:49:03", "10", "{\"tasks_meta_id\":1}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750718943;s:18:\"\0*\0first_timestamp\";i:1744536754;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750718943;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2025-06-23 22:50:14", "2025-06-23 22:50:14", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("9171", "wpforms_process_purge_spam", "complete", "2025-06-23 22:49:03", "2025-06-23 22:49:03", "10", "{\"tasks_meta_id\":2}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750718943;s:18:\"\0*\0first_timestamp\";i:1744536754;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750718943;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2025-06-23 22:50:14", "2025-06-23 22:50:14", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("9172", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-22 22:54:09", "2025-06-22 22:54:09", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750632849;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750632849;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-22 22:55:22", "2025-06-22 22:55:22", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("9173", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-22 23:00:15", "2025-06-22 23:00:15", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750633215;s:18:\"\0*\0first_timestamp\";i:1748401689;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750633215;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-22 23:02:47", "2025-06-22 23:02:47", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("9174", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-22 23:00:22", "2025-06-22 23:00:22", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1750633222;s:18:\"\0*\0first_timestamp\";i:1744819114;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1750633222;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "8", "1", "2025-06-22 23:30:47", "2025-06-22 23:30:47", "0", NULL);
INSERT INTO `wphx_actionscheduler_actions` VALUES("9175", "image-optimi